<?php
/**
 * @version		$Id: controller.php 19029 2010-10-04 12:28:44Z chdemko $
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

/**
 * Categories view class for the Category package.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_categories
 * @since		1.6
 */
class CategoriesController extends JController
{
	/**
	 * Method to display a view.
	 *
	 * @param	boolean			If true, the view output will be cached
	 * @param	array			An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return	JController		This object to support chaining.
	 * @since	1.5
	 */
	public function display($cachable = false, $urlparams = false)
	{
		// Get the document object.
		$document = JFactory::getDocument();

		// Set the default view name and format from the Request.
		$vName		= JRequest::getWord('view', 'categories');
		$vFormat	= $document->getType();
		$lName		= JRequest::getWord('layout', 'default');
		$extension	= JRequest::getWord('extension', '');

		// Get and render the view.
		if ($view = $this->getView($vName, $vFormat)) {
			
			// Get the model for the view.
			$model = $this->getModel($vName, 'CategoriesModel', array('name' => $vName . '.' . substr($extension, 4)));

			// Push the model into the view (as default).
			$view->setModel($model, true);
			$view->setLayout($lName);

			// Push document object into the view.
			$view->assignRef('document', $document);
			// Load the submenu.
			require_once JPATH_COMPONENT.'/helpers/categories.php';
			CategoriesHelper::addSubmenu($model->getState('filter.extension'));
			$view->display();
		}

		return $this;
	}
}
