/* NT-Cracker 03.24.97 mudge@l0pht.com
   This program takes the smbpassword file or the output generated by
   the excellent program pwdump (author name) and dictionary attacks
   the LANMAN One Way Password - 

  LANMAN One Way Passwords are created in the following fashion:
	. The password is first converted to uppercase
	. If the password is longer than 14 chars (bytes) then it
		is truncated
	. If the password is less than 14 chars (bytes) then it is
		padded with NULL's to 14 bytes.
	. The padded/truncated password is then split in half and each
		half is used to generate an odd parity DES key
	. An 8 byte fixed value is then encrypted with each of the
		DES keys - these two results are concatenated together
		to produce a 16byte hash.

	The fixed value that is encrypted by each of the DES keys is the 
	decryption of the value 0xAAD3B435B51404EE with a key of all zeros.

  Todo: add an entire keyspace attack to guarantee 
        we get all of the passwords
  Todo: Roll this into pwdump and add the ability to try to brute 
        force the administrators passwords on remote machines to obtain 
		full user listings and OWPasswords.
  Todo: GUI for the Windows users - weld's job
  Todo: CLI portable
  Todo: If not bruting - let people know if we couldn't find the passwd in a 
      dictionary and the word is <= 7 chars

  Crikey! Now I see where ECB mode is going to kill them in the NT 
  dialect - this should make bruting either one trivial!

  BIG KUDOS go out to Hobbit@avian.org for his outstanding work in debunking
  CIFS. Without information provided in his paper this program wouldn't be
  here!

  This work is provided by the L0pht - it contains code from the 
  following places:
		. Plenty of original code
		. generic routines from the samba code source
		. md4 routines from RSA
		. DES routines from Eric Young's libdes
*/

#include "includes.h"

extern void fill_user_struct(char *dastring, struct user_struct *da_struct);
extern void str_to_key(unsigned char *,unsigned char *);
extern void usage(char *);
extern void LMword(char *, char *);
extern char * atob(char *, int);
extern int htoi(char c);
int crackntdialect(struct user_struct *Ustruct, char *passwd, int check_case);
void md4hash(unsigned char *passwd, unsigned char *p16, int len);
extern int PutUniCode(char *dst,char *src);
void fx(struct user_struct *, char *str, int pos, int finished);
void chcase(char *str, int pos);
void LowerString(char *holder, char *word);
void printuser(struct user_struct *Ustruct, FILE *file);
int cracklanman(struct user_struct *Ustruct, char *dict_word, char *tmphash);
extern int isvalid_userline(char *user_entry);
extern struct user_struct * init_linked_list();
extern void add_list_struct(struct user_struct *, char *);
extern struct user_struct * remove_from_list(struct user_struct *);
extern struct user_struct * rewind_list(struct user_struct *);
extern void print_and_prune(struct user_struct *record, FILE *outlist);
extern void build_linked_list(struct user_struct *head, FILE *pwlist);
extern struct user_struct * filter_disabled(struct user_struct *head, FILE *outlist);
extern struct user_struct * filter_nopasswd(struct user_struct *head, FILE *outlist);
extern struct user_struct * setup_linked_list(FILE *pwlist, FILE *outlist);
int lanman(struct user_struct *index, char *dict_word, FILE *outlist);
int nt(struct user_struct *index, char *dict_word, FILE *outlist);
int lanman_and_nt(struct user_struct *index, char *dict_word, FILE *outlist);
extern void free_struct_list(struct user_struct *);
int brute_lanman(struct user_struct *Ustruct, FILE *outlist);
void half_lanman(char *, char *);
int brute_routine(struct user_struct *head, char *half_hash, char *, int iter);
extern void nt_ify_list(struct user_struct *head);
extern void print_hits(struct user_struct *head, FILE *outlist);
extern struct user_struct * prune_list(struct user_struct *head);



/* Global str_to_crypt - this is what is encrypted with each of the 
   odd parity DES keys for LANMAN - It is derived by decrypting the 
   fixed byte quantity 0xAAD3B435B51404EE with a key
   of all 0's ie:
   	
	fixed_key[] = "\xAA\xD3\xB4\x35\xB5\x14\x04\xEE";
	memset(deskey3, '\0', sizeof(deskey3)); - key of all 0's
	des_set_key((des_cblock *)deskey3, ks3); 
	des_ecb_encrypt((des_cblock *)fixed_key,
  	    (des_cblock *)str_to_crypt, ks3, DES_DECRYPT);
*/

char str_to_crypt[] = "\x4b\x47\x53\x21\x40\x23\x24\x25";

void main(int argc, char **argv) {
	FILE *pwlist, *wordlist, *outlist;
	char dict_word[MAX_WORD];
	char *pwfile, *wordfile, *outfile;
	struct user_struct *head, *index, *foo, *bar;
	extern char *optarg;
	int c, pcount=0, wcount=0, ocount=0, brute=0;
	int gotlanman=0, gotnt=0, lanonly=0, ntonly=0;
	
	while ( (c = getopt(argc, argv, "p:w:blno:")) != EOF){
		switch(c) {
		case 'p': /* passwd file from pwdump */
			pwfile = optarg;
			pcount++;
			break;
		case 'w': /* dictionary of words */
			wordfile = optarg;
			wcount++;
			break;
		case 'o': /* output file */
			outfile = optarg;
			ocount++;
			break;
		case 'l': /* crack LANMAN password ONLY */
			lanonly++;
			break;
		case 'n': /* crack NT Dialect only - dumb - 
			     better performance cracking both */
			ntonly++;
			break;
		case 'b': /* brute force through keyspace */
			brute++;
			break;
		default:
			usage(argv[0]);
		}
	}

	if (pcount == 0)
		usage(argv[0]);
	else if ((wcount == 0 && brute == 0) || (wcount > 0 && brute > 0))
		usage(argv[0]);

	if (lanonly > 0 && ntonly > 0)
		usage(argv[0]);

	if ((pwlist = fopen(pwfile, "r")) == NULL){ 
		fprintf(stderr, "Error: could not open %s\n", pwfile);
		exit(1);
	}
	if (wcount > 0 ) {
	  if ((wordlist = fopen(wordfile, "r")) == NULL){
	  	  fprintf(stderr, "Error: could not open %s\n", wordfile);
		  exit(1);
	  }
	}
	
	if (ocount > 0){
		if ((outlist = fopen(outfile, "w")) == NULL){
			fprintf(stderr, "Error: could not open %s\n", outfile);
			exit(1);
		}
	} else
		outlist = stdout;

	head = setup_linked_list(pwlist, outlist);

	foo = index = head;


	/* main loop */

	head = rewind_list(index);
	index = foo = bar = head;

	if (head == NULL){
		fprintf(stderr, "Done\n");
		exit(1);
	}

	if (brute){
		brute_lanman(index, outlist);
	}else{

#ifdef FUNKY
	while (bar != NULL){
  		while(fgets(dict_word, MAX_WORD, wordlist) != NULL) {
			if (lanonly > 0){
				if (lanman(index, dict_word, outlist) == 1)
					break;
			} else if (ntonly > 0) {
				if (nt(index, dict_word, outlist) == 1)
					break;
			} else {
				if (lanman_and_nt(index, dict_word, outlist) == 1)
					break;
				}	
			}
			rewind(wordlist);
			if (index->next == NULL){
				bar = NULL;
			}else{
				index = index->next;
			}
		}
	
#else
		while (fgets(dict_word, MAX_WORD, wordlist) != NULL) {

			head = rewind_list(index);
			index = foo = bar =  head;
			
			if (head == NULL){
				fprintf(stderr, "Done\n");
				exit(1);
			}

			while (bar != NULL){
				if (lanonly){
					lanman(index, dict_word, outlist);
				} else if (ntonly) {
					nt(index, dict_word, outlist);
				} else {
					lanman_and_nt(index, dict_word, outlist);				
				}	
				if (index->next == NULL){
					bar = NULL;
				}else{
					index = index->next;
				}
			} 
		
		}
#endif
	} /* else from brute_lanman */	

	head = rewind_list(index);
	free_struct_list(head);

	if (ocount > 0)
		fclose(outlist);
	if (wcount > 0)
		fclose(wordlist);
	if (pcount > 0)
		fclose(pwlist);
}

/* routine to check the LANMAN passwd */
int cracklanman(struct user_struct *Ustruct, char *dict_word, char *fullhash){
	unsigned char passwd[14];
	unsigned char lanman[16];
	des_cblock deskey1, deskey2;
	des_key_schedule ks1, ks2;

	memset(passwd, '\0', sizeof(passwd));
	memset(lanman, '\0', sizeof(lanman));

	LMword((char *)passwd, dict_word); /* uppercases and 
			truncs/concats word into passwd */
	
	str_to_key(passwd, deskey1);  /* create the first 8byte odd 
					parity des key */
	des_set_key((des_cblock *)deskey1,ks1); /* setup the key schedule */

	des_ecb_encrypt((des_cblock *)str_to_crypt, /* encrypt the known 
							8byte value */
		(des_cblock *)lanman, ks1, DES_ENCRYPT); /* against the 
							first des key */

	str_to_key(&(passwd[7]), deskey2);
	des_set_key((des_cblock *)deskey2,ks2);

	des_ecb_encrypt((des_cblock *)str_to_crypt,
		(des_cblock *)&lanman[8], ks2, DES_ENCRYPT);

	strncpy(fullhash, lanman, sizeof(lanman));

	if (memcmp(Ustruct->lmhashb, lanman, sizeof(lanman)) == 0){
		strncpy(Ustruct->lmpasswd, passwd, LMPASSWDLEN);
		return(1);
	}
	return(0);
}

/* routine to check the md4 NT dialect passwd derived from the 
   succesfull LANMAN passwd.  returns 1 if succesfull, 0 otherwise  - 
   if check case is > 0 then all possible permutations of upper/lower 
   are tried, if <=0 then just try the word in the case that we recieved 
   it in. */
int crackntdialect(struct user_struct *Ustruct, char *passwd, int check_case){
	
	char ntpasswd[129]; 
	char *hold;
	unsigned char *p16;
	int pos, uni_len;

	memset(ntpasswd, '\0', sizeof(ntpasswd));

	if (check_case){ /* go through the possible case sensitive perms */
	  LowerString(ntpasswd, passwd);
	  pos = strlen(passwd) -1;
	  fx(Ustruct, ntpasswd, pos, 0);
	}else{ /* not interested in case sensitivity - just try the dict word as
		      we have it */

		if (passwd[strlen(passwd)-1] == '\n') /* strip the \n - this 
				is done in LowerString for the case sensitive
				 check */
		  passwd[strlen(passwd)-1] = '\0';

		hold = (char *)malloc(NTPASSWDLEN * 2); /* grab space for 
							unicode */
		if (hold == NULL){
			fprintf(stderr, "out of memory...crackntdialog hold\n");
			exit(1);
		}

		uni_len = PutUniCode(hold, passwd); /* convert to 
						unicode and return correct 
						unicode length for md4 */
		
		p16 = (unsigned char*)malloc(16); /* grab space for md4 hash */
		if (p16 == NULL){
			fprintf(stderr, "out of memory...crackntdialect p16\n");
			exit(1);
		}

  		md4hash(hold, p16, uni_len);
		if (memcmp(p16, &Ustruct->nthashb, 16) == 0)
			strncpy(Ustruct->ntpasswd, passwd, NTPASSWDLEN);

		free(p16);
		free(hold);
	}

	if (strlen(Ustruct->ntpasswd) > 0){
		Ustruct->ntdone = 1;
		return(1);
	} else
		return(0);
}

/* Recursively check all variations on case as the NT Dialect passwd is case
   sensitive. This isn't too bad as the total possible perms is only 2 to the 
   power of strlen(wordtocompare). We really need to make this iterative 
   to save on memory and increase speed. If the function finds a match it
   puts it in Ustruct->ntpasswd. */
void fx(struct user_struct *Ustruct, char *str, int pos, int finished){
	char *tmp;
	char *hold;
	unsigned char *p16;
	int uni_len;

	if (finished == 1)
		return;

	tmp = (char *)malloc(strlen(str)+1);
	if (tmp == NULL){
		fprintf(stderr, "out of memory...fx malloc tmp\n");
		exit(1);
	}
	memset(tmp, '\0', strlen(str)+1);
	strcpy(tmp, str);

	if ( pos < 0){
		hold = (char *)malloc(NTPASSWDLEN * 2);
		if (hold == NULL){
			fprintf(stderr, "malloc failed in fx for hold\n");
			exit(1);
		}
		
		uni_len = PutUniCode(hold, tmp);
		
		p16 = (unsigned char *)malloc(16);
		if (p16 == NULL){
			fprintf(stderr, "out of memory...fx malloc p16\n");
			exit(1);
		}
		md4hash(hold, p16, uni_len);
		if (memcmp(p16, &Ustruct->nthashb, 16) == 0){
			strncpy(Ustruct->ntpasswd, tmp, NTPASSWDLEN);
			finished=1;
		}
		free(p16);
		free(hold);
		return;
	}
	fx(Ustruct, tmp, pos - 1, finished);
	chcase(tmp, pos);
	fx(Ustruct, tmp, pos - 1, finished);
	free(tmp);
	return;
}

/* 
 * Creates the MD4 Hash of the users password in NT UNICODE.
 */
 
void md4hash(unsigned char *passwd, unsigned char *p16, int len)
{
	int i=0;
	MDstruct MD;
  
	MDbegin(&MD);
	for(i = 0; i + 64 <= len; i += 64){
		MDupdate(&MD,passwd + (i/2), 512);
	}
	MDupdate(&MD,passwd + (i/2),(len-i)*8);
/*	MDprint(&MD); 
	   printf("\n");  */
	SIVAL(p16,0,MD.buffer[0]);
	SIVAL(p16,4,MD.buffer[1]);
	SIVAL(p16,8,MD.buffer[2]);
	SIVAL(p16,12,MD.buffer[3]);
}


void LowerString(char *holder, char *word){
	size_t i;

	if (strlen(word) > 128)
		word[128] = '\0';

	for (i=0; i < (strlen(word)); i++){
		if (isupper(word[i]))
		  holder[i] = tolower(word[i]);
		else
		  holder[i] = word[i];
	}
	if (holder[strlen(word)-1] == '\n')
	  holder[strlen(word)-1] = '\0';

}

void chcase(char *str, int pos){
	str[pos] = toupper(str[pos]);
}

void printuser(struct user_struct *Ustruct, FILE *file){
  if (Ustruct->already_printed == 1)
	return;
  else {
	fprintf(file, "User: [%s] Lanman PW: [%s] NT dialect PW: [%s]\n",
		Ustruct->username, Ustruct->lmpasswd, Ustruct->ntpasswd);
		Ustruct->already_printed = 1;
		fflush(file);
	}
}

int lanman(struct user_struct *index, char *dict_word, FILE *outlist){

	struct user_struct *foo;
	char match_lmpasswd[14], match_lmhash[32], tmphash[16];
	int ret=0;

	if (index->lmdone == 1){
		printuser(index, outlist);
		return(1);
	}else{
		if (cracklanman(index, dict_word, tmphash) == 1){
			printuser(index, outlist);
			index->lmdone = 1;
			strcpy(match_lmpasswd, index->lmpasswd);
			memcpy(match_lmhash, index->lmhash, 32);
			ret = 1;
		}		
		foo = index->next;
		while (foo != NULL){
			if (memcmp(foo->lmhashb, tmphash, 16) == 0){
				LMword(match_lmpasswd, dict_word);
				strcpy(foo->lmpasswd, match_lmpasswd);
				foo->lmdone = 1;
				foo = foo->next;
			} else {
				foo = foo->next;
			}
		}

	}
	return(ret);
}

int nt(struct user_struct *index, char *dict_word, FILE *outlist){
	struct user_struct *foo;
	char match_ntpasswd[129], match_nthash[32];
	
	if (index->ntdone == 1){
		printuser(index, outlist);
		return(1);
	}else{
		if (crackntdialect(index, dict_word, 0) == 1){
			printuser(index, outlist);
			index->ntdone = 1;
			strcpy(match_ntpasswd, index->ntpasswd);
			memcpy(match_nthash, index->nthash, 32);
			foo = index->next;
			while (foo != NULL){
				if (memcmp(foo->nthash, match_nthash, 32) == 0){
					strcpy(foo->ntpasswd, match_ntpasswd);
					foo->ntdone = 1;
					foo = foo->next;
				}else{
					foo = foo->next;
				}
			}
			return(1);
		}
		return(0);
	}
}

int lanman_and_nt(struct user_struct *index, char *dict_word, FILE *outlist){

	struct user_struct *foo;
	char match_lmpasswd[15], match_lmhash[32];
	char tmphash[16];
	int ret=0;

	if (index->lmdone == 1){
		printuser(index, outlist);
		return(1);
	}else{
		if (cracklanman(index, dict_word, tmphash) == 1){
			index->lmdone = 1;
			strcpy(match_lmpasswd, index->lmpasswd);
			memcpy(match_lmhash, index->lmhash, 32);
			if (crackntdialect(index, index->lmpasswd, 1) == 1){
				printuser(index, outlist);
				index->ntdone = 1;
			}
			ret = 1;
		}		
		foo = index->next;
		while (foo != NULL){
			if (memcmp(foo->lmhashb, tmphash, 16) == 0){
				LMword(match_lmpasswd, dict_word);
				strcpy(foo->lmpasswd, match_lmpasswd);
				foo->lmdone = 1;
				crackntdialect(foo, foo->lmpasswd, 1);
				foo = foo->next;
			} else {
				foo = foo->next;
			}
		}

	}
	return(ret);
}

int brute_lanman(struct user_struct *head, FILE *outlist){
	char brute_str[7];
	char all_chars[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 `~!@#$%^&()_-{}\"'.";
	char half_hash[8];
	struct user_struct *index;
	int i,x,j,k,l,m,n,o,iter, positive=0;
	int size;

	size = strlen(all_chars);

	index = head;

	memset(brute_str, '\0', sizeof(brute_str));
/*	memset(all_chars, '\0', sizeof(all_chars)); */

	printf("\nThis build using characters [%s] for keyspace.\n",
		all_chars);
	printf("beginning bruter (this may take a while\)\n\n");

/* setup the string with all possible chars -- make sure you give 
   it size 69 for this 
	for (i=32, x=0; i<=96; i++, x++)
		all_chars[x] = i;
	for (i=123; i<=126; i++, x++)
		all_chars[x] = i;
*/
	/* round one - one char password */

#ifdef _DEBUG
	printf("entering round 1\n");
#endif
	iter = 1;
	for (i=0; i<size; i++){
		brute_str[0] = all_chars[i];
		half_lanman(half_hash, brute_str);
		if (brute_routine(index, half_hash, brute_str, iter) == 1){
#ifdef _DEBUG
			printf("gotone in round %d\n", iter);
#endif
			nt_ify_list(index);
			print_hits(index, outlist);
			head = prune_list(index);
			if (!head)
				return(1);
			else
				index = head;
		}
	}

	/* if positive prune list */
	positive = 0;

	index = head;

#ifdef _DEBUG
	printf("entering round 2\n");
#endif
	/* round two - two char password */
	iter = 2;

	for (i=0; i<size; i++){
		brute_str[0] = all_chars[i];
		for (j=0; j<size; j++){
			brute_str[1] = all_chars[j];
			half_lanman(half_hash, brute_str);
			if (brute_routine(index, half_hash, brute_str, iter) == 1){
#ifdef _DEBUG
				printf("gotone in round %d\n", iter);
#endif
				nt_ify_list(index);
				print_hits(index, outlist);
				head = prune_list(index);
				if (!head)
					return(1);
				else
					index = head;
			}
		}
	}

#ifdef _DEBUG
	printf("entering round 3\n");
#endif
	/* round three - three char password */
	iter = 3;

	for (i=0; i<size; i++){
		brute_str[0] = all_chars[i];
		for (j=0; j<size; j++){
			brute_str[1] = all_chars[j];
			for (k=0; k<size; k++){
				brute_str[2] = all_chars[k];
				half_lanman(half_hash, brute_str);
				if (brute_routine(index, half_hash, brute_str, iter) == 1){
#ifdef _DEBUG
					printf("gotone in round %d\n", iter);
#endif
					nt_ify_list(index);
					print_hits(index, outlist);
					head = prune_list(index);
					if (!head)
						return(1);
					else
						index = head;
				}
			}
		}	
#ifdef _DEBUG
		printf("%d ", i);
#endif
	}
#ifdef _DEBUG
	printf("\n");
#endif

#ifdef _DEBUG
	printf("entering round 4\n");
#endif
	/* round four - four char password */
	iter = 4;
	for (i=0; i<size; i++){
		brute_str[0] = all_chars[i];
		for (j=0; j<size; j++){
			brute_str[1] = all_chars[j];
			for (k=0; k<size; k++){
				brute_str[2] = all_chars[k];
				for (l=0; l<size; l++){
					brute_str[3] = all_chars[l];
					half_lanman(half_hash, brute_str);
					if (brute_routine(index, half_hash, brute_str, iter) == 1){
#ifdef _DEBUG
						printf("gotone in round %d\n", iter);
#endif
						nt_ify_list(index);
						print_hits(index, outlist);
						head = prune_list(index);
						if (!head)
							return(1);
						else
							index = head;
					}
				}
			}
		}
#ifdef _DEBUG
		printf("%d ", i);
#endif
	}
#ifdef _DEBUG
	printf("\n");
#endif

#ifdef _DEBUG
	printf("entering round 5\n");
#endif
	/* round five - five char password */
	iter = 5;
	for (i=0; i<size; i++){
		brute_str[0] = all_chars[i];
		for (j=0; j<size; j++){
			brute_str[1] = all_chars[j];
			for (k=0; k<size; k++){
				brute_str[2] = all_chars[k];
				for (l=0; l<size; l++){
					brute_str[3] = all_chars[l];
					for (m=0; m<size; m++){
						brute_str[4] = all_chars[m];
						half_lanman(half_hash, brute_str);
						if (brute_routine(index, half_hash, brute_str, iter) == 1){
#ifdef _DEBUG
							printf("gotone in round %d\n", iter);
#endif
							nt_ify_list(index);
							print_hits(index, outlist);
							head = prune_list(index);
							if (!head)
								return(1);
							else
								index = head;
						}
					}
				}
			}
#ifdef _DEBUG
			printf("j%d ", j);
#endif
		}
#ifdef _DEBUG
		printf("i%d ", i);
#endif
	}
#ifdef _DEBUG
	printf("\n");
#endif

#ifdef _DEBUG
	printf("entering round 6\n");
#endif
	/* round six - six char password */
	iter = 6;
	for (i=0; i<size; i++){
		brute_str[0] = all_chars[i];
		for (j=0; j<size; j++){
			brute_str[1] = all_chars[j];
			for (k=0; k<size; k++){
				brute_str[2] = all_chars[k];
				for (l=0; l<size; l++){
					brute_str[3] = all_chars[l];
					for (m=0; m<size; m++){
						brute_str[4] = all_chars[m];
						for (n=0; n<size; n++){
							brute_str[5] = all_chars[n];
							half_lanman(half_hash, brute_str);
							if (brute_routine(index, half_hash, brute_str, iter) == 1){
#ifdef _DEBUG
								printf("gotone in round %d\n", iter);
#endif
								nt_ify_list(index);
								print_hits(index, outlist);
								head = prune_list(index);
								if (!head)
									return(1);
								else
									index = head;
							}
						}
					}
				}
#ifdef _DEBUG
				printf("k%d ", k);
#endif
			}
#ifdef _DEBUG
			printf("j%d ", j);
#endif
		}
#ifdef _DEBUG
		printf("i%d ", i);
#endif
	}
#ifdef _DEBUG
	printf("\n");
#endif

#ifdef _DEBUG
	printf("entering round 7\n");
#endif
	/* round seven - seven char password */
	iter = 7;
	for (i=0; i<size; i++){
		brute_str[0] = all_chars[i];
		for (j=0; j<size; j++){
			brute_str[1] = all_chars[j];
			for (k=0; k<size; k++){
				brute_str[2] = all_chars[k];
				for (l=0; l<size; l++){
					brute_str[3] = all_chars[l];
					for (m=0; m<size; m++){
						brute_str[4] = all_chars[m];
						for (n=0; n<size; n++){
							brute_str[5] = all_chars[n];
							for (o=0; o<size; o++){
								brute_str[6] = all_chars[o];
								half_lanman(half_hash, brute_str);
								if (brute_routine(index, half_hash, brute_str, iter) == 1){
#ifdef _DEBUG
									printf("gotone in round %d\n", iter);
#endif
									nt_ify_list(index);
									print_hits(index, outlist);
									head = prune_list(index);
									if (!head)
										return(1);
									else
										index = head;
								}
							}
						}
					}
#ifdef _DEBUG
					printf("l%d ", l);
#endif
				}
#ifdef _DEBUG
				printf("k%d ", k);
#endif
			}
#ifdef _DEBUG
			printf("j%d ", j);
#endif
		}
#ifdef _DEBUG
		printf("i%d ", i);
#endif
	}
#ifdef _DEBUG
	printf("\n");
#endif

	return(0);
}

void half_lanman(char *half_hash, char *brute_str){
	unsigned char lanman[8];
	des_cblock deskey1;
	des_key_schedule ks1;


	str_to_key(brute_str, deskey1);  /* create the first 8byte odd parity des key */
	des_set_key((des_cblock *)deskey1,ks1); /* setup the key schedule */

	des_ecb_encrypt((des_cblock *)str_to_crypt, /* encrypt the known 8byte value */
		(des_cblock *)lanman, ks1, DES_ENCRYPT); /* against the first des key */

	memcpy(half_hash, lanman, 8);

}


int brute_routine(struct user_struct *head, char *half_hash, char *brute_str, int iter){
	struct user_struct *index;
	int positive=0;

	index = head;

	while (index != NULL){
	  
	  if (index->under7){
		if (memcmp(index->lmhashb, half_hash, 8) == 0){
			strncpy(index->first_half, brute_str, 7);
			strncpy(index->lmpasswd, brute_str, 7);
			index->lmdone = 1;
			positive = 1;
	/*		printuser(index, outlist); */
		}
	  }else{
		  if (iter == 7){
			  if (strlen(index->first_half) == 0){
				if (memcmp(index->lmhashb, half_hash, 8) == 0){
					strncpy(index->first_half, brute_str, 7);
					if (strlen(index->second_half) != 0){
						positive=1;
					}
				}
			  }
		  }

		  if (strlen(index->second_half) == 0){
			if (memcmp(&index->lmhashb[8], half_hash, 8) == 0){
				  strncpy(index->second_half, brute_str, 7);
#ifdef _DEBUG
				  printf("snagged second half in round %d\n", iter);
#endif
			}
		  }
	  }
	  if (!(index->under7)){
		  if ((strlen(index->first_half) > 0) && (strlen(index->second_half) > 0)){
			  strncpy(index->lmpasswd, index->first_half, 7);
			  strncat(&index->lmpasswd[7], index->second_half, 7);
			  index->lmdone = 1;
			  positive = 1;
		  }
	  }
	  index = index->next;
	}
	return(positive);
}

