/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CStatement
extends OracleStatement {
    static final byte[][][] parameterDatum = null;
    static final OracleTypeADT[][] parameterOtype = null;
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException, IOException {
        if (bl || bl4 || !bl2 || this.sql_kind != 2) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.doOall8");
        if (this.sql_kind != 1 && this.sql_kind != 4 && this.sql_kind != 3 && this.sql_kind != 0 && this.sql_kind != 2) {
            DatabaseError.throwSqlException(439);
        }
        int n = this.number_of_define_positions;
        if (this.sql_kind == 2) {
            n = 0;
        }
        if (bl3 && this.accessors != null) {
            for (int i = 0; i < this.number_of_define_positions; ++i) {
                if (this.accessors[i] == null) continue;
                this.accessors[i].lastRowProcessed = 0;
            }
        }
        this.allocateTmpByteArray();
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        this.oacdefSent = t4C8Oall.init(bl, bl2, bl3, bl4, this.sql_kind, this.cursorId, this.m_sql.getSqlBytes(this.process_escapes), this.row_prefetch, this.outBindAccessors, this.number_of_bind_positions, this.accessors, n, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, parameterDatum, parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent);
        this.t4Connection.sendPiggyBackedMessages();
        t4C8Oall.marshalAll(this.oacdefSent);
        try {
            t4C8Oall.receive();
            this.cursorId = t4C8Oall.getCursorId();
        }
        catch (SQLException sQLException) {
            this.cursorId = t4C8Oall.getCursorId();
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 110);
            }
            throw sQLException;
        }
    }

    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
        this.need_to_parse = true;
    }

    protected void defineColumnTypeInternal(int n, int n2, int n3, short s, boolean bl, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefineColumnType) {
            return;
        }
        if (n < 1) {
            DatabaseError.throwSqlException(3);
        }
        if (bl) {
            if (n2 == 1 || n2 == 12) {
                this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 108);
            }
        } else if (n3 < 0) {
            DatabaseError.throwSqlException(53);
        }
        if (this.current_result_set != null && !this.current_result_set.closed) {
            DatabaseError.throwSqlException(28);
        }
        int n4 = n - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n4) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n4 + 1) * 4];
            } else {
                nArray = new int[(n4 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n4] = n2;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n4) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n4 + 1) * 4];
            } else {
                nArray = new int[(n4 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        this.definedColumnSize[n4] = n3;
        if (this.accessors != null && n4 < this.accessors.length && this.accessors[n4] != null) {
            this.accessors[n4].definedColumnSize = n3;
            if (!(this.accessors[n4].t_type != 96 && this.accessors[n4].t_type != 1 || n2 != 1 && n2 != 12 || n3 > this.accessors[n4].oacmxl)) {
                this.need_to_prepare_define_buffer = true;
                this.columns_defined_by_user = true;
                this.accessors[n4].initForDataAccess(n2, n3, null);
                this.accessors[n4].calculateSizeTmpByteArray();
            }
        }
    }

    public synchronized void clearDefines() throws SQLException {
        super.clearDefines();
        this.definedColumnType = null;
        this.definedColumnSize = null;
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
        int n;
        if (bl) {
            sArray = new short[this.defineIndicators.length];
            n = this.accessors[0].lengthIndexLastRow;
            int n2 = this.accessors[0].indicatorIndexLastRow;
            for (int i = 1; i <= this.accessors.length; ++i) {
                int n3 = n + this.saved_rowPrefetch * i - 1;
                int n4 = n2 + this.saved_rowPrefetch * i - 1;
                sArray[n4] = this.defineIndicators[n4];
                sArray[n3] = this.defineIndicators[n3];
            }
        }
        for (n = 0; n < this.accessors.length; ++n) {
            this.accessors[n].saveDataFromOldDefineBuffers(byArray, cArray, sArray, this.saved_rowPrefetch != -1 ? this.saved_rowPrefetch : this.row_prefetch, this.row_prefetch);
        }
    }

    void do_describe(boolean bl) throws SQLException {
        try {
            this.t4Connection.sendPiggyBackedMessages();
            this.t4Connection.describe.init(this, 0);
            this.t4Connection.describe.marshal();
            this.accessors = this.t4Connection.describe.receive(this.accessors);
            this.number_of_define_positions = this.t4Connection.describe.numuds;
            for (int i = 0; i < this.number_of_define_positions; ++i) {
                this.accessors[i].initMetadata();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        this.describedWithNames = true;
        this.described = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute_for_describe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.execute_for_describe");
        try {
            Object var3_1;
            block7: {
                try {
                    if (this.t4Connection.useFetchSizeWithLongColumn) {
                        this.doOall8(true, true, true, true);
                        break block7;
                    }
                    this.doOall8(true, true, false, true);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(iOException);
                    var3_1 = null;
                    this.rows_processed = this.t4Connection.all8.rowsProcessed;
                    this.valid_rows = this.t4Connection.all8.getNumRows();
                }
            }
            var3_1 = null;
            this.rows_processed = this.t4Connection.all8.rowsProcessed;
            this.valid_rows = this.t4Connection.all8.getNumRows();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.rows_processed = this.t4Connection.all8.rowsProcessed;
            this.valid_rows = this.t4Connection.all8.getNumRows();
            throw throwable;
        }
        this.need_to_parse = false;
        for (int i = 0; i < this.number_of_define_positions; ++i) {
            this.accessors[i].initMetadata();
        }
        this.need_to_prepare_define_buffer = false;
    }

    void execute_maybe_describe() throws SQLException {
        if (!this.t4Connection.useFetchSizeWithLongColumn) {
            super.execute_maybe_describe();
        } else {
            if (this.row_prefetch_changed) {
                if (this.streamList == null && this.row_prefetch != this.defines_batch_size) {
                    this.need_to_prepare_define_buffer = true;
                }
                this.row_prefetch_changed = false;
            }
            if (!this.need_to_prepare_define_buffer) {
                if (this.accessors == null) {
                    this.need_to_prepare_define_buffer = true;
                } else if (this.columns_defined_by_user) {
                    this.need_to_prepare_define_buffer = !this.checkAccessorsUsable();
                }
            }
            boolean bl = false;
            try {
                this.m_isExecuting = true;
                if (this.need_to_prepare_define_buffer) {
                    this.execute_for_describe();
                    bl = true;
                } else {
                    int n = this.accessors.length;
                    for (int i = this.number_of_define_positions; i < n; ++i) {
                        Accessor accessor = this.accessors[i];
                        if (accessor == null) continue;
                        accessor.rowSpaceIndicator = null;
                    }
                    this.execute_for_rows(bl);
                }
            }
            catch (SQLException sQLException) {
                this.need_to_parse = true;
                throw sQLException;
            }
            finally {
                this.m_isExecuting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute_for_rows(boolean bl) throws SQLException {
        try {
            try {
                this.doOall8(this.need_to_parse, !bl, true, false);
                this.need_to_parse = false;
            }
            finally {
                this.valid_rows = this.t4Connection.all8.getNumRows();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void fetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        try {
            this.doOall8(false, false, true, false);
            this.valid_rows = this.t4Connection.all8.getNumRows();
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void continueReadRow(int n) throws SQLException {
        try {
            if (!this.connection.useFetchSizeWithLongColumn) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n);
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 110);
            }
            throw sQLException;
        }
    }

    void do_close() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.do_close");
        try {
            if (this.cursorId != 0) {
                this.t4Connection.cursorToClose[this.t4Connection.cursorToCloseOffset++] = this.cursorId;
                if (this.t4Connection.cursorToCloseOffset >= this.t4Connection.cursorToClose.length) {
                    this.t4Connection.sendPiggyBackedMessages();
                }
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.oacdefSent = null;
    }

    void closeQuery() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    T4CStatement(PhysicalConnection physicalConnection, int n, int n2) throws SQLException {
        super(physicalConnection, 1, physicalConnection.default_row_prefetch, n, n2);
        this.t4Connection = (T4CConnection)physicalConnection;
    }
}

