/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class BaseResultSet
extends OracleResultSet {
    SQLWarning m_warning = null;
    boolean m_autoRefetch = true;
    boolean close_statement_on_close = false;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    BaseResultSet() {
    }

    public boolean absolute(int n) throws SQLException {
        DatabaseError.throwSqlException(75, "absolute");
        return false;
    }

    public void afterLast() throws SQLException {
        DatabaseError.throwSqlException(75, "afterLast");
    }

    public void beforeFirst() throws SQLException {
        DatabaseError.throwSqlException(75, "beforeFirst");
    }

    public void cancelRowUpdates() throws SQLException {
        DatabaseError.throwSqlException(76, "cancelRowUpdates");
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public void closeStatementOnClose() {
        this.close_statement_on_close = true;
    }

    public void deleteRow() throws SQLException {
        DatabaseError.throwSqlException(76, "deleteRow");
    }

    public boolean first() throws SQLException {
        DatabaseError.throwSqlException(75, "first");
        return false;
    }

    public boolean getAutoRefetch() throws SQLException {
        return this.m_autoRefetch;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public synchronized String getCursorName() throws SQLException {
        DatabaseError.check_error(23, "getCursorName");
        return null;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    public void insertRow() throws SQLException {
        DatabaseError.throwSqlException(76, "insertRow");
    }

    public boolean last() throws SQLException {
        DatabaseError.throwSqlException(75, "last");
        return false;
    }

    public void moveToCurrentRow() throws SQLException {
        DatabaseError.throwSqlException(76, "moveToCurrentRow");
    }

    public void moveToInsertRow() throws SQLException {
        DatabaseError.throwSqlException(76, "moveToInsertRow");
    }

    public boolean previous() throws SQLException {
        DatabaseError.throwSqlException(75, "previous");
        return false;
    }

    public void refreshRow() throws SQLException {
        DatabaseError.check_error(23, null);
    }

    public boolean relative(int n) throws SQLException {
        DatabaseError.throwSqlException(75, "relative");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setAutoRefetch(boolean bl) throws SQLException {
        this.m_autoRefetch = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            return;
        }
        if (n == 1001 || n == 1002) {
            DatabaseError.throwSqlException(75, "setFetchDirection(FETCH_REVERSE, FETCH_UNKNOWN)");
        } else {
            DatabaseError.throwSqlException(68, "setFetchDirection");
        }
    }

    public void updateARRAY(int n, ARRAY aRRAY) throws SQLException {
        DatabaseError.throwSqlException(76, "updateARRAY");
    }

    public void updateArray(int n, Array array) throws SQLException {
        DatabaseError.throwSqlException(76, "updateArray");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        DatabaseError.throwSqlException(76, "updateAsciiStream");
    }

    public void updateBFILE(int n, BFILE bFILE) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBFILE");
    }

    public void updateBLOB(int n, BLOB bLOB) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBLOB");
    }

    public void updateBfile(int n, BFILE bFILE) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBfile");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBigDecimal");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBinaryStream");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBlob");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBoolean");
    }

    public void updateByte(int n, byte by) throws SQLException {
        DatabaseError.throwSqlException(76, "updateByte");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        DatabaseError.throwSqlException(76, "updateBytes");
    }

    public void updateCHAR(int n, CHAR cHAR) throws SQLException {
        DatabaseError.throwSqlException(76, "updateCHAR");
    }

    public void updateCLOB(int n, CLOB cLOB) throws SQLException {
        DatabaseError.throwSqlException(76, "updateCLOB");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        DatabaseError.throwSqlException(76, "updateCharacterStream");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        DatabaseError.throwSqlException(76, "updateClob");
    }

    public void updateCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        DatabaseError.throwSqlException(76, "updateCustomDatum");
    }

    public void updateDATE(int n, DATE dATE) throws SQLException {
        DatabaseError.throwSqlException(76, "updateDATE");
    }

    public void updateDate(int n, Date date) throws SQLException {
        DatabaseError.throwSqlException(76, "updateDate");
    }

    public void updateDouble(int n, double d) throws SQLException {
        DatabaseError.throwSqlException(76, "updateDouble");
    }

    public void updateFloat(int n, float f) throws SQLException {
        DatabaseError.throwSqlException(76, "updateFloat");
    }

    public void updateINTERVALDS(int n, INTERVALDS iNTERVALDS) throws SQLException {
        DatabaseError.throwSqlException(76, "updateINTERVALDS");
    }

    public void updateINTERVALYM(int n, INTERVALYM iNTERVALYM) throws SQLException {
        DatabaseError.throwSqlException(76, "updateINTERVALYM");
    }

    public void updateInt(int n, int n2) throws SQLException {
        DatabaseError.throwSqlException(76, "updateInt");
    }

    public void updateLong(int n, long l) throws SQLException {
        DatabaseError.throwSqlException(76, "updateLong");
    }

    public void updateNUMBER(int n, NUMBER nUMBER) throws SQLException {
        DatabaseError.throwSqlException(76, "updateNUMBER");
    }

    public void updateNull(int n) throws SQLException {
        DatabaseError.throwSqlException(76, "updateNull");
    }

    public void updateOPAQUE(int n, OPAQUE oPAQUE) throws SQLException {
        DatabaseError.throwSqlException(76, "updateOPAQUE");
    }

    public void updateORAData(int n, ORAData oRAData) throws SQLException {
        DatabaseError.throwSqlException(76, "updateORAData");
    }

    public void updateObject(int n, Object object) throws SQLException {
        DatabaseError.throwSqlException(76, "updateObject");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        DatabaseError.throwSqlException(76, "updateObject");
    }

    public void updateOracleObject(int n, Datum datum) throws SQLException {
        DatabaseError.throwSqlException(76, "updateOracleObject");
    }

    public void updateRAW(int n, RAW rAW) throws SQLException {
        DatabaseError.throwSqlException(76, "updateRAW");
    }

    public void updateREF(int n, REF rEF) throws SQLException {
        DatabaseError.throwSqlException(76, "updateREF");
    }

    public void updateROWID(int n, ROWID rOWID) throws SQLException {
        DatabaseError.throwSqlException(76, "updateROWID");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        DatabaseError.throwSqlException(76, "updateRef");
    }

    public void updateRow() throws SQLException {
        DatabaseError.throwSqlException(76, "updateRow");
    }

    public void updateSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        DatabaseError.throwSqlException(76, "updateSTRUCT");
    }

    public void updateShort(int n, short s) throws SQLException {
        DatabaseError.throwSqlException(76, "updateShort");
    }

    public void updateString(int n, String string) throws SQLException {
        DatabaseError.throwSqlException(76, "updateString");
    }

    public void updateTIMESTAMP(int n, TIMESTAMP tIMESTAMP) throws SQLException {
        DatabaseError.throwSqlException(76, "updateTIMESTAMP");
    }

    public void updateTIMESTAMPLTZ(int n, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        DatabaseError.throwSqlException(76, "updateTIMESTAMPLTZ");
    }

    public void updateTIMESTAMPTZ(int n, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        DatabaseError.throwSqlException(76, "updateTIMESTAMPTZ");
    }

    public void updateTime(int n, Time time) throws SQLException {
        DatabaseError.throwSqlException(76, "updateTime");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        DatabaseError.throwSqlException(76, "updateTimestamp");
    }
}

