/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobOutputStream
extends OutputStream {
    long m_lobOffset;
    CLOB m_clob;
    byte[] m_buf;
    int m_count;
    int m_bufSize;
    boolean m_isClosed;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public OracleClobOutputStream(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobOutputStream(CLOB cLOB, int n) throws SQLException {
        this(cLOB, n, 1L);
    }

    public OracleClobOutputStream(CLOB cLOB, int n, long l) throws SQLException {
        if (cLOB == null || n <= 0 || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.m_clob = cLOB;
        this.m_lobOffset = l;
        this.m_buf = new byte[n];
        this.m_count = 0;
        this.m_bufSize = n;
        this.m_isClosed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.m_isClosed) {
                DatabaseError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.m_count > 0) {
                char[] cArray = new char[this.m_count];
                int n = 0;
                while (n < this.m_count) {
                    cArray[n] = (char)this.m_buf[n];
                    ++n;
                }
                this.m_lobOffset += (long)this.m_clob.putChars(this.m_lobOffset, cArray);
                this.m_count = 0;
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.m_count >= this.m_buf.length) {
            this.flushBuffer();
        }
        this.m_buf[this.m_count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        int n3 = n;
        int n4 = n3 + Math.min(n2, byArray.length - n);
        while (n3 < n4) {
            int n5 = Math.min(this.m_bufSize - this.m_count, n4 - n3);
            System.arraycopy(byArray, n3, this.m_buf, this.m_count, n5);
            n3 += n5;
            this.m_count += n5;
            if (this.m_count < this.m_bufSize) continue;
            this.flushBuffer();
        }
    }
}

