/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionCacheImpl;

public class OracleConnectionEventListener
implements ConnectionEventListener,
Serializable {
    static final int _CLOSED_EVENT = 1;
    static final int _ERROROCCURED_EVENT = 2;
    private DataSource m_ds = null;
    protected long m_lastCleanupTime = -1L;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public OracleConnectionEventListener() {
        this.m_ds = null;
    }

    public OracleConnectionEventListener(DataSource dataSource) {
        this.m_ds = dataSource;
    }

    protected synchronized void cleanupInvalidConnections(SQLException sQLException) {
        try {
            long l;
            long l2;
            if (this.m_ds != null && this.m_ds instanceof OracleConnectionCacheImpl && (l2 = System.currentTimeMillis()) - this.m_lastCleanupTime > (l = ((OracleConnectionCacheImpl)this.m_ds).getConnectionCleanupInterval()) * 1000L) {
                if (((OracleConnectionCacheImpl)this.m_ds).isFatalConnectionError(sQLException)) {
                    ((OracleConnectionCacheImpl)this.m_ds).closeConnections();
                }
                this.m_lastCleanupTime = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {}
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            if (this.m_ds != null && this.m_ds instanceof OracleConnectionCache) {
                ((OracleConnectionCache)this.m_ds).reusePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {}
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            if (this.m_ds != null && this.m_ds instanceof OracleConnectionCache) {
                ((OracleConnectionCache)this.m_ds).closePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            this.cleanupInvalidConnections(sQLException);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.m_ds = dataSource;
    }
}

