/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache m_oicc = null;
    protected boolean m_timeToLive = true;
    protected boolean m_isSleeping = false;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        this.m_oicc = oracleImplicitConnectionCache;
    }

    public void run() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        while (this.m_timeToLive) {
            try {
                if (this.m_timeToLive && (l = (long)this.m_oicc.getCacheTimeToLiveTimeout()) > 0L) {
                    this.runTimeToLiveTimeout(l);
                }
                if (this.m_timeToLive && (l2 = (long)this.m_oicc.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeout();
                }
                if (this.m_timeToLive && (l3 = (long)this.m_oicc.getCacheAbandonedTimeout()) > 0L) {
                    this.runAbandonedTimeout(l3);
                }
                if (this.m_timeToLive) {
                    this.m_isSleeping = true;
                    try {
                        Thread.sleep(this.m_oicc.getCachePropertyCheckInterval() * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.m_isSleeping = false;
                }
                if (this.m_oicc != null && (l > 0L || l2 > 0L || l3 > 0L)) continue;
                this.m_timeToLive = false;
            }
            catch (SQLException sQLException) {}
        }
    }

    private void runAbandonedTimeout(long l) throws SQLException {
        if (this.m_oicc.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection oraclePooledConnection = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.m_oicc;
            synchronized (oracleImplicitConnectionCache) {
                Object[] objectArray = this.m_oicc.m_checkedOutConnectionList.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[n];
                    OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
                    if (oracleConnection != null) {
                        OracleConnectionCacheCallback oracleConnectionCacheCallback = oracleConnection.getConnectionCacheCallbackObj();
                        if (oracleConnectionCacheCallback != null && (oracleConnection.getConnectionCacheCallbackFlag() == 4 || oracleConnection.getConnectionCacheCallbackFlag() == 1)) {
                            try {
                                oracleConnectionCacheCallback.handleAbandonedConnection(oracleConnection, oracleConnection.getConnectionCacheCallbackPrivObj());
                            }
                            catch (SQLException sQLException) {}
                        } else if ((long)(oracleConnection.getHeartbeatNoChangeCount() * this.m_oicc.getCachePropertyCheckInterval()) > l) {
                            try {
                                this.m_oicc.closeCheckedOutConnection(oraclePooledConnection, true);
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    ++n;
                }
            }
        }
    }

    private void runInactivityTimeout() {
        try {
            this.m_oicc.doForEveryCachedConnection(4);
        }
        catch (SQLException sQLException) {}
    }

    private void runTimeToLiveTimeout(long l) throws SQLException {
        long l2 = 0L;
        long l3 = 0L;
        if (this.m_oicc.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection oraclePooledConnection = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.m_oicc;
            synchronized (oracleImplicitConnectionCache) {
                Object[] objectArray = this.m_oicc.m_checkedOutConnectionList.toArray();
                int n = this.m_oicc.m_checkedOutConnectionList.size();
                int n2 = 0;
                while (n2 < n) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[n2];
                    Connection connection = oraclePooledConnection.getLogicalHandle();
                    if (connection != null) {
                        l3 = ((OracleConnection)connection).getStartTime();
                        l2 = System.currentTimeMillis();
                        if (l2 - l3 > l * 1000L) {
                            try {
                                this.m_oicc.closeCheckedOutConnection(oraclePooledConnection, true);
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

