/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean m_saveAutoCommit = false;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection m_conn = null;
    protected OracleXAConnection xaconnection = null;
    protected int m_timeout = 60;
    protected String m_dblink = null;
    private Connection l_conn = null;
    protected int m_connSavedTxnMode = 0;
    private String synchronizeBeforeRecover = "BEGIN sys.dbms_system.dist_txn_sync(0); END;";
    private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected Vector locallySuspendedTransactions = new Vector();
    protected boolean canBeMigratablySuspended = false;
    protected Xid m_stackedXid = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.m_conn = connection;
        this.xaconnection = oracleXAConnection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    protected void allowGlobalTxnModeOnly(int n) throws XAException {
        if (((OracleConnection)this.m_conn).getTxnMode() != 2) {
            throw new XAException(n);
        }
    }

    protected void allowNoTxnModeOnly(int n) throws XAException {
        if (((OracleConnection)this.m_conn).getTxnMode() != 0) {
            throw new XAException(n);
        }
    }

    protected void checkError(int n) throws OracleXAException {
        if ((n & 0xFFFF) != 0) {
            throw new OracleXAException(n);
        }
    }

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    protected void disallowLocalTxnMode(int n) throws XAException {
        if (((OracleConnection)this.m_conn).getTxnMode() == 1) {
            throw new XAException(n);
        }
    }

    public abstract void end(Xid var1, int var2) throws XAException;

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.m_conn).setTxnMode(2);
    }

    protected void enterNoTxnMode() {
        ((OracleConnection)this.m_conn).setTxnMode(0);
    }

    public abstract void forget(Xid var1) throws XAException;

    public Connection getConnection() {
        return this.m_conn;
    }

    public String getDBLink() {
        return this.m_dblink;
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        Connection connection = null;
        if (!(xAResource instanceof OracleXAResource)) {
            return false;
        }
        connection = ((OracleXAResource)xAResource).getConnection();
        try {
            String string = ((OracleConnection)this.m_conn).getURL();
            String string2 = ((OracleConnection)this.m_conn).getProtocolType();
            if (connection != null) {
                boolean bl = connection.equals(this.m_conn) || ((OracleConnection)connection).getURL().equals(string) || ((OracleConnection)connection).getProtocolType().equals(string2) && string2.equals("kprb");
                return bl;
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        return false;
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void join(Xid xid, int n) throws XAException {
        this.m_timeout = n;
        this.start(xid, 0x200000);
    }

    protected void pop() {
        this.m_stackedXid = null;
        this.enterNoTxnMode();
    }

    public abstract int prepare(Xid var1) throws XAException;

    protected void push(Xid xid) {
        this.m_stackedXid = xid;
        this.enterGlobalTxnMode();
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray;
        boolean bl = false;
        if ((n & 0x1800000) != n) {
            throw new XAException(-5);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<OracleXid> arrayList = new ArrayList<OracleXid>(50);
        try {
            try {
                this.saveTxnMode();
                statement = this.m_conn.createStatement();
                statement.execute(this.synchronizeBeforeRecover);
                resultSet = statement.executeQuery(this.recoverySqlRows);
                while (resultSet.next()) {
                    arrayList.add(new OracleXid(resultSet.getInt(1), resultSet.getBytes(2), resultSet.getBytes(3)));
                }
            }
            catch (SQLException sQLException) {
                throw new XAException(-3);
            }
            xidArray = null;
            this.restoreTxnMode();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.restoreTxnMode();
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {}
        int n2 = arrayList.size();
        xidArray = new Xid[n2];
        System.arraycopy(arrayList.toArray(), 0, xidArray, 0, n2);
        return xidArray;
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        block2: {
            if (!this.savedConnectionAutoCommit || ((OracleConnection)this.m_conn).getTxnMode() == 2) break block2;
            try {
                this.m_conn.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void restoreTxnMode() {
        if (this.m_connSavedTxnMode == 0) {
            ((OracleConnection)this.m_conn).setTxnMode(this.m_connSavedTxnMode);
        }
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void resume(Xid xid, int n) throws XAException {
        this.m_timeout = n;
        this.start(xid, 0x8000000);
    }

    protected void resumeStacked(Xid xid) throws XAException {
        this.restoreTxnMode();
        if (xid != null) {
            this.start(xid, 0x8000000);
        }
    }

    public abstract void rollback(Xid var1) throws XAException;

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        try {
            this.savedConnectionAutoCommit = this.m_conn.getAutoCommit();
            this.m_conn.setAutoCommit(false);
            this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
            this.xaconnection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {}
    }

    protected void saveTxnMode() {
        this.m_connSavedTxnMode = ((OracleConnection)this.m_conn).getTxnMode();
    }

    public synchronized void setConnection(Connection connection) throws XAException {
        this.m_conn = connection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    public void setDBLink(String string) {
        this.m_dblink = string;
    }

    public void setLogicalConnection(Connection connection) {
        this.l_conn = connection;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.m_timeout = n;
        return true;
    }

    public abstract void start(Xid var1, int var2) throws XAException;

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid xid2 = null;
        this.disallowLocalTxnMode(-3);
        this.saveTxnMode();
        if (this.m_stackedXid != null && this.m_stackedXid != xid) {
            xid2 = this.m_stackedXid;
            this.end(xid2, 0x2000000);
        }
        return xid2;
    }

    protected Xid suspendStacked(Xid xid, int n) throws XAException {
        Xid xid2 = null;
        this.allowGlobalTxnModeOnly(-3);
        this.saveTxnMode();
        if (n == 0x4000000 && this.m_stackedXid != null && xid != this.m_stackedXid) {
            xid2 = this.m_stackedXid;
            this.end(xid2, 0x2000000);
            this.start(xid, 0x8000000);
        }
        return xid2;
    }
}

