/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.DatumWithConnection;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class REF
extends DatumWithConnection
implements Ref,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    String m_typename;
    transient StructDescriptor m_descriptor;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public REF(String string, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || string == null) {
            DatabaseError.throwSqlException(68);
        }
        this.m_typename = string;
        this.m_descriptor = null;
        this.setPhysicalConnectionOf(connection);
    }

    public REF(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || structDescriptor == null) {
            DatabaseError.check_error(68);
        }
        this.m_descriptor = structDescriptor;
        this.setPhysicalConnectionOf(connection);
    }

    public Object clone() throws CloneNotSupportedException {
        REF rEF = null;
        try {
            rEF = new REF(this.getBaseTypeName(), (Connection)this.getInternalConnection(), this.getBytes());
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException(sQLException.getMessage());
        }
        return rEF;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        try {
            bl = object instanceof REF && super.equals(object) && this.getBaseTypeName().equals(((REF)object).getSQLTypeName());
        }
        catch (Exception exception) {}
        return bl;
    }

    public String getBaseTypeName() throws SQLException {
        if (this.m_typename == null) {
            if (this.m_descriptor != null) {
                this.m_typename = this.m_descriptor.getName();
            } else {
                DatabaseError.throwSqlException(52);
            }
        }
        return this.m_typename;
    }

    public StructDescriptor getDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            this.m_descriptor = StructDescriptor.createDescriptor(this.m_typename, this.getInternalConnection());
        }
        return this.m_descriptor;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public Object getObject() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc() : null;
        return object;
    }

    public Object getObject(Map map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
        return object;
    }

    public String getSQLTypeName() throws SQLException {
        String string = this.getBaseTypeName();
        return string;
    }

    public synchronized STRUCT getSTRUCT() throws SQLException {
        OracleResultSet oracleResultSet;
        OraclePreparedStatement oraclePreparedStatement;
        STRUCT sTRUCT;
        block3: {
            sTRUCT = null;
            oraclePreparedStatement = (OraclePreparedStatement)this.getInternalConnection().prepareStatement("select deref(:1) from dual");
            oraclePreparedStatement.setRowPrefetch(1);
            oraclePreparedStatement.setREF(1, this);
            oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            try {
                if (oracleResultSet.next()) {
                    sTRUCT = oracleResultSet.getSTRUCT(1);
                    break block3;
                }
                DatabaseError.throwSqlException(52);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                oracleResultSet.close();
                oracleResultSet = null;
                oraclePreparedStatement.close();
                oraclePreparedStatement = null;
                throw throwable;
            }
        }
        Object var5_4 = null;
        oracleResultSet.close();
        oracleResultSet = null;
        oraclePreparedStatement.close();
        oraclePreparedStatement = null;
        return sTRUCT;
    }

    public Object getValue() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc() : null;
        return object;
    }

    public Object getValue(Map map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
        return object;
    }

    public int hashCode() {
        int n;
        block4: {
            byte[] byArray;
            block5: {
                block3: {
                    byArray = this.shareBytes();
                    n = 0;
                    if ((byArray[2] & 5) != 5) break block3;
                    int n2 = 0;
                    while (n2 < 4) {
                        n *= 256;
                        n += byArray[8 + n2] & 0xFF;
                        ++n2;
                    }
                    break block4;
                }
                if ((byArray[2] & 3) != 3) break block5;
                int n3 = 0;
                while (n3 < 4 && n3 < byArray.length) {
                    n *= 256;
                    n += byArray[6 + n3] & 0xFF;
                    ++n3;
                }
                break block4;
            }
            if ((byArray[2] & 2) != 2) break block4;
            int n4 = 0;
            while (n4 < 4) {
                n *= 256;
                n += byArray[8 + n4] & 0xFF;
                ++n4;
            }
        }
        return n;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n) {
        return new REF[n];
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setBytes((byte[])objectInputStream.readObject());
        this.m_typename = objectInputStream.readUTF();
    }

    public void setObject(Object object) throws SQLException {
        PreparedStatement preparedStatement = this.getInternalConnection().prepareStatement("call sys.utl_ref.update_object( :1, :2 )");
        preparedStatement.setRef(1, this);
        preparedStatement.setObject(2, object);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public synchronized void setValue(Object object) throws SQLException {
        CallableStatement callableStatement;
        block6: {
            STRUCT sTRUCT = STRUCT.toSTRUCT(object, this.getInternalConnection());
            if (sTRUCT.getInternalConnection() != this.getInternalConnection()) {
                DatabaseError.throwSqlException(77, "Incompatible connection object");
            }
            if (!this.getBaseTypeName().equals(sTRUCT.getSQLTypeName())) {
                DatabaseError.throwSqlException(77, "Incompatible type");
            }
            byte[] byArray = sTRUCT.toBytes();
            byte[] byArray2 = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
            callableStatement = null;
            try {
                callableStatement = this.getInternalConnection().prepareCall("begin :1 := dbms_pickler.update_through_ref (:2, :3, :4, :5); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setBytes(2, this.shareBytes());
                callableStatement.setInt(3, 0);
                callableStatement.setBytes(4, byArray2);
                callableStatement.setBytes(5, byArray);
                callableStatement.execute();
                int n = 0;
                n = callableStatement.getInt(1);
                if (n == 0) break block6;
                DatabaseError.throwSqlException(77, "ORA-" + n);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
                throw throwable;
            }
        }
        Object var7_7 = null;
        if (callableStatement != null) {
            callableStatement.close();
        }
        callableStatement = null;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.shareBytes());
        try {
            objectOutputStream.writeUTF(this.getBaseTypeName());
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException ORA-" + sQLException.getErrorCode() + " " + sQLException.getMessage());
        }
    }
}

