/*
 * pLinkedList.java     v0.01
 *
 * Copyright(c) 1998-2001, Particle
 */

import pOneChildNode;

public class pLinkedList{
        protected pOneChildNode head;
        protected int number;

        public pLinkedList(){
                head = null;
                number = 0;
        }
        public boolean isEmpty(){
                return head == null;
        }
        public int size(){
                return number;
        }
        public void insert(Object obj){
                head = new pOneChildNode(obj,head);
                number++;
        }
        public Object remove(){
                if(isEmpty())
                        return null;
                pOneChildNode tmp = head;
                head = tmp.getNext();
                number--;
                return tmp.getData();
        }

        public void insertEnd(Object obj){
                if(isEmpty())
                        insert(obj);
                else{
                        pOneChildNode t = head;
                        while(t.getNext() != null)
                                t=t.getNext();
                        pOneChildNode tmp =
                                new pOneChildNode(obj,t.getNext());
                        t.setNext(tmp);
                        number++;
                }
        }

        public Object removeEnd(){
                if(isEmpty())
                        return null;
                if(head.getNext() == null)
                        return remove();
                pOneChildNode t = head;
                while(t.getNext().getNext() != null)
                        t = t.getNext();
                Object obj = t.getNext().getData();
                t.setNext(t.getNext().getNext());
                number--;
                return obj;
        }

        // thanks to Andrey Salaev <asalaev@cs.indiana.edu> for fixing this.
        public Object peek(int n){
                pOneChildNode t = head;
                for(int i = 0;i<n && t != null;i++)
                        t = t.getNext();
                return t.getData();
        }
}