/*
 * qsort.c
 *
 * C implementation of the qsort function 
 * defined in pQuicksortNative.java
 *
 * Copyright(c) 1999, Particle
 */

#include "pQuicksortNative.h"

JNIEXPORT void JNICALL
Java_pQuicksortNative_qsort(JNIEnv * jniEnv,
							jclass javaClass,
							jintArray arr)
{

	int i,j,left = 0,right,stack_pointer = -1;	
	int stack[128];
	int swap,temp;
	
	/* get actual array & it's size */
	jint* c = (*jniEnv)->GetIntArrayElements(jniEnv,arr,0);
	right = (*jniEnv)->GetArrayLength(jniEnv,arr) - 1;

	for(;;){
		/* see if to do insertion sort or quicksort */
		if(right - left <= 7){
			/* simple insertion sort */
			for(j=left+1;j<=right;j++){
				swap = c[j];
				i = j-1;
				while(i>=left && c[i] > swap)
					c[i+1] = c[i--];
				c[i+1] = swap;
			}
			if(stack_pointer == -1)
				break;
			right = stack[stack_pointer--];
			left = stack[stack_pointer--];
		}else{
			/* quicksort */

			/* find the median */
			int median = (left + right) >> 1;
			i = left + 1;
			j = right;
			
			/* swap the median */
			c[median] ^= c[i];
			c[i] ^= c[median];
			c[median] ^= c[i]; 
			
			/* make sure: c[left] <= c[left+1] <= c[right] */
			if(c[left] > c[right]){
				c[left] ^= c[right];
				c[right] ^= c[left];
				c[left] ^= c[right];  
			}if(c[i] > c[right]){
				c[i] ^= c[right];
				c[right] ^= c[i];
				c[i] ^= c[right];
			}if(c[left] > c[i]){
				c[i] ^= c[left];
				c[left] ^= c[i];
				c[i] ^= c[left];
			}
			temp = c[i];
			for(;;){
				do i++; while(c[i] < temp);
				do j--; while(c[j] > temp);
				if(j < i)
					break;
				c[i] ^= c[j];
				c[j] ^= c[i];
				c[i] ^= c[j];
			}
			c[left + 1] = c[j];
			c[j] = temp;
			if(right-i+1 >= j-left){
				stack[++stack_pointer] = i;
				stack[++stack_pointer] = right;
				right = j-1;
			}else{
				stack[++stack_pointer] = left;
				stack[++stack_pointer] = j-1;
				left = i;
			}
		}
	}
	/* release array */
	(*jniEnv)->ReleaseIntArrayElements(jniEnv,arr,c,0);	
}
