@ECHO OFF

SET WINVER=Windows 7 Build 7100
SET PRODUCTNAME="Windows 7 Ultimate"
SET CURRENTBUILD="7100"

TITLE Concurrent Remote Desktop Sessions %WINVER%

:SHOWHELP
	IF /I *%1 == *-? GOTO PRINTHELP
	IF /I *%1 == *help GOTO PRINTHELP
	GOTO PERMISSIONCHK

:PRINTHELP
	ECHO This script enables concurrent remote desktop sessions
	ECHO for %WINVER%
	ECHO.
	ECHO This script must be run as an Administrator.
	ECHO To open an elevated command prompt with Administrator privileges
	ECHO press WinKey, typ cmd, and hit Ctrl+Shift+Enter.
	ECHO.
	ECHO.
	ECHO Available commandline switches:
	ECHO.
	ECHO -?        Show this help.
	ECHO help     Same as -?.
	ECHO multi    Enable multiple sessions per user.
	ECHO blank    Enable remote logon for user accounts that are not password protected.
	ECHO.
	GOTO END

:PERMISSIONCHK
	ATTRIB %windir%\system32 -h | FINDSTR /I "denied" >nul
	IF NOT ERRORLEVEL 1 (
		ECHO.
		ECHO This script must be run as an Administrator.
		ECHO.
		ECHO Use switch -? to show help.
		ECHO.
		GOTO END
	)

:PRODUCTVERCHK
	FOR /F "tokens=*" %%A IN ('REG QUERY "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "ProductName"') DO SET VERSION=%%A
	ECHO %VERSION% | FINDSTR /I %PRODUCTNAME% >nul
	IF NOT ERRORLEVEL 1 GOTO CURRENTBUILD
	GOTO UNSUPPORTED

:CURRENTBUILD	
	FOR /F "tokens=*" %%A IN ('REG QUERY "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "CurrentBuild"') DO SET CB=%%A
	ECHO %CB% | FINDSTR /I %CURRENTBUILD% >nul
	IF NOT ERRORLEVEL 1 GOTO START
	GOTO UNSUPPORTED

:UNSUPPORTED
	ECHO.
	ECHO Your operating system is not supported.
	ECHO Only for %WINVER%
	GOTO END

:START
	CLS
	IF /I EXIST %systemroot%\SysWOW64 SET BIT=Y

:DETECTARGUMENTS
	SET SINGLESESSION=1
	SET BLANK=1
	IF /I *%1 == *MULTI SET SINGLESESSION=0
	IF /I *%2 == *MULTI SET SINGLESESSION=0
	IF /I *%1 == *BLANK SET BLANK=0
	IF /I *%2 == *BLANK SET BLANK=0

:SETSOURCEFOLDER
	REM This will get the folder the batch file was launched from since the current
	REM directory will change if launched from a network share
	SET SOURCEFOLDER=%~dp0
	ECHO Source Folder is %SOURCEFOLDER%
	ECHO.

:TAKEOWNERSHIP
	ECHO Taking ownership of %SystemRoot%\System32\termsrv.dll
	takeown /a /f %SystemRoot%\System32\termsrv.dll
	ECHO Granting Administrators rights
	ICACLS %SystemRoot%\System32\termsrv.dll /Grant Administrators:F

:STOPTERMINALSERVICES
	ECHO Stopping Remote Desktop Services
	NET stop "Remote Desktop Services" /y

:BACKUPTERMSRVDLL
	IF /I EXIST %SystemRoot%\System32\termsrv.dll.bak GOTO PATCHED
	COPY "%SystemRoot%\System32\termsrv.dll" "%SystemRoot%\System32\*.*.bak"

:COPYTERMSRVDLL
	IF '%BIT%'=='Y' (
		ECHO Copying "%SOURCEFOLDER%64_termsrv.dll" to "%SystemRoot%\System32\termsrv.dll"
	) ELSE (ECHO Copying "%SOURCEFOLDER%32_termsrv.dll" to "%SystemRoot%\System32\termsrv.dll") 

	IF '%BIT%'=='Y' (
		COPY /Y "%SOURCEFOLDER%64_termsrv.dll" "%SystemRoot%\System32\termsrv.dll"
	) ELSE (COPY /Y "%SOURCEFOLDER%32_termsrv.dll" "%SystemRoot%\System32\termsrv.dll")

	GOTO IMPORTREGKEYS

:PATCHED
	ECHO ######################################
	ECHO # Patched Already ,Config Editing... #
	ECHO ######################################

:IMPORTREGKEYS
	ECHO Enabling RDP
	REG ADD "HKLM\SYSTEM\CurrentControlSet\Control\Terminal Server" /v fDenyTSConnections /t REG_DWORD /d 0 /f

:SETSINGLESESSIONSETTING
	ECHO Setting fSingleSessionPerUser to %SINGLESESSION%
	REG ADD "HKLM\SYSTEM\CurrentControlSet\Control\Terminal Server" /v fSingleSessionPerUser /t REG_DWORD /d %SINGLESESSION% /f

:SETBLANKPASSWORDPOLICY
	ECHO Setting LimitBlankPasswordUser to %BLANK%
	REG ADD "HKLM\SYSTEM\CurrentControlSet\Control\Lsa" /v LimitBlankPasswordUse /t REG_DWORD /d %BLANK% /f

:CONFIGUREFIREWALL
	ECHO Configuring Remote Desktop in Windows Firewall
	NETSH advfirewall firewall set rule group="remote desktop" new enable=Yes

:STARTTERMINALSERVICES
	ECHO Starting Remote Desktop Services
	NET START "Remote Desktop Services"

:PAUSE5SECONDS
	ECHO Pausing 5 seconds to give service time to start listening
	CHOICE /n /c y /d y /t 5 > nul

:CHECKIFSERVICELISTENING
	ECHO Checking if Service is listening on port 3389
	SUBST
	NETSTAT -a | find /i "3389"
	IF ERRORLEVEL 1 GOTO SERVICENOTLISTENING

:SERVICEISLISTENING
	ECHO Service is listening
	ECHO Done
	GOTO END

:SERVICENOTLISTENING
	ECHO Service is not listening

:CONTINUE
	ECHO Done
	
:END
	PAUSE