-- MySQL dump 10.11
--
-- Host: localhost    Database: roundcubedb
-- ------------------------------------------------------
-- Server version	5.0.95

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `cache` (
  `cache_id` int(10) unsigned NOT NULL auto_increment,
  `cache_key` varchar(128) character set ascii NOT NULL,
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `data` longtext NOT NULL,
  `user_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`cache_id`),
  KEY `user_cache_index` (`user_id`,`cache_key`),
  KEY `created_index` (`created`),
  CONSTRAINT `user_id_fk_cache` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `contacts` (
  `contact_id` int(10) unsigned NOT NULL auto_increment,
  `changed` datetime NOT NULL default '0000-00-00 00:00:00',
  `del` tinyint(1) NOT NULL default '0',
  `name` varchar(128) NOT NULL,
  `email` varchar(128) NOT NULL,
  `firstname` varchar(128) NOT NULL,
  `surname` varchar(128) NOT NULL,
  `vcard` text,
  `user_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`contact_id`),
  KEY `user_contacts_index` (`user_id`,`email`),
  CONSTRAINT `user_id_fk_contacts` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `identities`
--

DROP TABLE IF EXISTS `identities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `identities` (
  `identity_id` int(10) unsigned NOT NULL auto_increment,
  `del` tinyint(1) NOT NULL default '0',
  `standard` tinyint(1) NOT NULL default '0',
  `name` varchar(128) NOT NULL,
  `organization` varchar(128) NOT NULL default '',
  `email` varchar(128) NOT NULL,
  `reply-to` varchar(128) NOT NULL default '',
  `bcc` varchar(128) NOT NULL default '',
  `signature` text NOT NULL,
  `html_signature` tinyint(1) NOT NULL default '0',
  `user_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`identity_id`),
  KEY `user_id_fk_identities` (`user_id`),
  CONSTRAINT `user_id_fk_identities` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `messages` (
  `message_id` int(11) unsigned NOT NULL auto_increment,
  `user_id` int(10) unsigned NOT NULL default '0',
  `del` tinyint(1) NOT NULL default '0',
  `cache_key` varchar(128) character set ascii NOT NULL,
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `idx` int(11) unsigned NOT NULL default '0',
  `uid` int(11) unsigned NOT NULL default '0',
  `subject` varchar(255) NOT NULL,
  `from` varchar(255) NOT NULL,
  `to` varchar(255) NOT NULL,
  `cc` varchar(255) NOT NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `size` int(11) unsigned NOT NULL default '0',
  `headers` text NOT NULL,
  `structure` text,
  PRIMARY KEY  (`message_id`),
  UNIQUE KEY `uniqueness` (`user_id`,`cache_key`,`uid`),
  KEY `created_index` (`created`),
  KEY `index_index` (`user_id`,`cache_key`,`idx`),
  CONSTRAINT `user_id_fk_messages` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `session`
--

DROP TABLE IF EXISTS `session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `session` (
  `sess_id` varchar(40) NOT NULL,
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `changed` datetime NOT NULL default '0000-00-00 00:00:00',
  `ip` varchar(40) NOT NULL,
  `vars` mediumtext NOT NULL,
  PRIMARY KEY  (`sess_id`),
  KEY `changed_index` (`changed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(10) unsigned NOT NULL auto_increment,
  `username` varchar(128) NOT NULL,
  `mail_host` varchar(128) NOT NULL,
  `alias` varchar(128) NOT NULL,
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `last_login` datetime NOT NULL default '0000-00-00 00:00:00',
  `language` varchar(5) default NULL,
  `preferences` text,
  PRIMARY KEY  (`user_id`),
  KEY `username_index` (`username`),
  KEY `alias_index` (`alias`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2016-06-11 17:17:11
-- MySQL dump 10.11
--
-- Host: localhost    Database: roundcubedb
-- ------------------------------------------------------
-- Server version	5.0.95

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` (`cache_id`, `cache_key`, `created`, `data`, `user_id`) VALUES (1,'IMAP.messagecount','2014-12-17 22:42:26','a:5:{s:5:\"INBOX\";a:2:{s:3:\"ALL\";i:0;s:6:\"UNSEEN\";i:0;}s:6:\"Drafts\";a:1:{s:6:\"UNSEEN\";i:0;}s:4:\"Junk\";a:1:{s:6:\"UNSEEN\";i:0;}s:5:\"Trash\";a:1:{s:6:\"UNSEEN\";i:0;}s:4:\"Sent\";a:2:{s:6:\"RECENT\";i:0;s:6:\"UNSEEN\";i:0;}}',1),(2,'IMAP.mailboxes','2014-12-17 22:35:44','a:5:{i:0;s:5:\"INBOX\";i:1;s:6:\"Drafts\";i:2;s:4:\"Junk\";i:3;s:4:\"Sent\";i:4;s:5:\"Trash\";}',1),(3,'IMAP.messagecount','2014-12-26 19:36:06','a:5:{s:6:\"Drafts\";a:1:{s:6:\"UNSEEN\";i:0;}s:4:\"Junk\";a:1:{s:6:\"UNSEEN\";i:0;}s:4:\"Sent\";a:1:{s:6:\"UNSEEN\";i:0;}s:5:\"INBOX\";a:2:{s:3:\"ALL\";i:0;s:6:\"UNSEEN\";i:0;}s:5:\"Trash\";a:1:{s:6:\"UNSEEN\";i:0;}}',2),(4,'IMAP.mailboxes','2014-12-26 19:35:47','a:5:{i:0;s:5:\"INBOX\";i:1;s:6:\"Drafts\";i:2;s:4:\"Junk\";i:3;s:4:\"Sent\";i:4;s:5:\"Trash\";}',2);
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `identities`
--

LOCK TABLES `identities` WRITE;
/*!40000 ALTER TABLE `identities` DISABLE KEYS */;
INSERT INTO `identities` (`identity_id`, `del`, `standard`, `name`, `organization`, `email`, `reply-to`, `bcc`, `signature`, `html_signature`, `user_id`) VALUES (1,0,1,'','','gx@isecuriti.com','','','',0,1),(2,0,1,'','','gx@kloudbro.dyndns.biz','','','',0,2);
/*!40000 ALTER TABLE `identities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`message_id`, `user_id`, `del`, `cache_key`, `created`, `idx`, `uid`, `subject`, `from`, `to`, `cc`, `date`, `size`, `headers`, `structure`) VALUES (1,1,0,'Sent.msg','2014-12-17 22:36:29',1,1,'saludos desde PBX','<gx@isecuriti.com>','<gabox@msn.com>','','2014-12-17 22:36:25',334,'O:14:\"iilBasicHeader\":32:{s:2:\"id\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:7:\"subject\";s:17:\"saludos desde PBX\";s:4:\"from\";s:18:\"<gx@isecuriti.com>\";s:2:\"to\";s:15:\"<gabox@msn.com>\";s:2:\"cc\";s:0:\"\";s:7:\"replyto\";s:0:\"\";s:11:\"in_reply_to\";s:0:\"\";s:4:\"date\";s:31:\"Wed, 17 Dec 2014 22:36:25 +0000\";s:9:\"messageID\";s:44:\"<b55091f01e6aac2a5ff981466a1b132a@localhost>\";s:4:\"size\";s:3:\"334\";s:8:\"encoding\";s:4:\"8bit\";s:7:\"charset\";s:5:\"UTF-8\";s:5:\"ctype\";s:10:\"text/plain\";s:5:\"flags\";a:2:{i:0;s:6:\"Recent\";i:1;s:4:\"Seen\";}s:9:\"timestamp\";s:10:\"1418855785\";s:1:\"f\";s:0:\"\";s:14:\"body_structure\";s:0:\"\";s:12:\"internaldate\";s:26:\"17-Dec-2014 16:36:25 -0600\";s:10:\"references\";s:0:\"\";s:8:\"priority\";s:0:\"\";s:6:\"mdn_to\";s:0:\"\";s:8:\"mdn_sent\";s:0:\"\";s:8:\"is_draft\";s:0:\"\";s:4:\"seen\";s:1:\"1\";s:7:\"deleted\";s:0:\"\";s:6:\"recent\";s:1:\"1\";s:8:\"answered\";s:0:\"\";s:9:\"forwarded\";s:0:\"\";s:4:\"junk\";s:0:\"\";s:7:\"flagged\";s:0:\"\";s:6:\"others\";a:0:{}}',NULL),(2,2,0,'Sent.msg','2014-12-18 17:34:16',1,1,'hokla asterisk','<gx@kloudbro.dyndns.biz>','<gabox@msn.com>','','2014-12-18 17:34:15',349,'O:14:\"iilBasicHeader\":32:{s:2:\"id\";s:1:\"1\";s:3:\"uid\";s:1:\"1\";s:7:\"subject\";s:14:\"hokla asterisk\";s:4:\"from\";s:24:\"<gx@kloudbro.dyndns.biz>\";s:2:\"to\";s:15:\"<gabox@msn.com>\";s:2:\"cc\";s:0:\"\";s:7:\"replyto\";s:0:\"\";s:11:\"in_reply_to\";s:0:\"\";s:4:\"date\";s:31:\"Thu, 18 Dec 2014 17:34:15 -0600\";s:9:\"messageID\";s:44:\"<a75d983d16ad0f055e049ff5c79eb024@localhost>\";s:4:\"size\";s:3:\"349\";s:8:\"encoding\";s:4:\"8bit\";s:7:\"charset\";s:5:\"UTF-8\";s:5:\"ctype\";s:10:\"text/plain\";s:5:\"flags\";a:2:{i:0;s:6:\"Recent\";i:1;s:4:\"Seen\";}s:9:\"timestamp\";s:10:\"1418945655\";s:1:\"f\";s:0:\"\";s:14:\"body_structure\";s:0:\"\";s:12:\"internaldate\";s:26:\"18-Dec-2014 17:34:15 -0600\";s:10:\"references\";s:0:\"\";s:8:\"priority\";s:0:\"\";s:6:\"mdn_to\";s:0:\"\";s:8:\"mdn_sent\";s:0:\"\";s:8:\"is_draft\";s:0:\"\";s:4:\"seen\";s:1:\"1\";s:7:\"deleted\";s:0:\"\";s:6:\"recent\";s:1:\"1\";s:8:\"answered\";s:0:\"\";s:9:\"forwarded\";s:0:\"\";s:4:\"junk\";s:0:\"\";s:7:\"flagged\";s:0:\"\";s:6:\"others\";a:0:{}}',NULL),(3,2,0,'Sent.msg','2014-12-18 17:37:23',2,2,'hoooooola','<gx@kloudbro.dyndns.biz>','<gx@kloudbro.dyndns.biz>','','2014-12-18 17:37:22',352,'O:14:\"iilBasicHeader\":32:{s:2:\"id\";s:1:\"2\";s:3:\"uid\";s:1:\"2\";s:7:\"subject\";s:9:\"hoooooola\";s:4:\"from\";s:24:\"<gx@kloudbro.dyndns.biz>\";s:2:\"to\";s:24:\"<gx@kloudbro.dyndns.biz>\";s:2:\"cc\";s:0:\"\";s:7:\"replyto\";s:0:\"\";s:11:\"in_reply_to\";s:0:\"\";s:4:\"date\";s:31:\"Thu, 18 Dec 2014 17:37:22 -0600\";s:9:\"messageID\";s:44:\"<750ad3f6469dbd1cc0c5456dfeaf40c7@localhost>\";s:4:\"size\";s:3:\"352\";s:8:\"encoding\";s:4:\"8bit\";s:7:\"charset\";s:5:\"UTF-8\";s:5:\"ctype\";s:10:\"text/plain\";s:5:\"flags\";a:2:{i:0;s:6:\"Recent\";i:1;s:4:\"Seen\";}s:9:\"timestamp\";s:10:\"1418945842\";s:1:\"f\";s:0:\"\";s:14:\"body_structure\";s:0:\"\";s:12:\"internaldate\";s:26:\"18-Dec-2014 17:37:22 -0600\";s:10:\"references\";s:0:\"\";s:8:\"priority\";s:0:\"\";s:6:\"mdn_to\";s:0:\"\";s:8:\"mdn_sent\";s:0:\"\";s:8:\"is_draft\";s:0:\"\";s:4:\"seen\";s:1:\"1\";s:7:\"deleted\";s:0:\"\";s:6:\"recent\";s:1:\"1\";s:8:\"answered\";s:0:\"\";s:9:\"forwarded\";s:0:\"\";s:4:\"junk\";s:0:\"\";s:7:\"flagged\";s:0:\"\";s:6:\"others\";a:0:{}}',NULL);
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `session`
--

LOCK TABLES `session` WRITE;
/*!40000 ALTER TABLE `session` DISABLE KEYS */;
/*!40000 ALTER TABLE `session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`user_id`, `username`, `mail_host`, `alias`, `created`, `last_login`, `language`, `preferences`) VALUES (1,'gx@isecuriti.com','localhost','','2014-12-17 22:35:43','2014-12-17 22:35:43',NULL,NULL),(2,'gx@kloudbro.dyndns.biz','localhost','','2014-12-18 17:33:14','2014-12-26 19:35:47',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2016-06-11 17:17:11
