/*
********************************************************************************
* FIVN Asterisk Management GUI
* Version 2.3
* A simple GUI interface for configuring Asterisk
* Copyright (C) 2006-2013, FIVN, Loc Nguyen
* http://www.fivn.com/
* This software is allowed to use only for non-commercial purposes.
* Ask the author for commercial use.
* THERE IS NO WARRANTY FOR THE PROGRAM BECAUSE IT IS LICENSED FREE OF CHARGE.
*
*/

VERSION = '2.3';

CallView.CDR_FIELDS = 'CDRaccountcode,CDRsrc,CDRdst,CDRdcontext,CDRclid,CDRchannel,CDRdstchannel,CDRlastapp,';
CallView.CDR_FIELDS += 'CDRlastdata,CDRstart,CDRanswer,CDRend,CDRduration,CDRbillsec,CDRdisposition,CDRamaflags';
CallView.TITLES = 'Caller,From,To,Application,Data,Time,Duration,Status';
CallView.TITLE_FIELDS = 'CDRclid,CDRsrc,CDRdst,CDRlastapp,CDRlastdata,CDRstart,CDRduration,CDRdisposition';
CallView.TIME_FIELDS = 'CDRduration,CDRbillsec';

Settings.DEFAULT_ASTERISK_VERSION = '11';
Settings.DEFAULT_START_PAGE = 1;
Settings.DEFAULT_DIALOG_DELAY = 1000;

Menu.HEADER = 1;
Menu.ITEM = 2;
Menu.TYPE = 0;
Menu.ACTION = 1;
Menu.NAME = 2;
Menu.ID = 3;
Menu.CLASS = 4;
Menu.FUNCTION = 5;
Menu.DISABLE = 6;

SystemStatus.LINE_LENGTH = 80;

Command.TYPE = 0;
Command.COMMAND = 1;
Command.DESCRIPTION = 2;


function Menu() {
	this.menu = [
		[Menu.HEADER, -1, 'Peers', 'title_peer', 'title', '', false],
		[Menu.ITEM, AsteriskGUI.SIP_PEERS, 'SIP', 'menu_sip_peer', '', 'gui.action(AsteriskGUI.SIP_PEERS)', false],
		[Menu.ITEM, AsteriskGUI.IAX_PEERS, 'IAX', 'menu_iax_peer', '', 'gui.action(AsteriskGUI.IAX_PEERS)', disable_iax2],

		[Menu.HEADER, -1, 'Registry', 'title_peer', 'title', '', false],
		[Menu.ITEM, AsteriskGUI.SIP_REGISTRY, 'SIP', 'menu_sip_registry', '', 'gui.action(AsteriskGUI.SIP_REGISTRY)', false],
		[Menu.ITEM, AsteriskGUI.IAX_REGISTRY, 'IAX', 'menu_iax_registry', '', 'gui.action(AsteriskGUI.IAX_REGISTRY)', disable_iax2],

		[Menu.HEADER, -1, 'Channels', 'title_channel', 'title', '', false],
		[Menu.ITEM, AsteriskGUI.SIP_CHANNELS, 'SIP', 'menu_sip_channel', '', 'gui.action(AsteriskGUI.SIP_CHANNELS)', false],
		[Menu.ITEM, AsteriskGUI.IAX_CHANNELS, 'IAX', 'menu_iax_channel', '', 'gui.action(AsteriskGUI.IAX_CHANNELS)', disable_iax2],
		[Menu.ITEM, AsteriskGUI.ALL_CHANNELS, 'All', 'menu_all_channel', '', 'gui.action(AsteriskGUI.ALL_CHANNELS)', false],

		[Menu.HEADER, -1, 'View', 'title_view', 'title', '', false],
		[Menu.ITEM, AsteriskGUI.CALLS, 'Calls', 'menu_call', '', 'gui.action(AsteriskGUI.CALLS)', false],
		[Menu.ITEM, AsteriskGUI.LOGS, 'Logs', 'menu_log', '', 'gui.action(AsteriskGUI.LOGS)', false],
		[Menu.ITEM, AsteriskGUI.MODULES, 'Modules', 'menu_modules', '', 'gui.action(AsteriskGUI.MODULES)', false],

		[Menu.HEADER, -1, 'Administration', 'title_admin', 'title', '', false],
		[Menu.ITEM, AsteriskGUI.EDITOR_LIST, 'File Editor', 'menu_editor', '', 'gui.action(AsteriskGUI.EDITOR_LIST)', false],
		[Menu.ITEM, AsteriskGUI.COMMAND, 'Commands', 'menu_command', '', 'gui.command(AsteriskGUI.ACTION_SHOW)', hide_commands],
		[Menu.ITEM, AsteriskGUI.CLEAN_LOG, 'Clean Logs', 'menu_clean', '', 'gui.action(AsteriskGUI.CLEAN_LOG)', hide_cleanlog],
		[Menu.ITEM, AsteriskGUI.BACKUP, 'Backup', 'menu_backup', '', 'gui.action(AsteriskGUI.BACKUP)', hide_backup],
		[Menu.ITEM, AsteriskGUI.SYSTEM_STATUS, 'System Status', 'menu_status', '', 'gui.status(\"\", AsteriskGUI.ACTION_SHOW)', false],
		[Menu.ITEM, AsteriskGUI.SETTINGS, 'Settings', 'menu_settings', '', 'gui.settings(\"\", AsteriskGUI.ACTION_SHOW)', false],
		[Menu.ITEM, AsteriskGUI.ABOUT, 'About', 'menu_about', '', 'gui.about()', hide_about]
	];
}

Menu.prototype.clear = function() {
	for (var i in this.menu) {
		if (this.menu[i][Menu.TYPE] == Menu.ITEM) {
			try {
				document.getElementById(this.menu[i][Menu.ID]).className = '';
			}
			catch (e) {
			}
		}
	}
}

Menu.prototype.actionSelected = function(id) {
	this.clear();
	for (var i in this.menu) {
		if (this.menu[i][Menu.ACTION] == id) {
			try {
				document.getElementById(this.menu[i][Menu.ID]).className = 'selected';
			}
			catch (ex) {
			}
			break;
		}
	}
}

Menu.prototype.selected = function(elementID) {
	this.clear();
	document.getElementById(elementID).className = 'selected';
}

Menu.prototype.show = function() {
	Utils.showMenu(this.createMenu());
	this.setOnClick();
}

Menu.prototype.createMenu = function() {
	var first = true;
	var htmlText = '';
	for (var i in this.menu) {
		if (this.menu[i][Menu.TYPE] == Menu.HEADER) {
			if (first) {
				first = false;
			}
			else {
				htmlText += '</ul>';
			}
			htmlText += '<ul>';
			htmlText += '<li id=\"' + this.menu[i][Menu.ID] + '\" class=\"';
			htmlText += this.menu[i][Menu.CLASS] + '\">' + this.menu[i][Menu.NAME] + '</li>';
		}
		else if (!this.menu[i][Menu.DISABLE]) {
			htmlText += '<li id=\"' + this.menu[i][Menu.ID] + '\">' + this.menu[i][Menu.NAME] + '</li>';
		}
	}
	if (!first) {
		htmlText += '<li class=\"empty\"></li></ul>';
	}
	return htmlText;
}

Menu.prototype.setOnClick = function() {
	for (var i in this.menu) {
		if (this.menu[i][Menu.TYPE] == Menu.ITEM) {
			try {
				var f = 'menu.action(\'' + this.menu[i][Menu.ID] + '\', \'' + this.menu[i][Menu.FUNCTION] + '\')';
				document.getElementById(this.menu[i][Menu.ID]).onclick = new Function(f);
			}
			catch (e) {
			}
		}
	}
}

Menu.prototype.getActionList = function() {
	var list = new Array();
	for (var i in this.menu) {
		if (this.menu[i][Menu.TYPE] == Menu.HEADER) {
			list[this.menu[i][Menu.ACTION] + i + '\" class=\"title\" disabled=\"disabled\"'] = this.menu[i][Menu.NAME];
		}
		else if (this.menu[i][Menu.TYPE] == Menu.ITEM && !this.menu[i][Menu.DISABLE]) {
			list[this.menu[i][Menu.ACTION]] = this.menu[i][Menu.NAME];
		}
	}
	return list;
}

Menu.prototype.action = function(elementID, func) {
	this.selected(elementID);
	new Function(func)();
}


var About = {
	show: function() {
		var htmlText = '<div id=\"about\"><table>';
		htmlText += '<tr><th class=\"title\">Asterisk Management</th></tr>';
		htmlText += '<tr><td>Version ' + VERSION + '</td></tr>';
		htmlText += '<tr><td>Copyright &copy; 2006-2013 FIVN, Loc Nguyen</td></tr>';
		htmlText += '<tr><td>All rights reserved.</td></tr>';
		htmlText += '<tr><td><a href=\"http://www.fivn.com/\" onclick=\"window.open(this.href); return false;\" ';
		htmlText += 'onkeypress=\"window.open(this.href); return false;\">http://www.fivn.com/</a></td></tr>';
		htmlText += '<tr><td>&nbsp;</td></tr>';
		htmlText += '</table></div>';
		Utils.show(htmlText);
	}
}


function Settings() {
	if (typeof settings_set == 'undefined' || typeof settings_set != 'boolean') {
		settings_set = false;
		asterisk_version = Settings.DEFAULT_ASTERISK_VERSION;
		start_page = Settings.DEFAULT_START_PAGE;
		dialog_delay = Settings.DEFAULT_DIALOG_DELAY;
		call_order = false;
		disable_iax2 = false;
		advanced_parsing = false;
		hide_commands = false;
		hide_cleanlog = false;
		hide_backup = false;
		hide_about = false;
		hide_description = false;
	}
	this.asteriskVersion = {
		'1.4': '1.4.x',
		'1.6': '1.6.x',
		'1.8': '1.8.x',
		'11': '11.x'
	};
	this.callOrder = {
		'false': 'normal',
		'true': 'reverse'
	};
	this.delayTime = {
		'0': '0 s',
		'1000': '1 s',
		'2000': '2 s',
		'3000': '3 s',
		'4000': '4 s'
	};
}

Settings.prototype.isSet = function() {
	return settings_set;
}

Settings.prototype.getSet = function() {
	settings_set = true;
	asterisk_version = Utils.getValue('asterisk_version', Settings.DEFAULT_ASTERISK_VERSION);
	start_page = Utils.getValue('start_page', Settings.DEFAULT_START_PAGE);
	dialog_delay = Utils.getValue('dialog_delay', Settings.DEFAULT_DIALOG_DELAY);
	call_order = Utils.getValue('call_order', false);
	call_order = (call_order == 'true') ? true : false;
	disable_iax2 = Utils.getCheckboxValue('disable_iax2', false);
	advanced_parsing = Utils.getCheckboxValue('advanced_parsing', false);
	hide_commands = Utils.getCheckboxValue('hide_commands', false);
	hide_cleanlog = Utils.getCheckboxValue('hide_cleanlog', false);
	hide_backup = Utils.getCheckboxValue('hide_backup', false);
	hide_about = Utils.getCheckboxValue('hide_about', false);
	hide_description = Utils.getCheckboxValue('hide_description', false);

	var script = 'var settings_set = true';
	script += ';\nvar asterisk_version = \'' + asterisk_version + '\'';
	script += ';\nvar start_page = ' + start_page;
	script += ';\nvar dialog_delay = ' + dialog_delay;
	script += ';\nvar call_order = ' + call_order;
	script += ';\nvar disable_iax2 = ' + disable_iax2;
	script += ';\nvar advanced_parsing = ' + advanced_parsing;
	script += ';\nvar hide_commands = ' + hide_commands;
	script += ';\nvar hide_cleanlog = ' + hide_cleanlog;
	script += ';\nvar hide_backup = ' + hide_backup;
	script += ';\nvar hide_about = ' + hide_about;
	script += ';\nvar hide_description = ' + hide_description;
	script += ';\n';
	return script;
}

Settings.prototype.show = function(actionList, saved) {
	var htmlText = '<div id=\"settings\"><table>';
	htmlText += '<tr><td class=\"description\">Asterisk Version</td>';
	htmlText += '<td class=\"value\" colspan=\"2\"><select id=\"asterisk_version\">';
	htmlText += Settings.option(this.asteriskVersion, asterisk_version);
	htmlText += '</select></td></tr>';

	htmlText += '<tr><td class=\"description\">Call Log Order</td>';
	htmlText += '<td class=\"value\" colspan=\"2\"><select id=\"call_order\">';
	htmlText += Settings.option(this.callOrder, String(call_order));
	htmlText += '</select></td></tr>';

	htmlText += '<tr><td class=\"description\">Start Page</td>';
	htmlText += '<td class=\"value\" colspan=\"2\"><select id=\"start_page\">';
	htmlText += Settings.option(actionList, start_page);
	htmlText += '</select></td></tr>';

	htmlText += '<tr><td class=\"description\">Wait Dialog Delay</td>';
	htmlText += '<td class=\"value\" colspan=\"2\"><select id=\"dialog_delay\">';
	htmlText += Settings.option(this.delayTime, dialog_delay);
	htmlText += '</select></td></tr>';

	htmlText += '<tr><td class=\"description\">Disable IAX2 Support</td>';
	htmlText += '<td class=\"value\" colspan=\"2\">' + Settings.input('disable_iax2', disable_iax2);
	htmlText += '</td></tr>';

	htmlText += '<tr><td class=\"description\">Use Advanced Parsing</td>';
	htmlText += '<td class=\"value\" colspan=\"2\">' + Settings.input('advanced_parsing', advanced_parsing);
	htmlText += '</td></tr>';

	htmlText += '<tr><td class=\"description\">Hide Commands Menu</td>';
	htmlText += '<td class=\"value\" colspan=\"2\">' + Settings.input('hide_commands', hide_commands);
	htmlText += '</td></tr>';

	htmlText += '<tr><td class=\"description\">Hide Clean Logs Menu</td>';
	htmlText += '<td class=\"value\" colspan=\"2\">' + Settings.input('hide_cleanlog', hide_cleanlog);
	htmlText += '</td></tr>';

	htmlText += '<tr><td class=\"description\">Hide Backup Menu</td>';
	htmlText += '<td class=\"value\" colspan=\"2\">' + Settings.input('hide_backup', hide_backup);
	htmlText += '</td></tr>';

	htmlText += '<tr><td class=\"description\">Hide About Menu</td>';
	htmlText += '<td class=\"value\" colspan=\"2\">' + Settings.input('hide_about', hide_about);
	htmlText += '</td></tr>';

	htmlText += '<tr><td class=\"description\">Hide Description Column</td>';
	htmlText += '<td class=\"value\" colspan=\"2\">' + Settings.input('hide_description', hide_description);
	htmlText += '</td></tr>';

	htmlText += '<tr><td colspan=\"3\" class=\"empty_height\"></td></tr>';
	if (saved) {
		htmlText += '<tr><td class=\"notify\">Saved</td>';
	}
	else {
		htmlText += '<tr><td class=\"white\"></td>';
	}
	htmlText += '<td class=\"save\" id=\"settings_save\" ';
	htmlText += 'onclick=\"gui.action(AsteriskGUI.SETTINGS_SAVE);\">Save</td><td></td></tr>';
	htmlText += '</table><span id=\"thank_you\"></span></div>';
	Utils.show(htmlText);
}

Settings.prototype.thankyou = function() {
	document.getElementById('thank_you').className = 'greeting';
	Utils.setText('thank_you', 'Thank you for choosing FIVN Asterisk Management.');
}

Settings.option = function(values, selected) {
	var htmlText = '';
	for (var i in values) {
		htmlText += '<option value=\"' + i + '\"';
		if (i == selected) {
			htmlText += ' selected=\"selected\"';
		}
		htmlText += '>' + values[i] + '</option>';
	}
	return htmlText;
}

Settings.input = function(id, value) {
	if (value) {
		return '<input type=\"checkbox\" checked=\"checked\" id=\"' + id + '\"/>';
	}
	else {
		return '<input type=\"checkbox\" id=\"' + id + '\"/>';
	}
}


function Loading(delay) {
	this.delay = delay;
	this.timer = 0;
	this.div = 'loading';
	this.showing = false;
}

Loading.prototype.show = function() {
	this.showing = true;
	this.stopTimer();
	this.timer = setTimeout('loading.timerCall()', this.delay);
}

Loading.prototype.hide = function() {
	this.stopTimer();
	document.getElementById(this.div).style.display = 'none';
	this.showing = false;
}

Loading.prototype.timerCall = function() {
	this.stopTimer();
	if (this.showing) {
		this.setCenter(this.div);
		document.getElementById(this.div).style.display = 'block';
	}
}

Loading.prototype.stopTimer = function() {
	if (this.timer) {
		clearTimeout(this.timer);
		this.timer = 0;
	}
}

Loading.prototype.setCenter = function(elementID) {
	var windowWidth = 0;
	var windowHeight = 0;
	var scrollX = 0;
	var scrollY = 0;
	var showWidth = Loading.getStyleValue(elementID, 'width');
	var showHeight = Loading.getStyleValue(elementID, 'height');
	showWidth = showWidth.substring(0, showWidth.length - 2);
	showHeight = showHeight.substring(0, showHeight.length - 2);

	if (window.innerWidth != undefined) {
		windowWidth = window.innerWidth;
		windowHeight = window.innerHeight;
	}
	else if (document.documentElement.clientWidth != undefined) {
		windowWidth = document.documentElement.clientWidth;
		windowHeight = document.documentElement.clientHeight;
	}
	else if (document.body.clientWidth != undefined) {
		windowWidth = document.body.clientWidth;
		windowHeight = document.body.clientHeight;
	}

	if (window.pageYOffset != undefined) {
		scrollX = window.pageYOffset;
		scrollY = window.pageXOffset;
	}
	else if (document.body.scrollLeft != undefined) {
		scrollX = document.body.scrollTop;
		scrollY = document.body.scrollLeft;
	}
	else if (document.documentElement.scrollLeft != undefined) {
		scrollX = document.documentElement.scrollTop;
		scrollY = document.documentElement.scrollLeft;
	}

	var left = scrollY + ((windowWidth - showWidth) / 2);
	var top = scrollX + ((windowHeight - showHeight) / 2);
	document.getElementById(elementID).style['top'] = top + 'px';
	document.getElementById(elementID).style['left'] = left + 'px';
}

Loading.getStyleValue = function(elementID, property) {
	var value = 0;
	var doc = document.getElementById(elementID);
	if (doc.currentStyle) {
		value = doc.currentStyle[property];
	}
	else if (window.getComputedStyle) {
		value = document.defaultView.getComputedStyle(doc,null).getPropertyValue(property);
	}
	return value;
}


var Message = {
	formatView: function(text, divName, className, convertSpace) {
		var htmlText = '<div id=\"' + divName + '\">';
		htmlText += LogView.formatOutput(text, className, convertSpace);
		htmlText += '</div>';
		Utils.show(htmlText);
	}
}


function SystemStatus() {
	this.commands = [
		['Asterisk', 'asterisk'], ['Uptime', 'uptime'], ['Memory', 'memory'],
		['Disk', 'disk'], ['Mount', 'mount'], ['Processes', 'processes']];
	this.htmlText = '';
}

SystemStatus.prototype.clear = function() {
	this.htmlText = '<div id=\"status\"><table>';
}

SystemStatus.prototype.showText = function() {
	this.htmlText += '</table></div>';
	Utils.show(this.htmlText);
	this.htmlText = '';
}

SystemStatus.prototype.append = function(text, id) {
	this.htmlText += SystemStatus.formatOutput(text, this.getTitle(id));
	this.htmlText += '<td class=\"empty_height\"></td>';
}

SystemStatus.prototype.getTitle = function(id) {
	return this.commands[id][0];
}

SystemStatus.prototype.getCommand = function(id) {
	return this.commands[id][1];
}

SystemStatus.prototype.getNext = function(id) {
	if (id == (this.commands.length - 1)) {
		return null;
	}
	else {
		return ++id;
	}
}

SystemStatus.formatOutput = function(text, title) {
	var rows = text.rtrim().split('\n');
	var htmlText = '<tr><th class=\"title\">' + title + '</th></tr>';
	for (var i = 0; i < rows.length; i++) {
		if (i % 2 == 0) {
			htmlText += '<tr class=\"odd status_list\">';
		}
		else {
			htmlText += '<tr class=\"even status_list\">';
		}
		if (rows[i].length > SystemStatus.LINE_LENGTH) {
			rows[i] = rows[i].substring(0, SystemStatus.LINE_LENGTH);
		}
		rows[i] = Utils.escape(rows[i]).replace(/ /g, '&nbsp;');
		htmlText += '<td>' + rows[i] + '</td></tr>';
	}
	return htmlText;
}


function Command(disable) {
	this.commanddElement = 'asterisk_command';
	this.commandOutput = 'command_output';
	this.commandPrefix = 'command_';
	this.commands = [
		['sip', 'sip reload', 'Reload SIP configuration'],
		['iax', 'iax2 reload','Reload IAX configuration'],
		['core', 'dialplan reload', 'Reload extensions'],
		['core', 'moh reload', 'Reload Music On Hold'],
		['core', 'dnsmgr reload', 'Reload DNS configuration'],
		['core', 'module reload', 'Reload configuration'],
		['core', 'logger reload', 'Reopen the log files'],
		['core', 'logger rotate', 'Rotate the log files']
	];

	for (var type in disable) {
		if (disable[type]) {
			var tmp = this.commands;
			this.commands = new Array();
			for (var i in tmp) {
				if (tmp[i][Command.TYPE] != type) {
					this.commands.push(tmp[i]);
				}
			}
		}
	}
}

Command.prototype.getCommand = function() {
	return document.getElementById(this.commanddElement).value;
}

Command.prototype.getDefinedCommand = function(id) {
	return this.commands[id][Command.COMMAND];
}

Command.prototype.showCommands = function(text, command) {
	var htmlText = '<div id=\"command\"><table><tr>';
	if (asterisk_version == '1.4') {
		htmlText += '<td class=\"command_help\" colspan=\"2\">Enter \'help\' for the list of commands</td>';
	}
	else {
		htmlText += '<td class=\"command_help\" colspan=\"2\">Enter \'core show help\' for help</td>';
	}
	htmlText += '</tr><tr><td class=\"command_text\">';
	htmlText += '<form id=\"form\" action=\"javascript:gui.action(AsteriskGUI.COMMAND);\">';
	htmlText += '<input id=\"' + this.commanddElement + '\" value=\"' + Utils.escape(command);
	htmlText += '\" onkeypress=\"gui.command(AsteriskGUI.ACTION_EXECUTE, event);\"/>';
	htmlText += '</form></td>';
	htmlText += '<td class=\"execute\" onclick=\"gui.command(AsteriskGUI.ACTION_EXECUTE, 13);\">Execute</td>';
	htmlText += '<td class=\"notify\">';
	if (command != '') {
		htmlText += 'Executed';
	}
	htmlText += '</td></tr>';
	if (command == '') {
		htmlText += '<tr><td colspan=\"3\" class=\"empty_height\"></td></tr>'
		for (var i = 0; i < this.commands.length; i++) {
			if (i % 2 == 0) {
				htmlText += '<tr class=\"odd\">';
			}
			else {
				htmlText += '<tr class=\"even\">';
			}
			htmlText += '<td class=\"description\">' + this.commands[i][Command.DESCRIPTION] + '</td>';
			htmlText += '<td class=\"execute\" onclick=\"gui.command(AsteriskGUI.ACTION_DEFINED_COMMAND, ';
			htmlText += i + ');\">Execute</td>';
			htmlText += '<td class=\"notify\" id=\"' + this.commandPrefix + i + '\"></td></tr>';
		}
	}
	htmlText += '</table><br/><span id=\"' + this.commandOutput + '\" class=\"command_list\">';
	htmlText += LogView.formatOutput(text, 'command_list_view', true) + '</span></div>';
	Utils.show(htmlText);
}

Command.prototype.showExecuted = function(text, elementID) {
	try {
		for (var i = 0; i < this.commands.length; i++) {
			document.getElementById(this.commandPrefix + i).innerHTML = '';
		}
		document.getElementById(this.commandPrefix + elementID).innerHTML = 'Executed';
		document.getElementById(this.commandOutput).innerHTML = LogView.formatOutput(text, 'command_list_view', true);
	}
	catch (e) {
	}
}


function FileEditor() {
	this.editorText = 'editor_text';
	this.editorFile = 'editor_file';
}

FileEditor.prototype.getFile = function() {
	return document.getElementById(this.editorFile).value;
}

FileEditor.prototype.getText = function() {
	return document.getElementById(this.editorText).value;
}

FileEditor.prototype.listFile = function(text) {
	var files = text.trim().split('\n');
	var htmlText = '<div id=\"editor\"><table>';
	for (var i = 0; i < files.length; i++) {
		if (i % 2 == 0) {
			htmlText += '<tr class=\"odd\">';
		}
		else {
			htmlText += '<tr class=\"even\">';
		}
		var file = files[i].trim();
		htmlText += '<td class=\"file\">' + file + '</td>';
		htmlText += '<td class=\"edit\" onclick=\"gui.action(AsteriskGUI.EDITOR_EDIT, \'';
		htmlText += file + '\');\">Edit</td></tr>';
	}
	htmlText += '</table></div>';
	Utils.show(htmlText);
}

FileEditor.prototype.editFile = function(text, file) {
	text = Utils.escape(text);
	var htmlText = '<div id=\"editor\"><textarea id=\"' + this.editorText + '\" wrap=\"off\">' + text + '</textarea>';
	htmlText += '<input type=\"hidden\" id=\"editor_file\" value=\"' + file + '\"/></div>';
	htmlText += '<div id=\"editor_left\"><table><tr>';
	htmlText += '<td class=\"edit\" onclick=\"gui.action(AsteriskGUI.EDITOR_SAVE);\">Save</td>';
	htmlText += '</tr></table></div>';
	htmlText += '<div id=\"editor_right\"><table><tr>';
	htmlText += '<td class=\"edit\" onclick=\"gui.action(AsteriskGUI.EDITOR_LIST);\">Cancel</td>';
	htmlText += '</tr></table></div>';
	Utils.show(htmlText);
}


function LogView() {
	this.titles = new Array('Time','Level','Text');
}

LogView.prototype.showContent = function(text) {
	try {
		var rows = new Array();
		var logs = text.split('\n');
		for (var i in logs) {
			if (logs[i].trim() != '') {
				var entry = logs[i].split('] ');
				if (entry.length >= 3) {
					entry[0] = entry[0].substring(1);
					entry[1] += ']';
				}
				else if (entry.length == 2) {
					entry[0] = entry[0].substring(1);
					entry[2] = entry[1];
					entry[1] = '';
				}
				else {
					entry[2] = entry[0];
					entry[0] = '';
					entry[1] = '';
				}
				rows.push(entry);
			}
		}
		var htmlText = LogView.formatView(this.titles, rows);
		Utils.show(htmlText);
	}
	catch (e) {
		alert("View cannot be formatted.");
		Utils.show('');
	}
}

LogView.formatView = function(titles, rows) {
	var text = '<div id=\"list_view\"><table><tr class=\"title\">';
	for (var r in titles) {
		text += '<th>' + titles[r] + '</th>';
	}
	text += '</tr>';
	for (var r = 0; r < rows.length; r++) {
		if (r % 2 == 0) {
			text += '<tr class=\"odd smaller_font\">';
		}
		else {
			text += '<tr class=\"even smaller_font\">';
		}
		for (var c in rows[r]) {
			text += '<td>' + rows[r][c] + '</td>';
		}
		text += '</tr>';
	}
	text += '</table></div>';
	return text;
}

LogView.formatOutput = function(text, className, convertSpace) {
	var htmlText = '';
	if (text.length > 0) {
		text = text.rtrim();
		if (convertSpace) {
			text = Utils.escape(text).replace(/ /g, '&nbsp;');
		}
		var rows = text.split('\n');
		htmlText += '<table>';
		for (var i = 0; i < rows.length; i++) {
			if (i % 2 == 0) {
				htmlText += '<tr class=\"odd\">';
			}
			else {
				htmlText += '<tr class=\"even\">';
			}
			htmlText += '<td class=\"' + className + '\">' + rows[i] + '</td></tr>';
		}
		htmlText += '</table>';
	}
	return htmlText;
}


function CallView() {
	this.cdrs = CallView.CDR_FIELDS.split(',');
	this.titles = CallView.TITLES.split(',');
	this.titleFields = CallView.TITLE_FIELDS.split(',');
	this.timeFields = CallView.TIME_FIELDS.split(',');
}

CallView.prototype.showContent = function(text, reverseOrder) {
	try {
		var rows = this.parseText(text);
		if (reverseOrder) {
			rows.reverse();
		}
		var htmlText = LogView.formatView(this.titles, rows);
		Utils.show(htmlText);
	}
	catch (e) {
		alert("View cannot be formatted.");
		Utils.show('');
	}
}

CallView.prototype.parseText = function(text) {
	var rows = new Array();
	var calls = text.split('\n');
	for (var e in calls) {
		if (calls[e].trim() != '') {
			var entry = new Array(this.titles.length);
			var data = CallView.parseLine(calls[e]);
			for (var show in this.titleFields) {
				for (var col in this.cdrs) {
					if (this.titleFields[show] == this.cdrs[col]) {
						for (var time in this.timeFields) {
							if (this.timeFields[time] == this.cdrs[col]) {
								data[col] = CallView.formatTime(data[col]);
								break;
							}
						}
						entry.push(data[col]);
					}
				}
			}
			rows.push(entry);
		}
	}
	return rows;
}

CallView.parseLine = function(text) {
	var start = 0;
	var end = 0;
	var str = "";
	var data = new Array();
	while (text.length > start) {
		if (text.charAt(start) == '"') {
			start += 1;
			end = text.indexOf("\",", start);
			if (end == -1) {
				if (text.charAt(text.length - 1) == '"') {
					str = text.substring(start, text.length - 1);
				}
				else {
					str = text.substring(start, text.length);
				}
				start = text.length;
			}
			else {
				str = text.substring(start, end);
				start = end + 2;
			}
		}
		else {
			end = text.indexOf(',', start);
			if (end == -1) {
				str = text.substring(start, text.length);
				start = text.length;
			}
			else {
				str = text.substring(start, end);
				start = end + 1;
			}
		}
		str = str.replace(/\"/g, '');
		str = Utils.escape(str);
		data.push(str);
	}
	return data;
}

CallView.formatTime = function(time) {
	var TEN = 10;
	var TIME = 60;
	var text = '';
	var hour = 0;
	var min = Math.floor(time / TIME);
	var sec = time % TIME;
	if (min > TIME) {
		hour = Math.floor(min / TIME);
		min = min % TIME;
	}
	if (hour < TEN) {
		text += '0';
	}
	text += hour + ':';
	if (min < TEN) {
		text += '0';
	}
	text += min + ':';
	if (sec < TEN) {
		text += '0';
	}
	text += sec;
	return text;
}


function ClientView() {
}

ClientView.prototype.showContent = function(text, colsWidth, endAmount, advancedParsing) {
	try {
		var rows = this.parseText(text, colsWidth, endAmount, advancedParsing);
		var htmlText = this.formatView(rows, endAmount);
		Utils.show(htmlText);
	}
	catch (e) {
		alert("View cannot be formatted.");
		Utils.show('');
	}
}

ClientView.prototype.parseText = function(text, colsWidth, endAmount, advancedParsing) {
	var rows = text.rtrim().split('\n');
	if (rows.length > 0) {
		while (rows.length <= endAmount) {
			endAmount--;
		}
		for (var r = 0; r < rows.length; r++) {
			if (r >= (rows.length - endAmount)) {
				rows[r] = this.trimConvertSpace(rows[r]);
			}
			else {
				var i;
				var s;
				var str = rows[r];
				var cols = new Array(colsWidth.length);
				for (var c = 0; c < colsWidth.length; c++) {
					if (colsWidth[c] == -1) {
						cols[c] = this.trimConvertSpace(str);
						str = '';
					}
					else {
						if (str.length >= colsWidth[c]) {
							s = str.substring(0, colsWidth[c]);
							str = str.substring(colsWidth[c]);
							if (advancedParsing) {
								if (s.charAt(s.length - 1) != ' ') {
									for (i = 0; i < str.length; i++) {
										s += str.charAt(i);
										if (str.charAt(i) == ' ') {
											break;
										}
									}
									str = str.substring(++i);
								}
							}
							cols[c] = this.trimConvertSpace(s);
						}
						else if (str.length == 0) {
							cols[c] = '';
						}
						else {
							cols[c] = this.trimConvertSpace(str);
							str = '';
						}
					}
				}
				rows[r] = cols;
			}
		}
	}
	return rows;
}

ClientView.prototype.formatView = function(rows, endAmount) {
	var text = '<div id=\"list_view\"><table>';
	for (var i = 0; i < rows.length; i++) {
		if (i == 0) {
			text += '<tr class=\"title\">';
			for (var key in rows[i]) {
				text += '<th>' + rows[i][key] + '</th>';
			}
		}
		else if (i >= (rows.length - endAmount)) {
			text += '<tr class=\"summary\">';
			text += '<td colspan=\"' + rows[0].length + '\">' + rows[i] + '</td>';
		}
		else {
			if ((i + 1) % 2 == 0) {
				text += '<tr class=\"odd\">';
			}
			else {
				text += '<tr class=\"even\">';
			}
			for (var key in rows[i]) {
				text += '<td>' + rows[i][key] + '</td>';
			}
		}
		text += '</tr>';
	}
	text += '</table></div>';
	return text;
}

ClientView.prototype.trimConvertSpace = function(text) {
	return text.replace(/^\s+|\s+$/g, '').replace(/ /g, '&nbsp;');
}


function ViewInfo(title, colsWidth, amountEndRow, identString, postContent) {
	this.title = title;
	this.colsWidth = colsWidth;
	this.amountEndRow = amountEndRow;
	this.identString = identString;
	this.postContent = postContent;
}

ViewInfo.prototype.getTitle = function() {
	return this.title;
}

ViewInfo.prototype.getColsWidth = function() {
	return this.colsWidth;
}

ViewInfo.prototype.getAmountEndRow = function() {
	return this.amountEndRow;
}

ViewInfo.prototype.getIdentString = function() {
	return this.identString;
}

ViewInfo.prototype.getPostContent = function() {
	return this.postContent;
}


function Connection(url) {
	this.url = url;
	this.http = false;
	this.onRequest = false;
	try {
		this.http = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) {
		this.http = false;
	}
	if (!this.http) {
		try {
			this.http = new ActiveXObject("Microsoft.XMLHTTP");
		} 
		catch (e) {
			this.http = false;
		}
	}
	if (!this.http) {
		try {
			this.http = new XMLHttpRequest();
		} 
		catch (e) {
			this.http = false;
		}
	}
	if (!this.http) {
		alert("HTTP connection cannot be established.");
	}
}

Connection.prototype.connect = function(request, callback, action, option) {
	var self = this;
	this.http.open('POST', this.url, true);
	this.http.onreadystatechange = function() {
		if ((self.http.readyState == 4) && (self.http.status == 200)) {
			this.onRequest = false;
			callback(self.http.responseText, action, option);
		}
	}
	this.http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	this.http.send(request)
	this.onRequest = true;
}

Connection.prototype.cancel = function() {
	if (this.onRequest) {
		this.http.abort();
		this.onRequest = false;
	}
}


var Utils = {
	escape: function(text) {
		return text.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\"/g, '&quot;');
	},

	show: function(text) {
		document.getElementById(Utils.VIEW_ELEMENT).innerHTML = text;
	},

	setText: function(elementID, text) {
		document.getElementById(elementID).innerHTML = text;
	},

	showMenu: function(text) {
		document.getElementById(Utils.MENU_ELEMENT).innerHTML = text;
	},

	setTitle: function(text) {
		document.getElementById(Utils.TITLE_ELEMENT).innerHTML = text;
	},

	getValue: function(elementID, value) {
		var v = value;
		try {
			v = document.getElementById(elementID).value;
		}
		catch (e) {
		}
		return v;
	},

	getCheckboxValue: function(elementID, value) {
		var v = value;
		try {
			v = document.getElementById(elementID).checked;
		}
		catch (e) {
		}
		return v;
	}
}


String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g, '');
}
String.prototype.ltrim = function() {
	return this.replace(/^\s+/, '');
}
String.prototype.rtrim = function() {
	return this.replace(/\s+$/, '');
}

Utils.VIEW_ELEMENT = 'view';
Utils.MENU_ELEMENT = 'menu';
Utils.TITLE_ELEMENT = 'content_title';
