#!/bin/sh

################################################################################
# FIVN Asterisk Management GUI
# Version 2.3
# A simple GUI interface for configuring Asterisk
# Copyright (C) 2006-2013, FIVN, Loc Nguyen
# http://www.fivn.com/
# This software is allowed to use only for non-commercial purposes.
# Ask the author for commercial use.
# THERE IS NO WARRANTY FOR THE PROGRAM BECAUSE IT IS LICENSED FREE OF CHARGE.
#

print_content_type="yes"
keep_log_entry="2"
keep_call_entry="30"
script_settings="/www/settings.js"
ps_command="ps -ef"
# Values are: optware|openwrt|tomato|other; note: change 'ps -ef' to 'ps' for busybox
operation_system_variant=""

if [ "$operation_system_variant" = "optware" ]; then
  asterisk_calls="/opt/var/log/asterisk/cdr-csv/Master.csv"
  asterisk_logs="/opt/var/log/asterisk/messages"
  asterisk="/opt/sbin/asterisk"
  path="/opt/etc/asterisk"
  backup_command="tar -C /opt/etc -czvf /opt/www/asterisk.tar.gz asterisk"
  backup_text="&nbsp;\nDownload Asterisk configuration files: <a href=\"../asterisk.tar.gz\">asterisk.tar.gz</a>"
elif [ "$operation_system_variant" = "openwrt" ]; then
  asterisk_calls="/var/log/asterisk/cdr-csv/Master.csv"
  asterisk_logs="/var/log/asterisk/messages"
  asterisk="/usr/sbin/asterisk"
  path="/etc/asterisk"
  backup_command="tar -C /etc -czvf /www/asterisk.tar.gz asterisk"
  backup_text="&nbsp;\nDownload Asterisk configuration files: <a href=\"../asterisk.tar.gz\">asterisk.tar.gz</a>"
elif [ "$operation_system_variant" = "tomato" ]; then
  print_content_type="no"
  script_settings="/www/user/settings.js"
  ps_command="ps"
  asterisk_calls="/opt/var/log/asterisk/cdr-csv/Master.csv"
  asterisk_logs="/opt/var/log/asterisk/messages"
  asterisk="/opt/sbin/asterisk"
  path="/opt/etc/asterisk"
  backup_command="tar -C /opt/etc -czvf /www/user/asterisk.tar.gz asterisk"
  backup_text="&nbsp;\nDownload Asterisk configuration files: <a href=\"/user/asterisk.tar.gz\">asterisk.tar.gz</a>"
else
  asterisk_calls="/var/log/asterisk/cdr-csv/Master.csv"
  asterisk_logs="/var/log/asterisk/messages"
  asterisk="/usr/sbin/asterisk"
  path="/etc/asterisk"
  backup_command="tar -C /etc -czvf /www/asterisk.tar.gz asterisk"
  backup_text="&nbsp;\nDownload Asterisk configuration files: <a href=\"../asterisk.tar.gz\">asterisk.tar.gz</a>"
fi

ACTION_OK="%{ASTERISK_ACTION_OK}%"
ACTION_ERROR="%{ASTERISK_ACTION_ERROR}%"

urldecode() {
awk '
{
  HEX_INDEX="0123456789ABCDEF"
  gsub(/\+/, " ")
  while ((pos = index($0, "%")) > 0 && length($0) >= 3) {
    if (pos > 1) printf substr($0, 0, pos - 1)
    hex1 = toupper(substr($0, pos + 1, 1))
    hex2 = toupper(substr($0, pos + 2, 1))
    val1 = (index(HEX_INDEX, hex1) - 1) * 16
    val2 = (index(HEX_INDEX, hex2) - 1)
    printf "%c", val1 + val2
    $0 = substr($0, pos + 3, length($0) - 3)
  }
  if (length($0) > 0) printf $0
}'
}

remove_flash_chars() {
  sed -e 's/\.\.\///g; s/\.\///g; s/\///g; s/\.\.\\//g; s/\.\\//g; s/\\//g'
}

remove_unsecure_chars() {
  sed -e 's/;//g' | tr -d '\n' | tr -d '\r'
}

remove_control_chars() {
  tr -d '\x1B' | sed -r 's// /g; s/\[0\;37\;40m//g; s/\[0m//g'
}

logger_reload() {
  $asterisk -rx "logger reload" > /dev/null 2>&1
}

execute_asterisk_command() {
  $asterisk -rx "$1" | remove_control_chars
}

file_missing() {
  echo "The $1 file doesn't exist."
}

if [ "$REQUEST_METHOD" = "POST" ]; then
  read QUERY_STRING
  eval $(echo "$QUERY_STRING" | awk -F'&' '{for(i=1;i<=NF;i++){print $i}}')
  if [ "$action" != "" ]; then
    action="$(echo $action | urldecode)"
  fi
  if [ "$command" != "" ]; then
    command="$(echo $command | urldecode | remove_unsecure_chars)"
  fi
  if [ "$file" != "" ]; then
    file="$(echo $file | urldecode | remove_flash_chars | remove_unsecure_chars)"
  fi
  if [ "$content" != "" ]; then
    content="$(echo $content | urldecode | tr -d '\r')"
  fi
fi

if [ "$print_content_type" = "yes" ]; then
  echo 'Content-Type: text/html'
  echo ''
fi

if [ "$REQUEST_METHOD" != "POST" ]; then
  echo 'Asterisk Management'
  exit 0
fi

if [ "$operation_system_variant" = "" ]; then
  echo "The \"operation_system_variant\" parameter needs to be set in the asterisk.sh script."
elif [ "$action" = "calls" ]; then
  if [ -f "$asterisk_calls" ]; then
    cat "$asterisk_calls"
  else
    echo ''
  fi
elif [ "$action" = "logs" ]; then
  if [ -f "$asterisk_logs" ]; then
    cat "$asterisk_logs"
  else
    echo ''
  fi
elif [ "$action" = "clean_logs" ]; then
  if [ -f "$asterisk_logs" ]; then
    data=$(head -$keep_log_entry "$asterisk_logs")
    if [ "$data" != "" ]; then
      echo "$data" > "$asterisk_logs"
    fi
    logger_reload
    echo 'Log file was trimmed.'
  else
    file_missing "$asterisk_logs"
  fi
  if [ -f "$asterisk_calls" ]; then
    data=$(tail -n $keep_call_entry "$asterisk_calls")
    if [ "$data" != "" ]; then
      echo "$data" > "$asterisk_calls"
    fi
    echo 'Call file was trimmed.'
  else
    file_missing "$asterisk_calls"
  fi
elif [ "$action" = "editor_list" ]; then
  ls -1 "$path" | awk -F'\n' '
  {
    file_path = path "/" $0
    if ((system("test -f " file_path) == 0) && ((getline sample < file_path) >= 0)) {
      close(file_path)
      print $0
    }
  }' path="$path" -
elif [ "$action" = "editor_edit" ]; then
  if [ -f "$path/$file" ]; then
    cat "$path/$file"
  else
    echo -n "$ACTION_ERROR"
  fi
elif [ "$action" = "editor_save" ]; then
  if [ -f "$path/$file" ]; then
    # Cannot catch  Permission denied for echo, so ignore it.
    echo "$content" > "$path/$file"
    echo -n "$ACTION_OK"
  else
    echo -n "$ACTION_ERROR"
  fi
elif [ "$action" = "save_settings" ]; then
    echo "$content" > "$script_settings"
    echo -n "$ACTION_OK"
elif [ "$action" = "asterisk_command" ]; then
  if [ "$command" != "" ]; then
    execute_asterisk_command "$command"
  fi
elif [ "$action" = "asterisk" ]; then
  execute_asterisk_command "core show version"
  execute_asterisk_command "core show uptime"
elif [ "$action" = "uptime" ]; then
  uptime
elif [ "$action" = "memory" ]; then
  free
elif [ "$action" = "disk" ]; then
  df -h
elif [ "$action" = "mount" ]; then
  mount
elif [ "$action" = "processes" ]; then
  $ps_command
elif [ "$action" = "backup" ]; then
  $backup_command
  echo -e $backup_text
fi
