/*
********************************************************************************
* FIVN Asterisk Management GUI
* Version 2.3
* A simple GUI interface for configuring Asterisk
* Copyright (C) 2006-2013, FIVN, Loc Nguyen
* http://www.fivn.com/
* This software is allowed to use only for non-commercial purposes.
* Ask the author for commercial use.
* THERE IS NO WARRANTY FOR THE PROGRAM BECAUSE IT IS LICENSED FREE OF CHARGE.
*
*/

AsteriskGUI.ASTERISK_URL = '/cgi-bin/asterisk.sh';
AsteriskGUI.ACTION_OK = '%{ASTERISK_ACTION_OK}%';
AsteriskGUI.ACTION_ERROR = '%{ASTERISK_ACTION_ERROR}%';

AsteriskGUI.SIP_PEERS = 1;
AsteriskGUI.IAX_PEERS = 2;

AsteriskGUI.SIP_REGISTRY = 3;
AsteriskGUI.IAX_REGISTRY = 4;

AsteriskGUI.SIP_CHANNELS = 5;
AsteriskGUI.IAX_CHANNELS = 6;
AsteriskGUI.ALL_CHANNELS = 7;

AsteriskGUI.CALLS = 8;
AsteriskGUI.LOGS = 9;
AsteriskGUI.MODULES = 10;

AsteriskGUI.EDITOR_LIST = 11;
AsteriskGUI.EDITOR_EDIT = 12;
AsteriskGUI.EDITOR_SAVE = 13;
AsteriskGUI.COMMAND = 14;
AsteriskGUI.DEFINED_COMMAND = 15;
AsteriskGUI.CLEAN_LOG = 16;
AsteriskGUI.BACKUP = 17;
AsteriskGUI.SYSTEM_STATUS = 18;
AsteriskGUI.SETTINGS = 19;
AsteriskGUI.SETTINGS_SAVE = 20;
AsteriskGUI.ABOUT = 21;

AsteriskGUI.ACTION_SHOW = 100;
AsteriskGUI.ACTION_SHOW_SAVED = 101;
AsteriskGUI.ACTION_EXECUTE = 102;
AsteriskGUI.ACTION_DEFINED_COMMAND = 103;

AsteriskGUI.SIP_PEERS_INFO_1_4 = new ViewInfo('SIP Peers', [27, 16, 4, 4, 4, 9, -1], 1, 'Name\/username', 'action=asterisk_command&command=sip+show+peers');
AsteriskGUI.SIP_PEERS_INFO_1_6 = AsteriskGUI.SIP_PEERS_INFO_1_4;
AsteriskGUI.SIP_PEERS_INFO_1_8 = new ViewInfo('SIP Peers', [27, 40, 4, 4, 4, 9, -1], 1, 'Name\/username', 'action=asterisk_command&command=sip+show+peers');
AsteriskGUI.SIP_PEERS_INFO_11 = new ViewInfo('SIP Peers', [26, 40, 4, 11, 4, 9, 12], 1, 'Name\/username', 'action=asterisk_command&command=sip+show+peers');
AsteriskGUI.SIP_PEERS_INFO_11_DESC = new ViewInfo('SIP Peers', [26, 40, 4, 11, 4, 9, 12, -1], 1, 'Name\/username', 'action=asterisk_command&command=sip+show+peers');
AsteriskGUI.SIP_PEERS_INFO = AsteriskGUI.SIP_PEERS_INFO_1_4;

AsteriskGUI.IAX_PEERS_INFO_1_4 = new ViewInfo('IAX Peers',[17, 21, 17, 14, -1], 1, 'Name\/Username', 'action=asterisk_command&command=iax2+show+peers');
AsteriskGUI.IAX_PEERS_INFO_1_6 = AsteriskGUI.IAX_PEERS_INFO_1_4;
AsteriskGUI.IAX_PEERS_INFO_1_8 = AsteriskGUI.IAX_PEERS_INFO_1_4;
AsteriskGUI.IAX_PEERS_INFO_11 = new ViewInfo('IAX Peers',[17, 21, 17, 14, 12], 1, 'Name\/Username', 'action=asterisk_command&command=iax2+show+peers');
AsteriskGUI.IAX_PEERS_INFO_11_DESC = new ViewInfo('IAX Peers',[17, 21, 17, 14, 12, -1], 1, 'Name\/Username', 'action=asterisk_command&command=iax2+show+peers');
AsteriskGUI.IAX_PEERS_INFO = AsteriskGUI.IAX_PEERS_INFO_1_4;

AsteriskGUI.SIP_REGISTRY_1_4 = new ViewInfo('SIP Registry', [32, 15, 8, 21, -1], 0, 'Host', 'action=asterisk_command&command=sip+show+registry');
AsteriskGUI.SIP_REGISTRY_1_6 = new ViewInfo('SIP Registry', [31, 7, 15, 29, -1], 1, 'Host', 'action=asterisk_command&command=sip+show+registry');
AsteriskGUI.SIP_REGISTRY_1_8 = new ViewInfo('SIP Registry', [40, 7, 15, 29, -1], 1, 'Host', 'action=asterisk_command&command=sip+show+registry');
AsteriskGUI.SIP_REGISTRY_11 =  AsteriskGUI.SIP_REGISTRY_1_8;
AsteriskGUI.SIP_REGISTRY_INFO = AsteriskGUI.SIP_REGISTRY_1_4;

AsteriskGUI.IAX_REGISTRY_1_4 = new ViewInfo('IAX Registry',[22, 8, 12, 22, 9, -1], 0, 'Host', 'action=asterisk_command&command=iax2+show+registry');
AsteriskGUI.IAX_REGISTRY_1_6 = new ViewInfo('IAX Registry',[22, 8, 12, 22, 9, -1], 1, 'Host', 'action=asterisk_command&command=iax2+show+registry');
AsteriskGUI.IAX_REGISTRY_1_8 = AsteriskGUI.IAX_REGISTRY_1_6;
AsteriskGUI.IAX_REGISTRY_11 = AsteriskGUI.IAX_REGISTRY_1_6;
AsteriskGUI.IAX_REGISTRY_INFO = AsteriskGUI.IAX_REGISTRY_1_4;

AsteriskGUI.SIP_CHANNELS_1_4 = new ViewInfo('SIP Channels', [17, 12, 13, 13, 17, 9, -1], 1, 'Peer', 'action=asterisk_command&command=sip+show+channels');
AsteriskGUI.SIP_CHANNELS_1_6 = new ViewInfo('SIP Channels', [17, 12, 17, 17, 9, 16, -1], 1, 'Peer', 'action=asterisk_command&command=sip+show+channels');
AsteriskGUI.SIP_CHANNELS_1_8 = new ViewInfo('SIP Channels', [17, 17, 17, 17, 9, 5, 11, -1], 1, 'Peer', 'action=asterisk_command&command=sip+show+channels');
AsteriskGUI.SIP_CHANNELS_11 = new ViewInfo('SIP Channels', [17, 17, 17, 17, 9, 16, 11, -1], 1, 'Peer', 'action=asterisk_command&command=sip+show+channels');
AsteriskGUI.SIP_CHANNELS_INFO = AsteriskGUI.SIP_CHANNELS_1_4;

AsteriskGUI.IAX_CHANNELS_1_4 = new ViewInfo('IAX Channels', [22, 17, 12, 13, 13, 9, 8, 8, -1], 1, 'Channel', 'action=asterisk_command&command=iax2+show+channels');
AsteriskGUI.IAX_CHANNELS_1_6 = new ViewInfo('IAX Channels', [22, 17, 12, 13, 13, 9, 8, 8, 8, 12, -1], 1, 'Channel', 'action=asterisk_command&command=iax2+show+channels');
AsteriskGUI.IAX_CHANNELS_1_8 = AsteriskGUI.IAX_CHANNELS_1_6;
AsteriskGUI.IAX_CHANNELS_11 = AsteriskGUI.IAX_CHANNELS_1_6;
AsteriskGUI.IAX_CHANNELS_INFO = AsteriskGUI.IAX_CHANNELS_1_4;

AsteriskGUI.ALL_CHANNELS_1_4 = new ViewInfo('All Channels', [21, 21, 8, -1], 2, 'Channel', 'action=asterisk_command&command=core+show+channels');
AsteriskGUI.ALL_CHANNELS_1_6 = new ViewInfo('All Channels', [21, 21, 8, -1], 3, 'Channel', 'action=asterisk_command&command=core+show+channels');
AsteriskGUI.ALL_CHANNELS_1_8 = AsteriskGUI.ALL_CHANNELS_1_6;
AsteriskGUI.ALL_CHANNELS_11 = AsteriskGUI.ALL_CHANNELS_1_6;
AsteriskGUI.ALL_CHANNELS_INFO = AsteriskGUI.ALL_CHANNELS_1_4;

AsteriskGUI.MODULES_INFO = new ViewInfo('Loaded Modules', [31, 41, 4, -1], 1, 'Module', 'action=asterisk_command&command=module+show');

var connection = new Connection(AsteriskGUI.ASTERISK_URL);
var client = new ClientView();
var call = new CallView();
var log = new LogView();
var editor = new FileEditor();
var system = new SystemStatus();
var settings = new Settings();
var command = new Command({'iax': disable_iax2});
var loading = new Loading(dialog_delay);
var menu = new Menu();
var gui = new AsteriskGUI();

function AsteriskGUI() {
}

AsteriskGUI.prototype.setTitle = function(title) {
	Utils.setTitle(title);
}

AsteriskGUI.prototype.about = function() {
	connection.cancel();
	loading.hide();
	this.setTitle('About');
	About.show();
	gui.setURL(AsteriskGUI.ABOUT);
}

AsteriskGUI.prototype.setVersion = function() {
	if (asterisk_version == '1.4') {
		AsteriskGUI.SIP_PEERS_INFO = AsteriskGUI.SIP_PEERS_INFO_1_4;
		AsteriskGUI.IAX_PEERS_INFO = AsteriskGUI.IAX_PEERS_INFO_1_4;
		AsteriskGUI.SIP_REGISTRY_INFO = AsteriskGUI.SIP_REGISTRY_1_4;
		AsteriskGUI.IAX_REGISTRY_INFO = AsteriskGUI.IAX_REGISTRY_1_4;
		AsteriskGUI.SIP_CHANNELS_INFO = AsteriskGUI.SIP_CHANNELS_1_4;
		AsteriskGUI.IAX_CHANNELS_INFO = AsteriskGUI.IAX_CHANNELS_1_4;
		AsteriskGUI.ALL_CHANNELS_INFO = AsteriskGUI.ALL_CHANNELS_1_4;
	}
	else if (asterisk_version == '1.6') {
		AsteriskGUI.SIP_PEERS_INFO = AsteriskGUI.SIP_PEERS_INFO_1_6;
		AsteriskGUI.IAX_PEERS_INFO = AsteriskGUI.IAX_PEERS_INFO_1_6;
		AsteriskGUI.SIP_REGISTRY_INFO = AsteriskGUI.SIP_REGISTRY_1_6;
		AsteriskGUI.IAX_REGISTRY_INFO = AsteriskGUI.IAX_REGISTRY_1_6;
		AsteriskGUI.SIP_CHANNELS_INFO = AsteriskGUI.SIP_CHANNELS_1_6;
		AsteriskGUI.IAX_CHANNELS_INFO = AsteriskGUI.IAX_CHANNELS_1_6;
		AsteriskGUI.ALL_CHANNELS_INFO = AsteriskGUI.ALL_CHANNELS_1_6;
	}
	else if (asterisk_version == '1.8') {
		AsteriskGUI.SIP_PEERS_INFO = AsteriskGUI.SIP_PEERS_INFO_1_8;
		AsteriskGUI.IAX_PEERS_INFO = AsteriskGUI.IAX_PEERS_INFO_1_8;
		AsteriskGUI.SIP_REGISTRY_INFO = AsteriskGUI.SIP_REGISTRY_1_8;
		AsteriskGUI.IAX_REGISTRY_INFO = AsteriskGUI.IAX_REGISTRY_1_8;
		AsteriskGUI.SIP_CHANNELS_INFO = AsteriskGUI.SIP_CHANNELS_1_8;
		AsteriskGUI.IAX_CHANNELS_INFO = AsteriskGUI.IAX_CHANNELS_1_8;
		AsteriskGUI.ALL_CHANNELS_INFO = AsteriskGUI.ALL_CHANNELS_1_8;
	}
	else if (asterisk_version == '11') {
		if (hide_description) {
			AsteriskGUI.SIP_PEERS_INFO = AsteriskGUI.SIP_PEERS_INFO_11;
			AsteriskGUI.IAX_PEERS_INFO = AsteriskGUI.IAX_PEERS_INFO_11;
		}
		else {
			AsteriskGUI.SIP_PEERS_INFO = AsteriskGUI.SIP_PEERS_INFO_11_DESC;
			AsteriskGUI.IAX_PEERS_INFO = AsteriskGUI.IAX_PEERS_INFO_11_DESC;
		}
		AsteriskGUI.SIP_REGISTRY_INFO = AsteriskGUI.SIP_REGISTRY_11;
		AsteriskGUI.IAX_REGISTRY_INFO = AsteriskGUI.IAX_REGISTRY_11;
		AsteriskGUI.SIP_CHANNELS_INFO = AsteriskGUI.SIP_CHANNELS_11;
		AsteriskGUI.IAX_CHANNELS_INFO = AsteriskGUI.IAX_CHANNELS_11;
		AsteriskGUI.ALL_CHANNELS_INFO = AsteriskGUI.ALL_CHANNELS_11;
	}
}

AsteriskGUI.prototype.showMessage = function(text, action) {
	if (action == AsteriskGUI.CLEAN_LOG) {
		gui.setTitle('Clean Logs');
		Message.formatView(text, 'log', 'log_message', true);
	}
	else if (action == AsteriskGUI.BACKUP) {
		gui.setTitle('Backup');
		Message.formatView(text, 'backup', 'backup_message', false);
	}
	loading.hide();
}

AsteriskGUI.prototype.firstUse = function() {
	if (!settings.isSet()) {
		this.setTitle('Settings');
		settings.show(menu.getActionList(), false);
		settings.thankyou();
		menu.actionSelected(AsteriskGUI.SETTINGS);
		return true;
	}
	else {
		return false;
	}
}

AsteriskGUI.prototype.settings = function(text, action) {
	connection.cancel();
	loading.hide();
	gui.setTitle('Settings');
	gui.setURL(AsteriskGUI.SETTINGS);
	if (action == AsteriskGUI.ACTION_SHOW) {
		if (this.firstUse()) {
			return;
		}
		settings.show(menu.getActionList(), false);
	}
	else if (action == AsteriskGUI.ACTION_SHOW_SAVED) {
		menu = new Menu();
		menu.show();
		menu.actionSelected(AsteriskGUI.SETTINGS);
		loading = new Loading(dialog_delay);
		command = new Command({'iax': disable_iax2});
		gui.setVersion();
		settings.show(menu.getActionList(), true);
	}
}

AsteriskGUI.prototype.status = function(text, action) {
	if (action == AsteriskGUI.ACTION_SHOW) {
		system.clear();
		gui.action(AsteriskGUI.SYSTEM_STATUS, 0);
	}
	else {
		system.append(text, action);
		var next = system.getNext(action);
		if (next == null) {
			gui.setTitle('System Status');
			system.showText();
			loading.hide();
		}
		else {
			gui.action(AsteriskGUI.SYSTEM_STATUS, next);
		}
	}
}

AsteriskGUI.prototype.executed = function(text, action, option) {
	if (action == AsteriskGUI.ACTION_EXECUTE) {
		command.showCommands(text, option);
	}
	else if (action == AsteriskGUI.ACTION_DEFINED_COMMAND) {
		command.showExecuted(text, option);
	}
	loading.hide();
}

AsteriskGUI.prototype.command = function(action, option) {
	if (this.firstUse()) {
		return;
	}
	this.setTitle('Commands');
	if (action == AsteriskGUI.ACTION_SHOW) {
		connection.cancel();
		loading.hide();
		this.setURL(AsteriskGUI.COMMAND);
		command.showCommands('', '');
	}
	else if (action == AsteriskGUI.ACTION_EXECUTE) {
		var enter = false;
		if (option == 13) {
			enter = true;
		}
		else if (option.which && option.which == 13) {
			enter = true;
		}
		else if (option.keyCode && option.keyCode == 13) {
			enter = true;
		}
		if (enter) {
			if (command.getCommand() == '') {
				this.setURL(AsteriskGUI.COMMAND);
				command.showCommands('', '');
			}
			else {
				document.getElementById('form').submit();
			}
		}
	}
	else if (action == AsteriskGUI.ACTION_DEFINED_COMMAND) {
		this.action(AsteriskGUI.DEFINED_COMMAND, option);
	}
}

AsteriskGUI.prototype.viewClients = function(text, info) {
	gui.setTitle(info.getTitle());
	if (text.match('^' + info.getIdentString()) != info.getIdentString()) {
		var titles = new Array(new Array('Error'));
		var rows = new Array(new Array(text));
		Utils.show(LogView.formatView(titles, rows));
	}
	else {
		client.showContent(text, info.getColsWidth(), info.getAmountEndRow(), advanced_parsing);
	}
	loading.hide();
}

AsteriskGUI.prototype.viewCalls = function(text, info) {
	gui.setTitle('Call Detail Records');
	call.showContent(text, call_order);
	loading.hide();
}

AsteriskGUI.prototype.viewLogs = function(text, info) {
	gui.setTitle('Logs');
	log.showContent(text);
	loading.hide();
}

AsteriskGUI.prototype.viewEditor = function(text, action, file) {
	var hide = true;
	gui.setTitle('File Editor');
	if (action == AsteriskGUI.EDITOR_LIST) {
		editor.listFile(text);
	}
	else if (action == AsteriskGUI.EDITOR_EDIT) {
		if (text == AsteriskGUI.ACTION_ERROR) {
			alert('File ' + file + ' doesn\'t exist.');
		}
		else {
			gui.setTitle('File Editor (' + file + ')');
			editor.editFile(text, file);
		}
	}
	else if (action == AsteriskGUI.EDITOR_SAVE) {
		if (text == AsteriskGUI.ACTION_OK) {
			hide = false;
			gui.action(AsteriskGUI.EDITOR_LIST);
		}
		else {
			alert('The file cannot be saved.');
		}
	}
	if (hide) {
		loading.hide();
	}
}

AsteriskGUI.prototype.home = function() {
	var url = window.location.href;
	if (url.indexOf('?') != -1) {
		url = url.split('?')[0];
	}
	else if (url.indexOf('#') != -1) {
		url = url.split('#')[0];
	}
	window.location.href = url;
}

AsteriskGUI.prototype.setURL = function(id, option) {
	var url = window.location.href;
	if (url.indexOf('?') != -1) {
		url = url.split('?')[0];
	}
	else if (url.indexOf('#') != -1) {
		url = url.split('#')[0];
	}
	url += '#action=' + encodeURIComponent(id);
	if (option != undefined) {
		url += '&option=' + encodeURIComponent(option);
	}
	window.location.href = url;
}

AsteriskGUI.prototype.action = function(action, option) {

	if (action != AsteriskGUI.SETTINGS_SAVE) {
		if (this.firstUse()) {
			return;
		}
	}

	if (action != AsteriskGUI.SYSTEM_STATUS || option == 0) {
		loading.show();
	}

	connection.cancel();
	this.setURL(action, option);

	switch (action) {

		case AsteriskGUI.SIP_PEERS:
			connection.connect(AsteriskGUI.SIP_PEERS_INFO.getPostContent(), gui.viewClients, AsteriskGUI.SIP_PEERS_INFO);
			break;

		case AsteriskGUI.IAX_PEERS:
			connection.connect(AsteriskGUI.IAX_PEERS_INFO.getPostContent(), gui.viewClients, AsteriskGUI.IAX_PEERS_INFO);
			break;

		case AsteriskGUI.SIP_REGISTRY:
			connection.connect(AsteriskGUI.SIP_REGISTRY_INFO.getPostContent(), gui.viewClients, AsteriskGUI.SIP_REGISTRY_INFO);
			break;

		case AsteriskGUI.IAX_REGISTRY:
			connection.connect(AsteriskGUI.IAX_REGISTRY_INFO.getPostContent(), gui.viewClients, AsteriskGUI.IAX_REGISTRY_INFO);
			break;

		case AsteriskGUI.SIP_CHANNELS:
			connection.connect(AsteriskGUI.SIP_CHANNELS_INFO.getPostContent(), gui.viewClients, AsteriskGUI.SIP_CHANNELS_INFO);
			break;

		case AsteriskGUI.IAX_CHANNELS:
			connection.connect(AsteriskGUI.IAX_CHANNELS_INFO.getPostContent(), gui.viewClients, AsteriskGUI.IAX_CHANNELS_INFO);
			break;

		case AsteriskGUI.ALL_CHANNELS:
			connection.connect(AsteriskGUI.ALL_CHANNELS_INFO.getPostContent(), gui.viewClients, AsteriskGUI.ALL_CHANNELS_INFO);
			break;

		case AsteriskGUI.CALLS:
			connection.connect('action=calls', gui.viewCalls);
			break;

		case AsteriskGUI.LOGS:
			connection.connect('action=logs', gui.viewLogs);
			break;

		case AsteriskGUI.MODULES:
			connection.connect(AsteriskGUI.MODULES_INFO.getPostContent(), gui.viewClients, AsteriskGUI.MODULES_INFO);
			break;

		case AsteriskGUI.EDITOR_LIST:
			connection.connect('action=editor_list', gui.viewEditor, AsteriskGUI.EDITOR_LIST);
			break;

		case AsteriskGUI.EDITOR_EDIT:
			connection.connect('action=editor_edit&file=' + option, gui.viewEditor, AsteriskGUI.EDITOR_EDIT, option);
			break;

		case AsteriskGUI.EDITOR_SAVE:
			var submit = 'action=editor_save&file=' + editor.getFile() + '&content=';
			submit += escape(unescape(encodeURIComponent(editor.getText())));
			connection.connect(submit.replace(/\+/g, encodeURIComponent('+')), gui.viewEditor, AsteriskGUI.EDITOR_SAVE);
			break;

		case AsteriskGUI.COMMAND:
			var cmd = command.getCommand();
			connection.connect('action=asterisk_command&command=' + escape(cmd), gui.executed, AsteriskGUI.ACTION_EXECUTE, cmd);
			break;

		case AsteriskGUI.DEFINED_COMMAND:
			var cmd = command.getDefinedCommand(option);
			connection.connect('action=asterisk_command&command=' + escape(cmd), gui.executed, AsteriskGUI.ACTION_DEFINED_COMMAND, option);
			break;

		case AsteriskGUI.CLEAN_LOG:
			connection.connect('action=clean_logs', gui.showMessage, action);
			break;

		case AsteriskGUI.BACKUP:
			connection.connect('action=backup', gui.showMessage, action);
			break;

		case AsteriskGUI.SYSTEM_STATUS:
			var cmd = system.getCommand(option);
			connection.connect('action=' + escape(cmd), gui.status, option);
			break;

		case AsteriskGUI.SETTINGS_SAVE:
			connection.connect('action=save_settings&content=' + escape(settings.getSet()), gui.settings, AsteriskGUI.ACTION_SHOW_SAVED);
			break;
	}
}

AsteriskGUI.prototype.load = function() {

	menu.show();

	if (this.firstUse()) {
		return;
	}

	this.setVersion();

	var action = start_page;
	var option;
	var query;
	var url = window.location.href;
	if (url.indexOf('#') != -1) {
		query = url.split('#')[1];
		query = query.split('&');
		if (query.length > 0 && query[0].indexOf('=') != -1) {
			action = decodeURIComponent(query[0].split('=')[1]);
		}
		if (query.length > 1 && query[1].indexOf('=') != -1) {
			option = decodeURIComponent(query[1].split('=')[1]);
		}
	}
	action = parseInt(action);

	if (action == AsteriskGUI.EDITOR_SAVE) {
		action = AsteriskGUI.EDITOR_LIST;
	}
	else if (action == AsteriskGUI.SETTINGS_SAVE) {
		action = AsteriskGUI.SETTINGS;
	}

	if (action == AsteriskGUI.SYSTEM_STATUS) {
		this.status('', AsteriskGUI.ACTION_SHOW);
	}
	else if (action == AsteriskGUI.COMMAND || action == AsteriskGUI.DEFINED_COMMAND) {
		this.command(AsteriskGUI.ACTION_SHOW);
	}
	else if (action == AsteriskGUI.SETTINGS) {
		this.settings('', AsteriskGUI.ACTION_SHOW);
	}
	else if (action == AsteriskGUI.ABOUT) {
		this.about();
	}
	else {
		this.action(action, option);
	}

	if (action == AsteriskGUI.EDITOR_EDIT) {
		action = AsteriskGUI.EDITOR_LIST;
	}
	else if (action == AsteriskGUI.DEFINED_COMMAND) {
		action = AsteriskGUI.COMMAND;
	}
	menu.actionSelected(action);
}

setTimeout('gui.load()', 100);
