/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer;

import com.android.ddmlib.Log;
import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewer.HierarchyViewerApplicationDirector;
import com.android.hierarchyviewer.actions.AboutAction;
import com.android.hierarchyviewer.actions.LoadAllViewsAction;
import com.android.hierarchyviewer.actions.QuitAction;
import com.android.hierarchyviewer.actions.ShowOverlayAction;
import com.android.hierarchyviewer.util.ActionButton;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.CapturePSDAction;
import com.android.hierarchyviewerlib.actions.DisplayViewAction;
import com.android.hierarchyviewerlib.actions.InspectScreenshotAction;
import com.android.hierarchyviewerlib.actions.InvalidateAction;
import com.android.hierarchyviewerlib.actions.LoadOverlayAction;
import com.android.hierarchyviewerlib.actions.LoadViewHierarchyAction;
import com.android.hierarchyviewerlib.actions.PixelPerfectAutoRefreshAction;
import com.android.hierarchyviewerlib.actions.RefreshPixelPerfectAction;
import com.android.hierarchyviewerlib.actions.RefreshPixelPerfectTreeAction;
import com.android.hierarchyviewerlib.actions.RefreshViewAction;
import com.android.hierarchyviewerlib.actions.RefreshWindowsAction;
import com.android.hierarchyviewerlib.actions.RequestLayoutAction;
import com.android.hierarchyviewerlib.actions.SavePixelPerfectAction;
import com.android.hierarchyviewerlib.actions.SaveTreeViewAction;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.DeviceSelector;
import com.android.hierarchyviewerlib.ui.LayoutViewer;
import com.android.hierarchyviewerlib.ui.PixelPerfect;
import com.android.hierarchyviewerlib.ui.PixelPerfectControls;
import com.android.hierarchyviewerlib.ui.PixelPerfectLoupe;
import com.android.hierarchyviewerlib.ui.PixelPerfectPixelPanel;
import com.android.hierarchyviewerlib.ui.PixelPerfectTree;
import com.android.hierarchyviewerlib.ui.PropertyViewer;
import com.android.hierarchyviewerlib.ui.TreeView;
import com.android.hierarchyviewerlib.ui.TreeViewControls;
import com.android.hierarchyviewerlib.ui.TreeViewOverview;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class HierarchyViewerApplication
extends ApplicationWindow {
    private static final int INITIAL_WIDTH = 1024;
    private static final int INITIAL_HEIGHT = 768;
    private static HierarchyViewerApplication sMainWindow;
    private Image mDeviceViewImage;
    private Image mPixelPerfectImage;
    private Image mTreeViewImage;
    private Image mDeviceViewSelectedImage;
    private Image mPixelPerfectSelectedImage;
    private Image mTreeViewSelectedImage;
    private Button mTreeViewButton;
    private Button mPixelPerfectButton;
    private Button mDeviceViewButton;
    private Label mProgressLabel;
    private ProgressBar mProgressBar;
    private String mProgressString;
    private Composite mDeviceSelectorPanel;
    private Composite mTreeViewPanel;
    private Composite mPixelPerfectPanel;
    private StackLayout mMainWindowStackLayout;
    private DeviceSelector mDeviceSelector;
    private Composite mStatusBar;
    private TreeView mTreeView;
    private Composite mMainWindow;
    private Image mOnBlackImage;
    private Image mOnWhiteImage;
    private Button mOnBlackWhiteButton;
    private Button mShowExtras;
    private LayoutViewer mLayoutViewer;
    private PixelPerfectLoupe mPixelPerfectLoupe;
    private Composite mTreeViewControls;
    private HierarchyViewerDirector mDirector;
    private SelectionListener deviceViewButtonSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            HierarchyViewerApplication.this.mDeviceViewButton.setSelection(true);
            HierarchyViewerApplication.this.showDeviceSelector();
        }
    };
    private SelectionListener treeViewButtonSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            HierarchyViewerApplication.this.mTreeViewButton.setSelection(true);
            HierarchyViewerApplication.this.showTreeView();
        }
    };
    private SelectionListener pixelPerfectButtonSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            HierarchyViewerApplication.this.mPixelPerfectButton.setSelection(true);
            HierarchyViewerApplication.this.showPixelPerfect();
        }
    };
    private SelectionListener onBlackWhiteSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (HierarchyViewerApplication.this.mLayoutViewer.getOnBlack()) {
                HierarchyViewerApplication.this.mLayoutViewer.setOnBlack(false);
                HierarchyViewerApplication.this.mOnBlackWhiteButton.setImage(HierarchyViewerApplication.this.mOnBlackImage);
            } else {
                HierarchyViewerApplication.this.mLayoutViewer.setOnBlack(true);
                HierarchyViewerApplication.this.mOnBlackWhiteButton.setImage(HierarchyViewerApplication.this.mOnWhiteImage);
            }
        }
    };
    private SelectionListener showExtrasSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            HierarchyViewerApplication.this.mLayoutViewer.setShowExtras(HierarchyViewerApplication.this.mShowExtras.getSelection());
        }
    };
    private SelectionListener loadAllViewsSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            HierarchyViewerApplication.this.mShowExtras.setSelection(true);
            HierarchyViewerApplication.this.showExtrasSelectionListener.widgetSelected(null);
        }
    };
    private TreeViewModel.ITreeChangeListener mTreeChangeListener = new TreeViewModel.ITreeChangeListener(){

        public void selectionChanged() {
        }

        public void treeChanged() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (TreeViewModel.getModel().getTree() == null) {
                        HierarchyViewerApplication.this.showDeviceSelector();
                        HierarchyViewerApplication.this.mTreeViewButton.setEnabled(false);
                    } else {
                        HierarchyViewerApplication.this.showTreeView();
                        HierarchyViewerApplication.this.mTreeViewButton.setEnabled(true);
                    }
                }
            });
        }

        public void viewportChanged() {
        }

        public void zoomChanged() {
        }
    };
    private PixelPerfectModel.IImageChangeListener mImageChangeListener = new PixelPerfectModel.IImageChangeListener(){

        public void crosshairMoved() {
        }

        public void treeChanged() {
        }

        public void imageChanged() {
        }

        public void imageLoaded() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (PixelPerfectModel.getModel().getImage() == null) {
                        HierarchyViewerApplication.this.mPixelPerfectButton.setEnabled(false);
                        HierarchyViewerApplication.this.showDeviceSelector();
                    } else {
                        HierarchyViewerApplication.this.mPixelPerfectButton.setEnabled(true);
                        HierarchyViewerApplication.this.showPixelPerfect();
                    }
                }
            });
        }

        public void overlayChanged() {
        }

        public void overlayTransparencyChanged() {
        }

        public void selectionChanged() {
        }

        public void zoomChanged() {
        }
    };

    public static final HierarchyViewerApplication getMainWindow() {
        return sMainWindow;
    }

    public HierarchyViewerApplication() {
        super(null);
        sMainWindow = this;
        this.addMenuBar();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Hierarchy Viewer");
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        Image image = imageLoader.loadImage("load-view-hierarchy.png", Display.getDefault());
        shell.setImage(image);
    }

    public MenuManager createMenuManager() {
        return new MenuManager();
    }

    public void run() {
        this.setBlockOnOpen(true);
        this.open();
        TreeViewModel.getModel().removeTreeChangeListener(this.mTreeChangeListener);
        PixelPerfectModel.getModel().removeImageChangeListener(this.mImageChangeListener);
        ImageLoader.dispose();
        this.mDirector.stopListenForDevices();
        this.mDirector.stopDebugBridge();
        this.mDirector.terminate();
    }

    protected void initializeBounds() {
        Rectangle monitorArea = Display.getDefault().getPrimaryMonitor().getBounds();
        this.getShell().setSize(Math.min(monitorArea.width, 1024), Math.min(monitorArea.height, 768));
        this.getShell().setLocation(monitorArea.x + (monitorArea.width - 1024) / 2, monitorArea.y + (monitorArea.height - 768) / 2);
    }

    private void loadResources() {
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mTreeViewImage = imageLoader.loadImage("tree-view.png", Display.getDefault());
        this.mTreeViewSelectedImage = imageLoader.loadImage("tree-view-selected.png", Display.getDefault());
        this.mPixelPerfectImage = imageLoader.loadImage("pixel-perfect-view.png", Display.getDefault());
        this.mPixelPerfectSelectedImage = imageLoader.loadImage("pixel-perfect-view-selected.png", Display.getDefault());
        this.mDeviceViewImage = imageLoader.loadImage("device-view.png", Display.getDefault());
        this.mDeviceViewSelectedImage = imageLoader.loadImage("device-view-selected.png", Display.getDefault());
        this.mOnBlackImage = imageLoader.loadImage("on-black.png", Display.getDefault());
        this.mOnWhiteImage = imageLoader.loadImage("on-white.png", Display.getDefault());
    }

    protected Control createContents(Composite parent) {
        this.mDirector = HierarchyViewerApplicationDirector.createDirector();
        this.mDirector.initDebugBridge();
        this.mDirector.startListenForDevices();
        this.mDirector.populateDeviceSelectionModel();
        TreeViewModel.getModel().addTreeChangeListener(this.mTreeChangeListener);
        PixelPerfectModel.getModel().addImageChangeListener(this.mImageChangeListener);
        this.loadResources();
        Composite control = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = 0;
        control.setLayout((Layout)mainLayout);
        this.mMainWindow = new Composite(control, 0);
        this.mMainWindow.setLayoutData((Object)new GridData(1808));
        this.mMainWindowStackLayout = new StackLayout();
        this.mMainWindow.setLayout((Layout)this.mMainWindowStackLayout);
        this.buildDeviceSelectorPanel(this.mMainWindow);
        this.buildTreeViewPanel(this.mMainWindow);
        this.buildPixelPerfectPanel(this.mMainWindow);
        this.buildStatusBar(control);
        this.showDeviceSelector();
        return control;
    }

    private void buildStatusBar(Composite parent) {
        this.mStatusBar = new Composite(parent, 0);
        this.mStatusBar.setLayoutData((Object)new GridData(768));
        FormLayout statusBarLayout = new FormLayout();
        statusBarLayout.marginWidth = 2;
        statusBarLayout.marginHeight = 2;
        this.mStatusBar.setLayout((Layout)statusBarLayout);
        this.mDeviceViewButton = new Button(this.mStatusBar, 2);
        this.mDeviceViewButton.setImage(this.mDeviceViewImage);
        this.mDeviceViewButton.setToolTipText("Switch to the window selection view");
        this.mDeviceViewButton.addSelectionListener(this.deviceViewButtonSelectionListener);
        FormData deviceViewButtonFormData = new FormData();
        deviceViewButtonFormData.left = new FormAttachment();
        this.mDeviceViewButton.setLayoutData((Object)deviceViewButtonFormData);
        this.mTreeViewButton = new Button(this.mStatusBar, 2);
        this.mTreeViewButton.setImage(this.mTreeViewImage);
        this.mTreeViewButton.setEnabled(false);
        this.mTreeViewButton.setToolTipText("Switch to the tree view");
        this.mTreeViewButton.addSelectionListener(this.treeViewButtonSelectionListener);
        FormData treeViewButtonFormData = new FormData();
        treeViewButtonFormData.left = new FormAttachment((Control)this.mDeviceViewButton, 2);
        this.mTreeViewButton.setLayoutData((Object)treeViewButtonFormData);
        this.mPixelPerfectButton = new Button(this.mStatusBar, 2);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectImage);
        this.mPixelPerfectButton.setEnabled(false);
        this.mPixelPerfectButton.setToolTipText("Switch to the pixel perfect view");
        this.mPixelPerfectButton.addSelectionListener(this.pixelPerfectButtonSelectionListener);
        FormData pixelPerfectButtonFormData = new FormData();
        pixelPerfectButtonFormData.left = new FormAttachment((Control)this.mTreeViewButton, 2);
        this.mPixelPerfectButton.setLayoutData((Object)pixelPerfectButtonFormData);
        this.mTreeViewControls = new TreeViewControls(this.mStatusBar);
        FormData treeViewControlsFormData = new FormData();
        treeViewControlsFormData.left = new FormAttachment((Control)this.mPixelPerfectButton, 2);
        treeViewControlsFormData.top = new FormAttachment((Control)this.mTreeViewButton, 0, 0x1000000);
        treeViewControlsFormData.width = 552;
        this.mTreeViewControls.setLayoutData((Object)treeViewControlsFormData);
        this.mProgressLabel = new Label(this.mStatusBar, 131072);
        this.mProgressBar = new ProgressBar(this.mStatusBar, 65794);
        FormData progressBarFormData = new FormData();
        progressBarFormData.right = new FormAttachment(100, 0);
        progressBarFormData.top = new FormAttachment((Control)this.mTreeViewButton, 0, 0x1000000);
        this.mProgressBar.setLayoutData((Object)progressBarFormData);
        FormData progressLabelFormData = new FormData();
        progressLabelFormData.right = new FormAttachment((Control)this.mProgressBar, -2);
        progressLabelFormData.top = new FormAttachment((Control)this.mTreeViewButton, 0, 0x1000000);
        this.mProgressLabel.setLayoutData((Object)progressLabelFormData);
        if (this.mProgressString == null) {
            this.mProgressLabel.setVisible(false);
            this.mProgressBar.setVisible(false);
        } else {
            this.mProgressLabel.setText(this.mProgressString);
        }
    }

    private void buildDeviceSelectorPanel(Composite parent) {
        this.mDeviceSelectorPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.mDeviceSelectorPanel.setLayout((Layout)gridLayout);
        Composite buttonPanel = new Composite(this.mDeviceSelectorPanel, 0);
        buttonPanel.setLayoutData((Object)new GridData(768));
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonLayout.verticalSpacing = 0;
        buttonLayout.horizontalSpacing = 0;
        buttonPanel.setLayout((Layout)buttonLayout);
        Composite innerButtonPanel = new Composite(buttonPanel, 0);
        innerButtonPanel.setLayoutData((Object)new GridData(1040));
        GridLayout innerButtonPanelLayout = new GridLayout(3, true);
        innerButtonPanelLayout.marginHeight = 2;
        innerButtonPanelLayout.marginWidth = 2;
        innerButtonPanelLayout.verticalSpacing = 2;
        innerButtonPanelLayout.horizontalSpacing = 2;
        innerButtonPanel.setLayout((Layout)innerButtonPanelLayout);
        ActionButton refreshWindows = new ActionButton(innerButtonPanel, RefreshWindowsAction.getAction());
        refreshWindows.setLayoutData(new GridData(1808));
        ActionButton loadViewHierarchyButton = new ActionButton(innerButtonPanel, LoadViewHierarchyAction.getAction());
        loadViewHierarchyButton.setLayoutData(new GridData(1808));
        ActionButton inspectScreenshotButton = new ActionButton(innerButtonPanel, InspectScreenshotAction.getAction());
        inspectScreenshotButton.setLayoutData(new GridData(1808));
        Composite deviceSelectorContainer = new Composite(this.mDeviceSelectorPanel, 2048);
        deviceSelectorContainer.setLayoutData((Object)new GridData(1808));
        deviceSelectorContainer.setLayout((Layout)new FillLayout());
        this.mDeviceSelector = new DeviceSelector(deviceSelectorContainer, true, true);
    }

    public void buildTreeViewPanel(Composite parent) {
        this.mTreeViewPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.mTreeViewPanel.setLayout((Layout)gridLayout);
        Composite buttonPanel = new Composite(this.mTreeViewPanel, 0);
        buttonPanel.setLayoutData((Object)new GridData(768));
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonLayout.verticalSpacing = 0;
        buttonLayout.horizontalSpacing = 0;
        buttonPanel.setLayout((Layout)buttonLayout);
        Composite innerButtonPanel = new Composite(buttonPanel, 0);
        innerButtonPanel.setLayoutData((Object)new GridData(1040));
        GridLayout innerButtonPanelLayout = new GridLayout(6, true);
        innerButtonPanelLayout.marginHeight = 2;
        innerButtonPanelLayout.marginWidth = 2;
        innerButtonPanelLayout.verticalSpacing = 2;
        innerButtonPanelLayout.horizontalSpacing = 2;
        innerButtonPanel.setLayout((Layout)innerButtonPanelLayout);
        ActionButton saveTreeView = new ActionButton(innerButtonPanel, SaveTreeViewAction.getAction(this.getShell()));
        saveTreeView.setLayoutData(new GridData(1808));
        ActionButton capturePSD = new ActionButton(innerButtonPanel, CapturePSDAction.getAction(this.getShell()));
        capturePSD.setLayoutData(new GridData(1808));
        ActionButton refreshViewAction = new ActionButton(innerButtonPanel, RefreshViewAction.getAction());
        refreshViewAction.setLayoutData(new GridData(1808));
        ActionButton displayView = new ActionButton(innerButtonPanel, DisplayViewAction.getAction(this.getShell()));
        displayView.setLayoutData(new GridData(1808));
        ActionButton invalidate = new ActionButton(innerButtonPanel, InvalidateAction.getAction());
        invalidate.setLayoutData(new GridData(1808));
        ActionButton requestLayout = new ActionButton(innerButtonPanel, RequestLayoutAction.getAction());
        requestLayout.setLayoutData(new GridData(1808));
        SashForm mainSash = new SashForm(this.mTreeViewPanel, 65792);
        mainSash.setLayoutData((Object)new GridData(1808));
        Composite treeViewContainer = new Composite((Composite)mainSash, 2048);
        treeViewContainer.setLayout((Layout)new FillLayout());
        this.mTreeView = new TreeView(treeViewContainer);
        SashForm sideSash = new SashForm((Composite)mainSash, 66048);
        mainSash.SASH_WIDTH = 4;
        mainSash.setWeights(new int[]{7, 3});
        Composite treeViewOverviewContainer = new Composite((Composite)sideSash, 2048);
        treeViewOverviewContainer.setLayout((Layout)new FillLayout());
        new TreeViewOverview(treeViewOverviewContainer);
        Composite propertyViewerContainer = new Composite((Composite)sideSash, 2048);
        propertyViewerContainer.setLayout((Layout)new FillLayout());
        new PropertyViewer(propertyViewerContainer);
        Composite layoutViewerContainer = new Composite((Composite)sideSash, 0);
        GridLayout layoutViewerLayout = new GridLayout();
        layoutViewerLayout.marginHeight = 0;
        layoutViewerLayout.marginWidth = 0;
        layoutViewerLayout.verticalSpacing = 1;
        layoutViewerLayout.horizontalSpacing = 1;
        layoutViewerContainer.setLayout((Layout)layoutViewerLayout);
        Composite fullButtonBar = new Composite(layoutViewerContainer, 0);
        fullButtonBar.setLayoutData((Object)new GridData(768));
        GridLayout fullButtonBarLayout = new GridLayout(2, false);
        fullButtonBarLayout.marginHeight = 0;
        fullButtonBarLayout.marginWidth = 0;
        fullButtonBarLayout.marginRight = 2;
        fullButtonBarLayout.verticalSpacing = 0;
        fullButtonBarLayout.horizontalSpacing = 0;
        fullButtonBar.setLayout((Layout)fullButtonBarLayout);
        Composite buttonBar = new Composite(fullButtonBar, 0);
        buttonBar.setLayoutData((Object)new GridData(1040));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.pack = true;
        rowLayout.center = true;
        buttonBar.setLayout((Layout)rowLayout);
        this.mOnBlackWhiteButton = new Button(buttonBar, 8);
        this.mOnBlackWhiteButton.setImage(this.mOnWhiteImage);
        this.mOnBlackWhiteButton.addSelectionListener(this.onBlackWhiteSelectionListener);
        this.mOnBlackWhiteButton.setToolTipText("Change layout viewer background color");
        this.mShowExtras = new Button(buttonBar, 32);
        this.mShowExtras.setText("Show Extras");
        this.mShowExtras.addSelectionListener(this.showExtrasSelectionListener);
        this.mShowExtras.setToolTipText("Show images");
        ActionButton loadAllViewsButton = new ActionButton(fullButtonBar, LoadAllViewsAction.getAction());
        loadAllViewsButton.setLayoutData(new GridData(3, 2, true, true));
        loadAllViewsButton.addSelectionListener(this.loadAllViewsSelectionListener);
        Composite layoutViewerMainContainer = new Composite(layoutViewerContainer, 2048);
        layoutViewerMainContainer.setLayoutData((Object)new GridData(1808));
        layoutViewerMainContainer.setLayout((Layout)new FillLayout());
        this.mLayoutViewer = new LayoutViewer(layoutViewerMainContainer);
        sideSash.SASH_WIDTH = 4;
        sideSash.setWeights(new int[]{238, 332, 416});
    }

    private void buildPixelPerfectPanel(Composite parent) {
        this.mPixelPerfectPanel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.mPixelPerfectPanel.setLayout((Layout)gridLayout);
        Composite buttonPanel = new Composite(this.mPixelPerfectPanel, 0);
        buttonPanel.setLayoutData((Object)new GridData(768));
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonLayout.verticalSpacing = 0;
        buttonLayout.horizontalSpacing = 0;
        buttonPanel.setLayout((Layout)buttonLayout);
        Composite innerButtonPanel = new Composite(buttonPanel, 0);
        innerButtonPanel.setLayoutData((Object)new GridData(1040));
        GridLayout innerButtonPanelLayout = new GridLayout(6, true);
        innerButtonPanelLayout.marginHeight = 2;
        innerButtonPanelLayout.marginWidth = 2;
        innerButtonPanelLayout.verticalSpacing = 2;
        innerButtonPanelLayout.horizontalSpacing = 2;
        innerButtonPanel.setLayout((Layout)innerButtonPanelLayout);
        ActionButton saveTreeView = new ActionButton(innerButtonPanel, SavePixelPerfectAction.getAction(this.getShell()));
        saveTreeView.setLayoutData(new GridData(1808));
        ActionButton refreshPixelPerfect = new ActionButton(innerButtonPanel, RefreshPixelPerfectAction.getAction());
        refreshPixelPerfect.setLayoutData(new GridData(1808));
        ActionButton refreshPixelPerfectTree = new ActionButton(innerButtonPanel, RefreshPixelPerfectTreeAction.getAction());
        refreshPixelPerfectTree.setLayoutData(new GridData(1808));
        ActionButton loadOverlay = new ActionButton(innerButtonPanel, LoadOverlayAction.getAction(this.getShell()));
        loadOverlay.setLayoutData(new GridData(1808));
        ActionButton showInLoupe = new ActionButton(innerButtonPanel, ShowOverlayAction.getAction());
        showInLoupe.setLayoutData(new GridData(1808));
        ActionButton autoRefresh = new ActionButton(innerButtonPanel, PixelPerfectAutoRefreshAction.getAction());
        autoRefresh.setLayoutData(new GridData(1808));
        SashForm mainSash = new SashForm(this.mPixelPerfectPanel, 65792);
        mainSash.setLayoutData((Object)new GridData(1808));
        mainSash.SASH_WIDTH = 4;
        Composite pixelPerfectTreeContainer = new Composite((Composite)mainSash, 2048);
        pixelPerfectTreeContainer.setLayout((Layout)new FillLayout());
        new PixelPerfectTree(pixelPerfectTreeContainer);
        Composite pixelPerfectLoupeContainer = new Composite((Composite)mainSash, 0);
        GridLayout loupeLayout = new GridLayout();
        loupeLayout.marginHeight = 0;
        loupeLayout.marginWidth = 0;
        loupeLayout.verticalSpacing = 0;
        loupeLayout.horizontalSpacing = 0;
        pixelPerfectLoupeContainer.setLayout((Layout)loupeLayout);
        Composite pixelPerfectLoupeBorder = new Composite(pixelPerfectLoupeContainer, 2048);
        pixelPerfectLoupeBorder.setLayoutData((Object)new GridData(1808));
        GridLayout pixelPerfectLoupeBorderGridLayout = new GridLayout();
        pixelPerfectLoupeBorderGridLayout.marginHeight = 0;
        pixelPerfectLoupeBorderGridLayout.marginWidth = 0;
        pixelPerfectLoupeBorderGridLayout.verticalSpacing = 0;
        pixelPerfectLoupeBorderGridLayout.horizontalSpacing = 0;
        pixelPerfectLoupeBorder.setLayout((Layout)pixelPerfectLoupeBorderGridLayout);
        this.mPixelPerfectLoupe = new PixelPerfectLoupe(pixelPerfectLoupeBorder);
        this.mPixelPerfectLoupe.setLayoutData(new GridData(1808));
        PixelPerfectPixelPanel pixelPerfectPixelPanel = new PixelPerfectPixelPanel(pixelPerfectLoupeBorder);
        pixelPerfectPixelPanel.setLayoutData(new GridData(768));
        PixelPerfectControls pixelPerfectControls = new PixelPerfectControls(pixelPerfectLoupeContainer);
        pixelPerfectControls.setLayoutData(new GridData(768));
        Composite pixelPerfectContainer = new Composite((Composite)mainSash, 2048);
        pixelPerfectContainer.setLayout((Layout)new FillLayout());
        new PixelPerfect(pixelPerfectContainer);
        mainSash.setWeights(new int[]{272, 376, 346});
    }

    public void showOverlayInLoupe(boolean value) {
        this.mPixelPerfectLoupe.setShowOverlay(value);
    }

    public void startTask(final String taskName) {
        this.mProgressString = taskName;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (HierarchyViewerApplication.this.mProgressLabel != null && HierarchyViewerApplication.this.mProgressBar != null) {
                    HierarchyViewerApplication.this.mProgressLabel.setText(taskName);
                    HierarchyViewerApplication.this.mProgressLabel.setVisible(true);
                    HierarchyViewerApplication.this.mProgressBar.setVisible(true);
                    HierarchyViewerApplication.this.mStatusBar.layout();
                }
            }
        });
    }

    public void endTask() {
        this.mProgressString = null;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (HierarchyViewerApplication.this.mProgressLabel != null && HierarchyViewerApplication.this.mProgressBar != null) {
                    HierarchyViewerApplication.this.mProgressLabel.setVisible(false);
                    HierarchyViewerApplication.this.mProgressBar.setVisible(false);
                }
            }
        });
    }

    public void showDeviceSelector() {
        MenuManager mm = this.getMenuBarManager();
        mm.removeAll();
        String os = System.getProperty("os.name");
        if (!os.startsWith("Mac OS")) {
            MenuManager file = new MenuManager("&File");
            mm.add((IContributionItem)file);
            file.add((IAction)QuitAction.getAction());
        }
        MenuManager device = new MenuManager("&Devices");
        mm.add((IContributionItem)device);
        device.add((IAction)RefreshWindowsAction.getAction());
        device.add((IAction)LoadViewHierarchyAction.getAction());
        device.add((IAction)InspectScreenshotAction.getAction());
        MenuManager help = new MenuManager("&Help");
        mm.add((IContributionItem)help);
        help.add((IAction)AboutAction.getAction(this.getShell()));
        mm.updateAll(true);
        this.mDeviceViewButton.setSelection(true);
        this.mDeviceViewButton.setImage(this.mDeviceViewSelectedImage);
        this.mTreeViewButton.setSelection(false);
        this.mTreeViewButton.setImage(this.mTreeViewImage);
        this.mPixelPerfectButton.setSelection(false);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectImage);
        this.mMainWindowStackLayout.topControl = this.mDeviceSelectorPanel;
        this.mMainWindow.layout();
        this.mDeviceSelector.setFocus();
        this.mTreeViewControls.setVisible(false);
    }

    public void showTreeView() {
        MenuManager mm = this.getMenuBarManager();
        mm.removeAll();
        String os = System.getProperty("os.name");
        if (!os.startsWith("Mac OS")) {
            MenuManager file = new MenuManager("&File");
            mm.add((IContributionItem)file);
            file.add((IAction)QuitAction.getAction());
        }
        MenuManager treeViewMenu = new MenuManager("&Tree View");
        mm.add((IContributionItem)treeViewMenu);
        treeViewMenu.add((IAction)SaveTreeViewAction.getAction(this.getShell()));
        treeViewMenu.add((IAction)CapturePSDAction.getAction(this.getShell()));
        treeViewMenu.add((IContributionItem)new Separator());
        treeViewMenu.add((IAction)RefreshViewAction.getAction());
        treeViewMenu.add((IAction)DisplayViewAction.getAction(this.getShell()));
        treeViewMenu.add((IContributionItem)new Separator());
        treeViewMenu.add((IAction)InvalidateAction.getAction());
        treeViewMenu.add((IAction)RequestLayoutAction.getAction());
        MenuManager help = new MenuManager("&Help");
        mm.add((IContributionItem)help);
        help.add((IAction)AboutAction.getAction(this.getShell()));
        mm.updateAll(true);
        this.mDeviceViewButton.setSelection(false);
        this.mDeviceViewButton.setImage(this.mDeviceViewImage);
        this.mTreeViewButton.setSelection(true);
        this.mTreeViewButton.setImage(this.mTreeViewSelectedImage);
        this.mPixelPerfectButton.setSelection(false);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectImage);
        this.mMainWindowStackLayout.topControl = this.mTreeViewPanel;
        this.mMainWindow.layout();
        this.mTreeView.setFocus();
        this.mTreeViewControls.setVisible(true);
    }

    public void showPixelPerfect() {
        MenuManager mm = this.getMenuBarManager();
        mm.removeAll();
        String os = System.getProperty("os.name");
        if (!os.startsWith("Mac OS")) {
            MenuManager file = new MenuManager("&File");
            mm.add((IContributionItem)file);
            file.add((IAction)QuitAction.getAction());
        }
        MenuManager pixelPerfect = new MenuManager("&Pixel Perfect");
        pixelPerfect.add((IAction)SavePixelPerfectAction.getAction(this.getShell()));
        pixelPerfect.add((IAction)RefreshPixelPerfectAction.getAction());
        pixelPerfect.add((IAction)RefreshPixelPerfectTreeAction.getAction());
        pixelPerfect.add((IAction)PixelPerfectAutoRefreshAction.getAction());
        pixelPerfect.add((IContributionItem)new Separator());
        pixelPerfect.add((IAction)LoadOverlayAction.getAction(this.getShell()));
        pixelPerfect.add((IAction)ShowOverlayAction.getAction());
        mm.add((IContributionItem)pixelPerfect);
        MenuManager help = new MenuManager("&Help");
        mm.add((IContributionItem)help);
        help.add((IAction)AboutAction.getAction(this.getShell()));
        mm.updateAll(true);
        this.mDeviceViewButton.setSelection(false);
        this.mDeviceViewButton.setImage(this.mDeviceViewImage);
        this.mTreeViewButton.setSelection(false);
        this.mTreeViewButton.setImage(this.mTreeViewImage);
        this.mPixelPerfectButton.setSelection(true);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectSelectedImage);
        this.mMainWindowStackLayout.topControl = this.mPixelPerfectPanel;
        this.mMainWindow.layout();
        this.mPixelPerfectLoupe.setFocus();
        this.mTreeViewControls.setVisible(false);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        Display.setAppName((String)"HierarchyViewer");
        new HierarchyViewerApplication().run();
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            Log.e("HierarchyViewer", "shutting down due to uncaught exception");
            Log.e("HierarchyViewer", e);
            System.exit(1);
        }
    }
}

