/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class CoverageData
implements ICoverageData,
Cloneable {
    private HashMap m_coverageMap;

    public Object lock() {
        return this.m_coverageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICoverageData shallowCopy() {
        HashMap _coverageMap;
        CoverageData _clone;
        try {
            _clone = (CoverageData)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error(cnse.toString());
        }
        Object object = this.lock();
        synchronized (object) {
            _coverageMap = (HashMap)this.m_coverageMap.clone();
        }
        _clone.m_coverageMap = _coverageMap;
        return _clone;
    }

    public int size() {
        return this.m_coverageMap.size();
    }

    public ICoverageData.DataHolder getCoverage(ClassDescriptor cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        return (ICoverageData.DataHolder)this.m_coverageMap.get(cls.getClassVMName());
    }

    public void addClass(boolean[][] coverage, String classVMName, long stamp) {
        this.m_coverageMap.put(classVMName, new ICoverageData.DataHolder(coverage, stamp));
    }

    public boolean isEmpty() {
        return this.m_coverageMap.isEmpty();
    }

    public IMergeable merge(IMergeable rhs) {
        if (rhs == null || rhs.isEmpty() || rhs == this) {
            return this;
        }
        CoverageData rhscdata = (CoverageData)rhs;
        HashMap rhscoverageData = rhscdata.m_coverageMap;
        for (Map.Entry entry : rhscoverageData.entrySet()) {
            String classVMName = (String)entry.getKey();
            ICoverageData.DataHolder rhsdata = (ICoverageData.DataHolder)entry.getValue();
            ICoverageData.DataHolder data = (ICoverageData.DataHolder)this.m_coverageMap.get(classVMName);
            if (data == null) {
                this.m_coverageMap.put(classVMName, rhsdata);
                continue;
            }
            if (rhsdata.m_stamp != data.m_stamp) {
                this.m_coverageMap.put(classVMName, rhsdata);
                continue;
            }
            boolean[][] rhscoverage = rhsdata.m_coverage;
            boolean[][] coverage = data.m_coverage;
            int mLimit = coverage.length;
            for (int m = 0; m < mLimit; ++m) {
                boolean[] rhsmcoverage = rhscoverage[m];
                boolean[] mcoverage = coverage[m];
                if (mcoverage == null) continue;
                int bLimit = mcoverage.length;
                for (int b = 0; b < bLimit; ++b) {
                    if (!rhsmcoverage[b]) continue;
                    mcoverage[b] = true;
                }
            }
        }
        return this;
    }

    CoverageData() {
        this.m_coverageMap = new HashMap();
    }

    static CoverageData readExternal(DataInput in) throws IOException {
        int size = in.readInt();
        HashMap<String, ICoverageData.DataHolder> coverageMap = new HashMap<String, ICoverageData.DataHolder>(size);
        for (int i = 0; i < size; ++i) {
            String classVMName = in.readUTF();
            long stamp = in.readLong();
            int length = in.readInt();
            boolean[][] coverage = new boolean[length][];
            for (int c = 0; c < length; ++c) {
                coverage[c] = DataFactory.readBooleanArray(in);
            }
            coverageMap.put(classVMName, new ICoverageData.DataHolder(coverage, stamp));
        }
        return new CoverageData(coverageMap);
    }

    static void writeExternal(CoverageData cdata, DataOutput out) throws IOException {
        HashMap coverageMap = cdata.m_coverageMap;
        int size = coverageMap.size();
        out.writeInt(size);
        Iterator entries = coverageMap.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = entries.next();
            String classVMName = (String)entry.getKey();
            ICoverageData.DataHolder data = (ICoverageData.DataHolder)entry.getValue();
            boolean[][] coverage = data.m_coverage;
            out.writeUTF(classVMName);
            out.writeLong(data.m_stamp);
            int length = coverage.length;
            out.writeInt(length);
            for (int c = 0; c < length; ++c) {
                DataFactory.writeBooleanArray(coverage[c], out);
            }
        }
    }

    private CoverageData(HashMap coverageMap) {
        this.m_coverageMap = coverageMap;
    }
}

