/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.PlatformTarget;
import com.android.sdklib.SdkConstants;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AddOnTarget
implements IAndroidTarget {
    private static final String ADD_ON_FORMAT = "%s:%s:%s";
    private final String mLocation;
    private final PlatformTarget mBasePlatform;
    private final String mName;
    private final String mVendor;
    private final int mRevision;
    private final String mDescription;
    private String[] mSkins;
    private String mDefaultSkin;
    private IAndroidTarget.IOptionalLibrary[] mLibraries;
    private int mVendorId = 0;

    AddOnTarget(String location, String name, String vendor, int revision, String description, Map<String, String[]> libMap, PlatformTarget basePlatform) {
        if (!location.endsWith(File.separator)) {
            location = location + File.separator;
        }
        this.mLocation = location;
        this.mName = name;
        this.mVendor = vendor;
        this.mRevision = revision;
        this.mDescription = description;
        this.mBasePlatform = basePlatform;
        if (libMap != null) {
            this.mLibraries = new IAndroidTarget.IOptionalLibrary[libMap.size()];
            int index = 0;
            for (Map.Entry<String, String[]> entry : libMap.entrySet()) {
                String jarFile = entry.getValue()[0];
                String desc = entry.getValue()[1];
                this.mLibraries[index++] = new OptionalLibrary(jarFile, this.mLocation + SdkConstants.OS_ADDON_LIBS_FOLDER + jarFile, entry.getKey(), desc);
            }
        }
    }

    @Override
    public String getLocation() {
        return this.mLocation;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public String getFullName() {
        return String.format("%1$s (%2$s)", this.mName, this.mVendor);
    }

    @Override
    public String getClasspathName() {
        return String.format("%1$s [%2$s]", this.mName, this.mBasePlatform.getName());
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mBasePlatform.getVersion();
    }

    @Override
    public String getVersionName() {
        return this.mBasePlatform.getVersionName();
    }

    @Override
    public int getRevision() {
        return this.mRevision;
    }

    @Override
    public boolean isPlatform() {
        return false;
    }

    @Override
    public IAndroidTarget getParent() {
        return this.mBasePlatform;
    }

    @Override
    public String getPath(int pathId) {
        switch (pathId) {
            case 3: {
                return this.mLocation + SdkConstants.OS_IMAGES_FOLDER;
            }
            case 5: {
                return this.mLocation + SdkConstants.OS_SKINS_FOLDER;
            }
            case 19: {
                return this.mLocation + "docs" + File.separator + "reference";
            }
            case 4: {
                File[] files;
                File sampleLoc = new File(this.mLocation, "samples");
                if (!sampleLoc.isDirectory() || (files = sampleLoc.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) == null || files.length <= 0) break;
                return sampleLoc.getAbsolutePath();
            }
        }
        return this.mBasePlatform.getPath(pathId);
    }

    @Override
    public String[] getSkins() {
        return this.mSkins;
    }

    @Override
    public String getDefaultSkin() {
        return this.mDefaultSkin;
    }

    @Override
    public IAndroidTarget.IOptionalLibrary[] getOptionalLibraries() {
        return this.mLibraries;
    }

    @Override
    public String[] getPlatformLibraries() {
        return this.mBasePlatform.getPlatformLibraries();
    }

    @Override
    public String getProperty(String name) {
        return this.mBasePlatform.getProperty(name);
    }

    @Override
    public Integer getProperty(String name, Integer defaultValue) {
        return this.mBasePlatform.getProperty(name, defaultValue);
    }

    @Override
    public Boolean getProperty(String name, Boolean defaultValue) {
        return this.mBasePlatform.getProperty(name, defaultValue);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mBasePlatform.getProperties();
    }

    @Override
    public int getUsbVendorId() {
        return this.mVendorId;
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        if (target == this) {
            return true;
        }
        if (this.mLibraries == null || this.mLibraries.length == 0) {
            return this.mBasePlatform.canRunOn(target);
        }
        if (!this.mVendor.equals(target.getVendor()) || !this.mName.equals(target.getName())) {
            return false;
        }
        return this.mBasePlatform.canRunOn(target);
    }

    @Override
    public String hashString() {
        return String.format(ADD_ON_FORMAT, this.mVendor, this.mName, this.mBasePlatform.getVersion().getApiString());
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AddOnTarget) {
            AddOnTarget addon = (AddOnTarget)obj;
            return this.mVendor.equals(addon.mVendor) && this.mName.equals(addon.mName) && this.mBasePlatform.getVersion().equals(addon.mBasePlatform.getVersion());
        }
        return false;
    }

    @Override
    public int compareTo(IAndroidTarget target) {
        if (this == target) {
            return 0;
        }
        int versionDiff = this.getVersion().compareTo(target.getVersion());
        if (versionDiff == 0) {
            if (target.isPlatform()) {
                return 1;
            }
            AddOnTarget targetAddOn = (AddOnTarget)target;
            int vendorDiff = this.mVendor.compareTo(targetAddOn.mVendor);
            if (vendorDiff == 0) {
                return this.mName.compareTo(targetAddOn.mName);
            }
            return vendorDiff;
        }
        return versionDiff;
    }

    void setSkins(String[] skins, String defaultSkin) {
        this.mDefaultSkin = defaultSkin;
        HashSet<String> skinSet = new HashSet<String>();
        skinSet.addAll(Arrays.asList(skins));
        skinSet.addAll(Arrays.asList(this.mBasePlatform.getSkins()));
        this.mSkins = skinSet.toArray(new String[skinSet.size()]);
    }

    void setUsbVendorId(int vendorId) {
        if (vendorId == 0) {
            throw new IllegalArgumentException("VendorId must be > 0");
        }
        this.mVendorId = vendorId;
    }

    private static final class OptionalLibrary
    implements IAndroidTarget.IOptionalLibrary {
        private final String mJarName;
        private final String mJarPath;
        private final String mName;
        private final String mDescription;

        OptionalLibrary(String jarName, String jarPath, String name, String description) {
            this.mJarName = jarName;
            this.mJarPath = jarPath;
            this.mName = name;
            this.mDescription = description;
        }

        public String getJarName() {
            return this.mJarName;
        }

        public String getJarPath() {
            return this.mJarPath;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }
}

