/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidVersion
implements Comparable<AndroidVersion> {
    private static final String PROP_API_LEVEL = "AndroidVersion.ApiLevel";
    private static final String PROP_CODENAME = "AndroidVersion.CodeName";
    private final int mApiLevel;
    private final String mCodename;

    public AndroidVersion(int apiLevel, String codename) {
        this.mApiLevel = apiLevel;
        this.mCodename = codename;
    }

    public AndroidVersion(Properties properties, int defaultApiLevel, String defaultCodeName) {
        if (properties == null) {
            this.mApiLevel = defaultApiLevel;
            this.mCodename = defaultCodeName;
        } else {
            this.mApiLevel = Integer.parseInt(properties.getProperty(PROP_API_LEVEL, Integer.toString(defaultApiLevel)));
            this.mCodename = properties.getProperty(PROP_CODENAME, defaultCodeName);
        }
    }

    public AndroidVersion(Properties properties) throws AndroidVersionException {
        NumberFormatException error = null;
        String apiLevel = properties.getProperty(PROP_API_LEVEL, null);
        if (apiLevel != null) {
            try {
                this.mApiLevel = Integer.parseInt(apiLevel);
                this.mCodename = properties.getProperty(PROP_CODENAME, null);
                return;
            }
            catch (NumberFormatException e) {
                error = e;
            }
        }
        throw new AndroidVersionException("AndroidVersion.ApiLevel not found!", error);
    }

    public void saveProperties(Properties props) {
        props.setProperty(PROP_API_LEVEL, Integer.toString(this.mApiLevel));
        if (this.mCodename != null) {
            props.setProperty(PROP_CODENAME, this.mCodename);
        }
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public String getApiString() {
        if (this.mCodename != null) {
            return this.mCodename;
        }
        return Integer.toString(this.mApiLevel);
    }

    public boolean isPreview() {
        return this.mCodename != null;
    }

    public boolean canRun(AndroidVersion appVersion) {
        if (appVersion.mCodename != null) {
            return appVersion.mCodename.equals(this.mCodename);
        }
        return this.mApiLevel >= appVersion.mApiLevel;
    }

    public boolean equals(int apiLevel) {
        return this.mCodename == null && apiLevel == this.mApiLevel;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AndroidVersion) {
            AndroidVersion version = (AndroidVersion)obj;
            if (this.mCodename == null) {
                return version.mCodename == null && this.mApiLevel == version.mApiLevel;
            }
            return this.mCodename.equals(version.mCodename) && this.mApiLevel == version.mApiLevel;
        }
        if (obj instanceof String) {
            if (this.mCodename != null) {
                return this.mCodename.equals(obj);
            }
            try {
                int value = Integer.parseInt((String)obj);
                return value == this.mApiLevel;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.mCodename != null) {
            return this.mCodename.hashCode();
        }
        return this.mApiLevel;
    }

    public String toString() {
        String s = String.format("API %1$d", this.mApiLevel);
        if (this.isPreview()) {
            s = s + String.format(", %1$s preview", this.mCodename);
        }
        return s;
    }

    @Override
    public int compareTo(AndroidVersion o) {
        return this.compareTo(o.mApiLevel, o.mCodename);
    }

    private int compareTo(int apiLevel, String codename) {
        if (this.mCodename == null) {
            if (codename == null) {
                return this.mApiLevel - apiLevel;
            }
            if (this.mApiLevel == apiLevel) {
                return -1;
            }
            return this.mApiLevel - apiLevel;
        }
        if (this.mApiLevel == apiLevel) {
            if (codename == null) {
                return 1;
            }
            return this.mCodename.compareTo(codename);
        }
        return this.mApiLevel - apiLevel;
    }

    public boolean isGreaterOrEqualThan(int api) {
        return this.compareTo(api, null) >= 0;
    }

    public static final class AndroidVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AndroidVersionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

