/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkConstants;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlatformTarget
implements IAndroidTarget {
    private static final String PLATFORM_HASH = "android-%s";
    private static final String PLATFORM_VENDOR = "Android Open Source Project";
    private static final String PLATFORM_NAME = "Android %s";
    private static final String PLATFORM_NAME_PREVIEW = "Android %s (Preview)";
    private final String mRootFolderOsPath;
    private final String mName;
    private final AndroidVersion mVersion;
    private final String mVersionName;
    private final int mRevision;
    private final Map<String, String> mProperties;
    private final Map<Integer, String> mPaths = new HashMap<Integer, String>();
    private String[] mSkins;

    PlatformTarget(String sdkOsPath, String platformOSPath, Map<String, String> properties, int apiLevel, String codeName, String versionName, int revision) {
        if (!platformOSPath.endsWith(File.separator)) {
            platformOSPath = platformOSPath + File.separator;
        }
        this.mRootFolderOsPath = platformOSPath;
        this.mProperties = Collections.unmodifiableMap(properties);
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mVersionName = versionName;
        this.mRevision = revision;
        this.mName = this.mVersion.isPreview() ? String.format(PLATFORM_NAME_PREVIEW, this.mVersionName) : String.format(PLATFORM_NAME, this.mVersionName);
        this.mPaths.put(1, this.mRootFolderOsPath + "android.jar");
        this.mPaths.put(18, this.mRootFolderOsPath + "sources");
        this.mPaths.put(2, this.mRootFolderOsPath + "framework.aidl");
        this.mPaths.put(3, this.mRootFolderOsPath + SdkConstants.OS_IMAGES_FOLDER);
        this.mPaths.put(4, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_SAMPLES_FOLDER);
        this.mPaths.put(5, this.mRootFolderOsPath + SdkConstants.OS_SKINS_FOLDER);
        this.mPaths.put(6, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_TEMPLATES_FOLDER);
        this.mPaths.put(7, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER);
        this.mPaths.put(8, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ATTRS_XML);
        this.mPaths.put(9, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ATTRS_MANIFEST_XML);
        this.mPaths.put(11, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_RESOURCES_FOLDER);
        this.mPaths.put(12, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_FONTS_FOLDER);
        this.mPaths.put(10, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "layoutlib.jar");
        this.mPaths.put(13, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "widgets.txt");
        this.mPaths.put(14, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "activity_actions.txt");
        this.mPaths.put(15, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "broadcast_actions.txt");
        this.mPaths.put(16, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "service_actions.txt");
        this.mPaths.put(17, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_DATA_FOLDER + "categories.txt");
        this.mPaths.put(24, this.mRootFolderOsPath + SdkConstants.OS_PLATFORM_ANT_FOLDER);
        this.mPaths.put(20, sdkOsPath + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_AAPT);
        this.mPaths.put(21, sdkOsPath + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_AIDL);
        this.mPaths.put(22, sdkOsPath + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_DX);
        this.mPaths.put(23, sdkOsPath + SdkConstants.OS_SDK_PLATFORM_TOOLS_LIB_FOLDER + "dx.jar");
    }

    @Override
    public String getLocation() {
        return this.mRootFolderOsPath;
    }

    @Override
    public String getVendor() {
        return PLATFORM_VENDOR;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getFullName() {
        return this.mName;
    }

    @Override
    public String getClasspathName() {
        return this.mName;
    }

    @Override
    public String getDescription() {
        return String.format("Standard Android platform %s", this.mVersionName);
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String getVersionName() {
        return this.mVersionName;
    }

    @Override
    public int getRevision() {
        return this.mRevision;
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public String getPath(int pathId) {
        return this.mPaths.get(pathId);
    }

    @Override
    public String[] getSkins() {
        return this.mSkins;
    }

    @Override
    public String getDefaultSkin() {
        return "HVGA";
    }

    @Override
    public IAndroidTarget.IOptionalLibrary[] getOptionalLibraries() {
        return null;
    }

    @Override
    public String[] getPlatformLibraries() {
        return new String[]{"android.test.runner"};
    }

    @Override
    public int getUsbVendorId() {
        return 0;
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        if (target == this) {
            return true;
        }
        if (this.mVersion.getCodename() != null) {
            return this.mVersion.equals(target.getVersion());
        }
        return target.getVersion().getApiLevel() >= this.mVersion.getApiLevel();
    }

    @Override
    public String hashString() {
        return String.format(PLATFORM_HASH, this.mVersion.getApiString());
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlatformTarget) {
            PlatformTarget platform = (PlatformTarget)obj;
            return this.mVersion.equals(platform.getVersion());
        }
        return false;
    }

    @Override
    public int compareTo(IAndroidTarget target) {
        if (this == target) {
            return 0;
        }
        int versionDiff = this.mVersion.compareTo(target.getVersion());
        if (versionDiff == 0 && !target.isPlatform()) {
            return -1;
        }
        return versionDiff;
    }

    @Override
    public String getProperty(String name) {
        return this.mProperties.get(name);
    }

    @Override
    public Integer getProperty(String name, Integer defaultValue) {
        try {
            String value = this.getProperty(name);
            if (value != null) {
                return Integer.decode(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public Boolean getProperty(String name, Boolean defaultValue) {
        String value = this.getProperty(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    void setSkins(String[] skins) {
        this.mSkins = skins;
    }

    void setSamplesPath(String osLocation) {
        this.mPaths.put(4, osLocation);
    }
}

