/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.ISdkLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardwareProperties {
    private static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    private static final String HW_PROP_NAME = "name";
    private static final String HW_PROP_TYPE = "type";
    private static final String HW_PROP_DEFAULT = "default";
    private static final String HW_PROP_ABSTRACT = "abstract";
    private static final String HW_PROP_DESC = "description";
    private static final String BOOLEAN_YES = "yes";
    private static final String BOOLEAN_NO = "no";
    public static final String[] BOOLEAN_VALUES = new String[]{"yes", "no"};
    public static final Pattern DISKSIZE_PATTERN = Pattern.compile("\\d+[MK]B");

    public static Map<String, HardwareProperty> parseHardwareDefinitions(File file, ISdkLog log) {
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            HashMap<String, HardwareProperty> map = new HashMap<String, HardwareProperty>();
            String line = null;
            HardwareProperty prop = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                Matcher m = PATTERN_PROP.matcher(line);
                if (m.matches()) {
                    String valueName = m.group(1);
                    String value = m.group(2);
                    if (HW_PROP_NAME.equals(valueName)) {
                        prop = new HardwareProperty();
                        prop.mName = value;
                        map.put(prop.mName, prop);
                    }
                    if (prop == null) {
                        log.warning("Error parsing '%1$s': missing '%2$s'", file.getAbsolutePath(), HW_PROP_NAME);
                        return null;
                    }
                    if (HW_PROP_TYPE.equals(valueName)) {
                        prop.mType = ValueType.getEnum(value);
                        continue;
                    }
                    if (HW_PROP_DEFAULT.equals(valueName)) {
                        prop.mDefault = value;
                        continue;
                    }
                    if (HW_PROP_ABSTRACT.equals(valueName)) {
                        prop.mAbstract = value;
                        continue;
                    }
                    if (!HW_PROP_DESC.equals(valueName)) continue;
                    prop.mDescription = value;
                    continue;
                }
                log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", file.getAbsolutePath(), line);
                return null;
            }
            return map;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            log.warning("Error parsing '%1$s': %2$s.", file.getAbsolutePath(), e.getMessage());
        }
        return null;
    }

    public static int getBooleanValueIndex(String value) {
        if (BOOLEAN_YES.equals(value)) {
            return 0;
        }
        if (BOOLEAN_NO.equals(value)) {
            return 1;
        }
        return -1;
    }

    public static final class HardwareProperty {
        private String mName;
        private ValueType mType;
        private String mDefault;
        private String mAbstract;
        private String mDescription;

        public String getName() {
            return this.mName;
        }

        public ValueType getType() {
            return this.mType;
        }

        public String getDefault() {
            return this.mDefault;
        }

        public String getAbstract() {
            return this.mAbstract;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        INTEGER("integer"),
        BOOLEAN("boolean"),
        DISKSIZE("diskSize");

        private String mValue;

        private ValueType(String value) {
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }

        public static ValueType getEnum(String value) {
            for (ValueType type : ValueType.values()) {
                if (!type.mValue.equals(value)) continue;
                return type;
            }
            return null;
        }
    }
}

