/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.export;

import com.android.sdklib.internal.export.ApkData;
import com.android.sdklib.internal.export.ProjectConfig;
import com.android.sdklib.io.FileWrapper;
import com.android.sdklib.io.StreamException;
import com.android.sdklib.xml.AndroidManifestParser;
import com.android.sdklib.xml.ManifestData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiApkExportHelper {
    private static final String PROP_VERSIONCODE = "versionCode";
    private static final String PROP_PACKAGE = "package";
    private final String mExportProjectRoot;
    private final String mAppPackage;
    private final int mVersionCode;
    private final Target mTarget;
    private ArrayList<ProjectConfig> mProjectList;
    private ArrayList<ApkData> mApkDataList;
    static final int MAX_MINOR = 100;
    static final int MAX_BUILDINFO = 100;
    static final int OFFSET_BUILD_INFO = 100;
    static final int OFFSET_VERSION_CODE = 10000;
    private static final String FILE_CONFIG = "projects.config";
    private static final String FILE_MINOR_CODE = "minor.codes";
    private static final String FOLDER_LOG = "logs";
    private final PrintStream mStdio;

    public MultiApkExportHelper(String exportProjectRoot, String appPackage, int versionCode, Target target, PrintStream stdio) {
        this.mExportProjectRoot = exportProjectRoot;
        this.mAppPackage = appPackage;
        this.mVersionCode = versionCode;
        this.mTarget = target;
        this.mStdio = stdio;
    }

    public List<ApkData> getApkData(String projectList) throws ExportException {
        if (this.mTarget != Target.RELEASE) {
            throw new IllegalArgumentException("getApkData must only be called for Target.RELEASE");
        }
        List<ProjectConfig> projects = this.getProjects(projectList);
        File configProp = new File(this.mExportProjectRoot, FILE_CONFIG);
        if (configProp.isFile()) {
            this.compareProjectsToConfigFile(projects, configProp);
        }
        File minorCodeProp = new File(this.mExportProjectRoot, FILE_MINOR_CODE);
        Map<Integer, Integer> minorCodeMap = null;
        if (minorCodeProp.isFile()) {
            minorCodeMap = this.getMinorCodeMap(minorCodeProp);
        }
        return this.getApkData(projects, minorCodeMap);
    }

    public List<ProjectConfig> getProjects(String projectList) throws ExportException {
        String[] paths = projectList.split("\\:");
        this.mProjectList = new ArrayList();
        for (String path : paths) {
            path = path.replaceAll("\\/", File.separator);
            this.processProject(path, this.mProjectList);
        }
        return this.mProjectList;
    }

    public void writeLogs() throws ExportException {
        this.writeConfigProperties();
        this.writeMinorVersionProperties();
        this.writeApkLog();
    }

    private void writeConfigProperties() throws ExportException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(new FileOutputStream(new File(this.mExportProjectRoot, FILE_CONFIG)));
            writer.append("# PROJECT CONFIG -- DO NOT DELETE.\n");
            this.writeValue(writer, PROP_VERSIONCODE, this.mVersionCode);
            for (ProjectConfig project : this.mProjectList) {
                this.writeValue(writer, project.getRelativePath(), project.getConfigString(false));
            }
            writer.flush();
        }
        catch (Exception e) {
            throw new ExportException("Failed to write config log", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new ExportException("Failed to write config log", e);
            }
        }
    }

    private void writeMinorVersionProperties() throws ExportException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(new FileOutputStream(new File(this.mExportProjectRoot, FILE_MINOR_CODE)));
            writer.append("# Minor version codes.\n# To create update to select APKs without updating the main versionCode\n# edit this file and manually increase the minor version for the select\n# build info.\n# Format of the file is <buildinfo>:<minor>\n");
            this.writeValue(writer, PROP_VERSIONCODE, this.mVersionCode);
            for (ApkData apk : this.mApkDataList) {
                this.writeValue(writer, Integer.toString(apk.getBuildInfo()), apk.getMinorCode());
            }
            writer.flush();
        }
        catch (Exception e) {
            throw new ExportException("Failed to write minor log", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new ExportException("Failed to write minor log", e);
            }
        }
    }

    private void writeApkLog() throws ExportException {
        OutputStreamWriter writer = null;
        try {
            File logFolder = new File(this.mExportProjectRoot, FOLDER_LOG);
            if (logFolder.isFile()) {
                throw new ExportException("Cannot create folder '%1$s', file is in the way!", FOLDER_LOG);
            }
            if (!logFolder.exists()) {
                logFolder.mkdir();
            }
            Formatter formatter = new Formatter();
            formatter.format("%1$s.%2$d-%3$tY%3$tm%3$td-%3$tH%3$tM.log", this.mAppPackage, this.mVersionCode, Calendar.getInstance().getTime());
            writer = new OutputStreamWriter(new FileOutputStream(new File(logFolder, formatter.toString())));
            writer.append("# Multi-APK BUILD LOG.\n");
            this.writeValue(writer, PROP_PACKAGE, this.mAppPackage);
            this.writeValue(writer, PROP_VERSIONCODE, this.mVersionCode);
            for (ApkData apk : this.mApkDataList) {
                Map<String, String> softVariants = apk.getSoftVariantMap();
                if (softVariants.size() > 0) {
                    for (String softVariant : softVariants.keySet()) {
                        writer.append(apk.getLogLine(softVariant));
                        writer.append('\n');
                    }
                    continue;
                }
                writer.append(apk.getLogLine(null));
                writer.append('\n');
            }
            writer.flush();
        }
        catch (Exception e) {
            throw new ExportException("Failed to write build log", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new ExportException("Failed to write build log", e);
            }
        }
    }

    private void writeValue(OutputStreamWriter writer, String name, String value) throws IOException {
        writer.append(name).append(':').append(value).append('\n');
    }

    private void writeValue(OutputStreamWriter writer, String name, int value) throws IOException {
        this.writeValue(writer, name, Integer.toString(value));
    }

    private List<ApkData> getApkData(List<ProjectConfig> projects, Map<Integer, Integer> minorCodes) {
        this.mApkDataList = new ArrayList();
        for (ProjectConfig config : projects) {
            this.mApkDataList.addAll(config.getApkDataList());
        }
        Collections.sort(this.mApkDataList);
        int buildInfo = 0;
        for (ApkData data : this.mApkDataList) {
            Integer minorCode;
            data.setBuildInfo(buildInfo);
            if (minorCodes != null && (minorCode = minorCodes.get(buildInfo)) != null) {
                data.setMinorCode(minorCode);
            }
            ++buildInfo;
        }
        return this.mApkDataList;
    }

    private void processProject(String relativePath, ArrayList<ProjectConfig> projects) throws ExportException {
        File projectFolder;
        try {
            File path = new File(this.mExportProjectRoot, relativePath);
            projectFolder = path.getCanonicalFile();
            if (!projectFolder.isDirectory()) {
                throw new ExportException("Project folder '%1$s' is not a valid directory.", projectFolder.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new ExportException(e, "Failed to resolve path %1$s", relativePath);
        }
        try {
            FileWrapper androidManifest = new FileWrapper(projectFolder, "AndroidManifest.xml");
            if (!androidManifest.exists()) {
                throw new ExportException(String.format("%1$s is not a valid project (%2$s not found).", relativePath, androidManifest.getOsLocation()));
            }
            this.mStdio.println(String.format("%1$s => %2$s", relativePath, projectFolder.getAbsolutePath()));
            ManifestData manifestData = AndroidManifestParser.parse(androidManifest);
            String manifestPackage = manifestData.getPackage();
            if (!this.mAppPackage.equals(manifestPackage)) {
                throw new ExportException("%1$s package value is not valid. Found '%2$s', expected '%3$s'.", androidManifest.getOsLocation(), manifestPackage, this.mAppPackage);
            }
            if (manifestData.getVersionCode() != null) {
                throw new ExportException("%1$s is not valid: versionCode must not be set for multi-apk export.", androidManifest.getOsLocation());
            }
            int minSdkVersion = manifestData.getMinSdkVersion();
            if (minSdkVersion == 0) {
                throw new ExportException("Codename in minSdkVersion is not supported by multi-apk export.");
            }
            for (ProjectConfig otherProject : projects) {
                if (minSdkVersion != otherProject.getMinSdkVersion()) continue;
                ManifestData.SupportsScreens currentSS = manifestData.getSupportsScreensValues();
                ManifestData.SupportsScreens previousSS = otherProject.getSupportsScreens();
                boolean sameSupportsScreens = currentSS.hasSameScreenSupportAs(previousSS);
                if (manifestData.getGlEsVersion() == otherProject.getGlEsVersion() && sameSupportsScreens) {
                    throw new ExportException("Android manifests must differ in at least one of the following values:\n- minSdkVersion\n- SupportsScreen (screen sizes only)\n- GL ES version.\n%1$s and %2$s are considered identical for multi-apk export.", relativePath, otherProject.getRelativePath());
                }
                if (sameSupportsScreens) continue;
                if (!currentSS.hasStrictlyDifferentScreenSupportAs(previousSS)) {
                    throw new ExportException("APK differentiation by Supports-Screens cannot support different APKs supporting the same screen size.\n%1$s supports %2$s\n%3$s supports %4$s\n", relativePath, currentSS.toString(), otherProject.getRelativePath(), previousSS.toString());
                }
                if (!currentSS.overlapWith(previousSS)) continue;
                throw new ExportException("Unable to compute APK priority due to incompatible difference in Supports-Screens values.\n%1$s supports %2$s\n%3$s supports %4$s\n", relativePath, currentSS.toString(), otherProject.getRelativePath(), previousSS.toString());
            }
            ProjectConfig config = ProjectConfig.create(projectFolder, relativePath, manifestData);
            projects.add(config);
        }
        catch (SAXException e) {
            throw new ExportException(e, "Failed to validate %1$s", relativePath);
        }
        catch (IOException e) {
            throw new ExportException(e, "Failed to validate %1$s", relativePath);
        }
        catch (StreamException e) {
            throw new ExportException(e, "Failed to validate %1$s", relativePath);
        }
        catch (ParserConfigurationException e) {
            throw new ExportException(e, "Failed to validate %1$s", relativePath);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compareProjectsToConfigFile(List<ProjectConfig> projects, File configProp) throws ExportException {
        block25: {
            block23: {
                block24: {
                    reader = null;
                    bufferedReader = null;
                    try {
                        reader = new InputStreamReader(new FileInputStream(configProp));
                        bufferedReader = new BufferedReader(reader);
                        projectsToCheck = new ArrayList<ProjectConfig>();
                        projectsToCheck.addAll(projects);
                        badMatch = null;
                        errorMsg = null;
                        checkedVersion = false;
                        lineNumber = 0;
lbl13:
                        // 5 sources

                        while ((line = bufferedReader.readLine()) != null) {
                            ++lineNumber;
                            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                            colonPos = line.indexOf(58);
                            if (colonPos == -1) {
                                throw new ExportException("Failed to read existing build log. Line %d is not a property line.", new Object[]{lineNumber});
                            }
                            name = line.substring(0, colonPos);
                            value = line.substring(colonPos + 1);
                            if (!"versionCode".equals(name)) break block23;
                            try {
                                versionCode = Integer.parseInt(value);
                                if (versionCode < this.mVersionCode) {
                                    break block24;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (NumberFormatException e) {
                                throw new ExportException("Failed to read integer property %1$s at line %2$d.", new Object[]{"versionCode", lineNumber});
                            }
                        }
                        break block25;
                    }
                    catch (IOException e) {
                        try {
                            throw new ExportException(e, "Failed to read existing config log: %s", new Object[]{"projects.config"});
                        }
                        catch (Throwable var22_28) {
                            try {
                                if (reader == null) throw var22_28;
                                reader.close();
                                throw var22_28;
                            }
                            catch (IOException e) {
                                throw new ExportException(e, "Failed to read existing config log: %s", new Object[]{"projects.config"});
                            }
                        }
                    }
                }
                try {
                    if (reader == null) return;
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    throw new ExportException(e, "Failed to read existing config log: %s", new Object[]{"projects.config"});
                }
lbl-1000:
                // 1 sources

                {
                    if (versionCode > this.mVersionCode) {
                        throw new ExportException("Incompatible versionCode: Exporting at versionCode %1$d but %2$s file indicate previous export with versionCode %3$d.", new Object[]{this.mVersionCode, "projects.config", versionCode});
                    }
                    if (badMatch != null) break block25;
                    checkedVersion = true;
                    ** GOTO lbl13
                }
            }
            found = null;
            for (i = 0; i < projectsToCheck.size(); ++i) {
                p = (ProjectConfig)projectsToCheck.get(i);
                if (!p.getRelativePath().equals(name)) continue;
                found = p;
                projectsToCheck.remove(i);
                break;
            }
            if (found == null) {
                throw new ExportException("Project %1$s has been removed from the list of projects to export.\nAny change in the multi-apk configuration requires an increment of the versionCode in export.properties.", new Object[]{name});
            }
            map = new HashMap<String, String>();
            for (String prop : properties = value.split(";")) {
                equalPos = prop.indexOf(61);
                map.put(prop.substring(0, equalPos), prop.substring(equalPos + 1));
            }
            errorMsg = found.compareToProperties(map);
            if (errorMsg == null) ** GOTO lbl13
            badMatch = found;
            if (!checkedVersion) ** GOTO lbl13
        }
        if (badMatch != null) {
            throw new ExportException("Config for project %1$s has changed from previous export with versionCode %2$d:\n\t%3$s\nAny change in the multi-apk configuration requires an increment of the versionCode in export.properties.", new Object[]{badMatch.getRelativePath(), this.mVersionCode, errorMsg});
        }
        if (projectsToCheck.size() > 0) {
            throw new ExportException("Project %1$s was not part of the previous export with versionCode %2$d.\nAny change in the multi-apk configuration requires an increment of the versionCode in export.properties.", new Object[]{((ProjectConfig)projectsToCheck.get(0)).getRelativePath(), this.mVersionCode});
        }
        try {
            if (reader == null) return;
            reader.close();
            return;
        }
        catch (IOException e) {
            throw new ExportException(e, "Failed to read existing config log: %s", new Object[]{"projects.config"});
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, Integer> getMinorCodeMap(File minorProp) throws ExportException {
        block23: {
            block21: {
                block22: {
                    reader = null;
                    bufferedReader = null;
                    try {
                        reader = new InputStreamReader(new FileInputStream(minorProp));
                        bufferedReader = new BufferedReader(reader);
                        foundVersionCode = false;
                        map = new HashMap<Integer, Integer>();
                        lineNumber = 0;
lbl9:
                        // 4 sources

                        while ((line = bufferedReader.readLine()) != null) {
                            ++lineNumber;
                            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                            colonPos = line.indexOf(58);
                            if (colonPos == -1) {
                                throw new ExportException("Failed to read existing build log. Line %d is not a property line.", new Object[]{lineNumber});
                            }
                            name = line.substring(0, colonPos);
                            value = line.substring(colonPos + 1);
                            if (!"versionCode".equals(name)) break block21;
                            try {
                                versionCode = Integer.parseInt(value);
                                if (versionCode < this.mVersionCode) {
                                    var12_17 = null;
                                    break block22;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (NumberFormatException e) {
                                throw new ExportException("Failed to read integer property %1$s at line %2$d.", new Object[]{"versionCode", lineNumber});
                            }
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        try {
                            throw new ExportException(e, "Failed to read existing minor log: %s", new Object[]{"minor.codes"});
                        }
                        catch (Throwable var14_19) {
                            try {
                                if (reader == null) throw var14_19;
                                reader.close();
                                throw var14_19;
                            }
                            catch (IOException e) {
                                throw new ExportException(e, "Failed to read existing minor log: %s", new Object[]{"minor.codes"});
                            }
                        }
                    }
                }
                try {
                    if (reader == null) return var12_17;
                    reader.close();
                    return var12_17;
                }
                catch (IOException e) {
                    throw new ExportException(e, "Failed to read existing minor log: %s", new Object[]{"minor.codes"});
                }
lbl-1000:
                // 1 sources

                {
                    if (versionCode > this.mVersionCode) {
                        throw new ExportException("Incompatible versionCode: Exporting at versionCode %1$d but %2$s file indicate previous export with versionCode %3$d.", new Object[]{this.mVersionCode, "minor.codes", versionCode});
                    }
                    foundVersionCode = true;
                    ** GOTO lbl9
                }
            }
            try {
                map.put(Integer.valueOf(name), Integer.valueOf(value));
                ** GOTO lbl9
            }
            catch (NumberFormatException e) {
                throw new ExportException("Failed to read buildInfo property '%1$s' at line %2$d.", new Object[]{line, lineNumber});
            }
        }
        if (!foundVersionCode) {
            throw new ExportException("%1$s property missing from file %2$s.", new Object[]{"versionCode", "minor.codes"});
        }
        var8_10 = map;
        try {
            if (reader == null) return var8_10;
            reader.close();
            return var8_10;
        }
        catch (IOException e) {
            throw new ExportException(e, "Failed to read existing minor log: %s", new Object[]{"minor.codes"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        RELEASE("release"),
        CLEAN("clean");

        private final String mName;

        private Target(String name) {
            this.mName = name;
        }

        public String getTarget() {
            return this.mName;
        }

        public static Target getTarget(String value) {
            for (Target t : Target.values()) {
                if (!t.mName.equals(value)) continue;
                return t;
            }
            return null;
        }
    }

    public static final class ExportException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExportException(String message) {
            super(message);
        }

        public ExportException(String format, Object ... args) {
            super(String.format(format, args));
        }

        public ExportException(Throwable cause, String format, Object ... args) {
            super(String.format(format, args), cause);
        }

        public ExportException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

