/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.export;

import com.android.sdklib.internal.export.ApkData;
import com.android.sdklib.internal.export.LogHelper;
import com.android.sdklib.internal.export.MultiApkExportHelper;
import com.android.sdklib.internal.project.ApkSettings;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.resources.Density;
import com.android.sdklib.xml.ManifestData;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectConfig {
    private static final String PROP_API = "api";
    private static final String PROP_SCREENS = "screens";
    private static final String PROP_GL = "gl";
    private static final String PROP_ABI = "splitByAbi";
    private static final String PROP_DENSITY = "splitByDensity";
    private static final String PROP_LOCALEFILTERS = "localeFilters";
    private static final String[][] DENSITY_LIST = new String[][]{{Density.HIGH.getResourceValue(), Density.HIGH.getResourceValue() + "," + Density.NODPI.getResourceValue()}, {Density.MEDIUM.getResourceValue(), Density.MEDIUM.getResourceValue() + "," + Density.NODPI.getResourceValue()}, {Density.MEDIUM.getResourceValue(), Density.MEDIUM.getResourceValue() + "," + Density.NODPI.getResourceValue()}};
    private final File mProjectFolder;
    private final String mRelativePath;
    private final int mMinSdkVersion;
    private final int mGlEsVersion;
    private final ManifestData.SupportsScreens mSupportsScreens;
    private final boolean mSplitByAbi;
    private final boolean mSplitByDensity;
    private final Map<String, String> mLocaleFilters;
    private final List<String> mAbis;

    static ProjectConfig create(File projectFolder, String relativePath, ManifestData manifestData) throws MultiApkExportHelper.ExportException {
        ProjectProperties projectProp = ProjectProperties.load(projectFolder.getAbsolutePath(), ProjectProperties.PropertyType.DEFAULT);
        if (projectProp == null) {
            throw new MultiApkExportHelper.ExportException(String.format("%1$s is missing for project %2$s", ProjectProperties.PropertyType.DEFAULT.getFilename(), relativePath));
        }
        ApkSettings apkSettings = new ApkSettings(projectProp);
        return new ProjectConfig(projectFolder, relativePath, manifestData.getMinSdkVersion(), manifestData.getGlEsVersion(), manifestData.getSupportsScreensValues(), apkSettings.isSplitByAbi(), apkSettings.isSplitByDensity(), apkSettings.getLocaleFilters());
    }

    private ProjectConfig(File projectFolder, String relativePath, int minSdkVersion, int glEsVersion, ManifestData.SupportsScreens supportsScreens, boolean splitByAbi, boolean splitByDensity, Map<String, String> localeFilters) {
        this.mProjectFolder = projectFolder;
        this.mRelativePath = relativePath;
        this.mMinSdkVersion = minSdkVersion;
        this.mGlEsVersion = glEsVersion;
        this.mSupportsScreens = supportsScreens;
        this.mSplitByAbi = splitByAbi;
        this.mSplitByDensity = splitByDensity;
        this.mLocaleFilters = localeFilters;
        this.mAbis = this.mSplitByAbi ? this.findAbis() : null;
    }

    public File getProjectFolder() {
        return this.mProjectFolder;
    }

    public String getRelativePath() {
        return this.mRelativePath;
    }

    List<ApkData> getApkDataList() {
        ArrayList<ApkData> list = new ArrayList<ApkData>();
        Map<String, String> softVariants = this.computeSoftVariantMap();
        if (this.mSplitByAbi) {
            if (this.mAbis.size() > 0) {
                for (String abi : this.mAbis) {
                    list.add(new ApkData(this, abi, softVariants));
                }
            } else {
                list.add(new ApkData(this, softVariants));
            }
        } else {
            list.add(new ApkData(this, softVariants));
        }
        return list;
    }

    int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    ManifestData.SupportsScreens getSupportsScreens() {
        return this.mSupportsScreens;
    }

    int getGlEsVersion() {
        return this.mGlEsVersion;
    }

    boolean isSplitByDensity() {
        return this.mSplitByDensity;
    }

    boolean isSplitByAbi() {
        return this.mSplitByAbi;
    }

    private Map<String, String> computeSoftVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.mSplitByDensity && this.mLocaleFilters.size() > 0) {
            for (String[] density : DENSITY_LIST) {
                for (Map.Entry<String, String> entry : this.mLocaleFilters.entrySet()) {
                    map.put(density[0] + "-" + entry.getKey(), density[1] + "," + entry.getValue());
                }
            }
        } else if (this.mSplitByDensity) {
            for (String[] density : DENSITY_LIST) {
                map.put(density[0], density[1]);
            }
        } else if (this.mLocaleFilters.size() > 0) {
            map.putAll(this.mLocaleFilters);
        }
        return map;
    }

    private List<String> findAbis() {
        ArrayList<String> abiList = new ArrayList<String>();
        File libs = new File(this.mProjectFolder, "libs");
        if (libs.isDirectory()) {
            File[] abis;
            for (File abi : abis = libs.listFiles()) {
                String[] content;
                if (!abi.isDirectory() || (content = abi.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".so");
                    }
                })).length <= 0) continue;
                abiList.add(abi.getName());
            }
        }
        return abiList;
    }

    String getConfigString(boolean onlyManifestData) {
        StringBuilder sb = new StringBuilder();
        LogHelper.write(sb, PROP_API, this.mMinSdkVersion);
        LogHelper.write(sb, PROP_SCREENS, this.mSupportsScreens.getEncodedValues());
        if (this.mGlEsVersion != -1) {
            LogHelper.write(sb, PROP_GL, "0x" + Integer.toHexString(this.mGlEsVersion));
        }
        if (!onlyManifestData) {
            if (this.mSplitByAbi) {
                StringBuilder value = new StringBuilder(Boolean.toString(true));
                for (String abi : this.mAbis) {
                    value.append('|').append(abi);
                }
                LogHelper.write(sb, PROP_ABI, value);
            } else {
                LogHelper.write(sb, PROP_ABI, false);
            }
            LogHelper.write(sb, PROP_DENSITY, Boolean.toString(this.mSplitByDensity));
            if (this.mLocaleFilters.size() > 0) {
                LogHelper.write(sb, PROP_LOCALEFILTERS, ApkSettings.writeLocaleFilters(this.mLocaleFilters));
            }
        }
        return sb.toString();
    }

    String compareToProperties(Map<String, String> values) {
        String tmp;
        try {
            if (this.mMinSdkVersion != Integer.parseInt(values.get(PROP_API))) {
                return "Attribute minSdkVersion changed";
            }
        }
        catch (NumberFormatException e) {
            return "Failed to convert attribute minSdkVersion to an Integer";
        }
        try {
            tmp = values.get(PROP_GL);
            if (tmp != null && this.mGlEsVersion != Integer.decode(tmp)) {
                return "Attribute glEsVersion changed";
            }
        }
        catch (NumberFormatException e) {
            return "Failed to convert attribute glEsVersion to an Integer";
        }
        tmp = values.get(PROP_DENSITY);
        if (tmp == null || this.mSplitByDensity != Boolean.valueOf(tmp)) {
            return "Property split.density changed or is missing from config file";
        }
        tmp = values.get(PROP_ABI);
        if (tmp == null) {
            return "Property split.abi is missing from config file";
        }
        String[] abis = tmp.split("\\|");
        if (this.mSplitByAbi != Boolean.valueOf(abis[0])) {
            return "Property split.abi changed";
        }
        if (this.mSplitByAbi) {
            if (abis.length - 1 != this.mAbis.size()) {
                return "The number of ABIs available in the project changed";
            }
            for (int i = 1; i < abis.length; ++i) {
                if (this.mAbis.indexOf(abis[i]) != -1) continue;
                return "The list of ABIs available in the project changed";
            }
        }
        if ((tmp = values.get(PROP_SCREENS)) != null) {
            ManifestData.SupportsScreens supportsScreens = new ManifestData.SupportsScreens(tmp);
            if (!supportsScreens.equals(this.mSupportsScreens)) {
                return "Supports-Screens value changed";
            }
        } else {
            return "Supports-screens value missing from config file";
        }
        tmp = values.get(PROP_LOCALEFILTERS);
        if (tmp != null && !((Object)this.mLocaleFilters).equals(ApkSettings.readLocaleFilters(tmp))) {
            return "Locale resource filter changed";
        }
        return null;
    }
}

