/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.sdklib.ISdkLog;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdklib.io.FolderWrapper;
import com.android.sdklib.io.IAbstractFile;
import com.android.sdklib.io.IAbstractFolder;
import com.android.sdklib.io.StreamException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProperties {
    protected static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_LIBRARY = "android.library";
    public static final String PROPERTY_LIB_REF = "android.library.reference.";
    private static final String PROPERTY_LIB_REF_REGEX = "android.library.reference.\\d+";
    public static final String PROPERTY_PROGUARD_CONFIG = "proguard.config";
    public static final String PROPERTY_SDK = "sdk.dir";
    private static final String PROPERTY_SDK_LEGACY = "sdk-location";
    public static final String PROPERTY_SPLIT_BY_DENSITY = "split.density";
    public static final String PROPERTY_SPLIT_BY_ABI = "split.abi";
    public static final String PROPERTY_SPLIT_BY_LOCALE = "split.locale";
    public static final String PROPERTY_TESTED_PROJECT = "tested.project.dir";
    public static final String PROPERTY_BUILD_SOURCE_DIR = "source.dir";
    public static final String PROPERTY_BUILD_OUT_DIR = "out.dir";
    public static final String PROPERTY_PACKAGE = "package";
    public static final String PROPERTY_VERSIONCODE = "versionCode";
    public static final String PROPERTY_PROJECTS = "projects";
    public static final String PROPERTY_KEY_STORE = "key.store";
    public static final String PROPERTY_KEY_ALIAS = "key.alias";
    private static final String LOCAL_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked in Version Control Systems,\n# as it contains information specific to your local configuration.\n\n";
    private static final String DEFAULT_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must be checked in Version Control Systems.\n#\n# To customize properties used by the Ant build system use,\n# \"build.properties\", and override values to adapt the script to your\n# project structure.\n\n";
    private static final String BUILD_HEADER = "# This file is used to override default values used by the Ant build system.\n#\n# This file must be checked in Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source.dir' for the location of your java source folder and\n#  'out.dir' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n";
    private static final String EXPORT_HEADER = "# Export properties\n#\n# This file must be checked in Version Control Systems.\n\n# The main content for this file is:\n# - package name for the application being export\n# - list of the projects being export\n# - version code for the application\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key alias to use.\n# The password will be asked during the build when you use the 'release' target.\n\n";
    protected final IAbstractFolder mProjectFolder;
    protected final Map<String, String> mProperties;
    protected final PropertyType mType;

    public static ProjectProperties load(String projectFolderOsPath, PropertyType type) {
        FolderWrapper wrapper = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.load(wrapper, type);
    }

    public static ProjectProperties load(IAbstractFolder projectFolder, PropertyType type) {
        Map<String, String> map;
        IAbstractFile propFile;
        if (projectFolder.exists() && (propFile = projectFolder.getFile(type.mFilename)).exists() && (map = ProjectProperties.parsePropertyFile(propFile, null)) != null) {
            return new ProjectProperties(projectFolder, map, type);
        }
        return null;
    }

    public static ProjectPropertiesWorkingCopy create(String projectFolderOsPath, PropertyType type) {
        FolderWrapper folder = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.create(folder, type);
    }

    public static ProjectPropertiesWorkingCopy create(IAbstractFolder projectFolder, PropertyType type) {
        return new ProjectPropertiesWorkingCopy(projectFolder, new HashMap<String, String>(), type);
    }

    public ProjectPropertiesWorkingCopy makeWorkingCopy() {
        HashMap<String, String> propList = new HashMap<String, String>();
        propList.putAll(this.mProperties);
        return new ProjectPropertiesWorkingCopy(this.mProjectFolder, propList, this.mType);
    }

    public PropertyType getType() {
        return this.mType;
    }

    public synchronized String getProperty(String name) {
        return this.mProperties.get(name);
    }

    public synchronized Set<String> keySet() {
        return new HashSet<String>(this.mProperties.keySet());
    }

    public synchronized void reload() {
        Map<String, String> map;
        IAbstractFile propFile;
        if (this.mProjectFolder.exists() && (propFile = this.mProjectFolder.getFile(this.mType.mFilename)).exists() && (map = ProjectProperties.parsePropertyFile(propFile, null)) != null) {
            this.mProperties.clear();
            this.mProperties.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parsePropertyFile(IAbstractFile propFile, ISdkLog log) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(propFile.getContents(), "UTF-8"));
            String line = null;
            HashMap<String, String> map = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                Matcher m = PATTERN_PROP.matcher(line);
                if (!m.matches()) {
                    log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", propFile.getOsLocation(), line);
                    Map<String, String> map2 = null;
                    return map2;
                }
                map.put(m.group(1), m.group(2));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            log.warning("Error parsing '%1$s': %2$s.", propFile.getOsLocation(), e.getMessage());
        }
        catch (StreamException e) {
            log.warning("Error parsing '%1$s': %2$s.", propFile.getOsLocation(), e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    protected ProjectProperties(IAbstractFolder projectFolder, Map<String, String> map, PropertyType type) {
        this.mProjectFolder = projectFolder;
        this.mProperties = map;
        this.mType = type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyType {
        BUILD("build.properties", "# This file is used to override default values used by the Ant build system.\n#\n# This file must be checked in Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source.dir' for the location of your java source folder and\n#  'out.dir' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n", new String[]{"source.dir", "out.dir"}, null),
        DEFAULT("default.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must be checked in Version Control Systems.\n#\n# To customize properties used by the Ant build system use,\n# \"build.properties\", and override values to adapt the script to your\n# project structure.\n\n", new String[]{"target", "android.library", "android.library.reference.\\d+", "key.store", "key.alias", "proguard.config"}, null),
        LOCAL("local.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked in Version Control Systems,\n# as it contains information specific to your local configuration.\n\n", new String[]{"sdk.dir"}, new String[]{"sdk-location"}),
        EXPORT("export.properties", "# Export properties\n#\n# This file must be checked in Version Control Systems.\n\n# The main content for this file is:\n# - package name for the application being export\n# - list of the projects being export\n# - version code for the application\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key alias to use.\n# The password will be asked during the build when you use the 'release' target.\n\n", new String[]{"package", "versionCode", "projects", "key.store", "key.alias"}, null);

        private final String mFilename;
        private final String mHeader;
        private final Set<String> mKnownProps;
        private final Set<String> mRemovedProps;

        private PropertyType(String filename, String header, String[] validProps, String[] removedProps) {
            this.mFilename = filename;
            this.mHeader = header;
            HashSet<String> s = new HashSet<String>();
            if (validProps != null) {
                s.addAll(Arrays.asList(validProps));
            }
            this.mKnownProps = Collections.unmodifiableSet(s);
            s = new HashSet();
            if (removedProps != null) {
                s.addAll(Arrays.asList(removedProps));
            }
            this.mRemovedProps = Collections.unmodifiableSet(s);
        }

        public String getFilename() {
            return this.mFilename;
        }

        public String getHeader() {
            return this.mHeader;
        }

        public boolean isKnownProperty(String name) {
            for (String propRegex : this.mKnownProps) {
                if (!propRegex.equals(name) && !Pattern.matches(propRegex, name)) continue;
                return true;
            }
            return false;
        }

        public boolean isRemovedProperty(String name) {
            for (String propRegex : this.mRemovedProps) {
                if (!propRegex.equals(name) && !Pattern.matches(propRegex, name)) continue;
                return true;
            }
            return false;
        }
    }
}

