/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.repository.SdkAddonsListConstants;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AddonsListFetcher {
    public Site[] fetch(ITaskMonitor monitor, String url) {
        url = url == null ? "" : url.trim();
        monitor.setProgressMax(4);
        monitor.setDescription("Fetching %1$s", url);
        monitor.incProgress(1);
        Exception[] exception = new Exception[]{null};
        Boolean[] validatorFound = new Boolean[]{Boolean.FALSE};
        String[] validationError = new String[]{null};
        Document validatedDoc = null;
        String validatedUri = null;
        ByteArrayInputStream xml = this.fetchUrl(url, exception);
        if (xml != null) {
            monitor.setDescription("Validate XML", new Object[0]);
            int version = this.getXmlSchemaVersion(xml);
            if (version >= 1 && version <= 1) {
                String uri = this.validateXml(xml, url, version, validationError, validatorFound);
                if (uri != null) {
                    validatedDoc = this.getDocument(xml, monitor);
                    validatedUri = uri;
                }
            } else if (version > 1) {
                return null;
            }
        }
        if (exception[0] != null) {
            String reason = null;
            reason = exception[0] instanceof FileNotFoundException ? "File not found" : (exception[0] instanceof SSLKeyException ? "HTTPS SSL error. You might want to force download through HTTP in the settings." : (exception[0].getMessage() != null ? exception[0].getMessage() : String.format("Unknown (%1$s)", exception[0].getClass().getName())));
            monitor.setResult("Failed to fetch URL %1$s, reason: %2$s", url, reason);
        }
        if (validationError[0] != null) {
            monitor.setResult("%s", validationError[0]);
        }
        if (validatedDoc == null) {
            return null;
        }
        monitor.incProgress(1);
        Site[] result = null;
        if (xml != null) {
            monitor.setDescription("Parse XML", new Object[0]);
            monitor.incProgress(1);
            result = this.parseAddonsList(validatedDoc, validatedUri, monitor);
        }
        monitor.incProgress(1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream fetchUrl(String urlString, Exception[] outException) {
        ByteArrayInputStream byteArrayInputStream;
        block12: {
            URL url = new URL(urlString);
            InputStream is = null;
            int inc = 65536;
            int curr = 0;
            byte[] result = new byte[inc];
            try {
                int n;
                is = url.openStream();
                while ((n = is.read(result, curr, result.length - curr)) != -1) {
                    if ((curr += n) != result.length) continue;
                    byte[] temp = new byte[curr + inc];
                    System.arraycopy(result, 0, temp, 0, curr);
                    result = temp;
                }
                byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (outException != null) {
                        outException[0] = e;
                    }
                    return null;
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byteArrayInputStream;
    }

    protected int getXmlSchemaVersion(InputStream xml) {
        if (xml == null) {
            return 0;
        }
        Node doc = null;
        try {
            xml.reset();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(xml);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc == null) {
            return 0;
        }
        Pattern nsPattern = Pattern.compile("http://schemas.android.com/sdk/android/addons-list/([1-9][0-9]*)");
        String prefix = null;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            Matcher m;
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!"sdk-addons-list".equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !(m = nsPattern.matcher(uri)).matches()) continue;
            String version = m.group(1);
            try {
                return Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    protected String validateXml(InputStream xml, String url, int version, String[] outError, Boolean[] validatorFound) {
        if (xml == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(version);
            if (validator == null) {
                validatorFound[0] = Boolean.FALSE;
                outError[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", url);
                return null;
            }
            validatorFound[0] = Boolean.TRUE;
            xml.reset();
            validator.validate(new StreamSource(xml));
            return SdkAddonsListConstants.getSchemaUri(version);
        }
        catch (SAXParseException e) {
            outError[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", url, e.getLineNumber(), e.getColumnNumber(), e.toString());
        }
        catch (Exception e) {
            outError[0] = String.format("XML verification failed for %1$s.\nError: %2$s", url, e.toString());
        }
        return null;
    }

    private Validator getValidator(int version) throws SAXException {
        InputStream xsdStream = SdkAddonsListConstants.getXsdStream(version);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (factory == null) {
            return null;
        }
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        Validator validator = schema == null ? null : schema.newValidator();
        return validator;
    }

    protected Document getDocument(InputStream xml, ITaskMonitor monitor) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            xml.reset();
            Document doc = builder.parse(new InputSource(xml));
            return doc;
        }
        catch (ParserConfigurationException e) {
            monitor.setResult("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException e) {
            monitor.setResult("Failed to parse XML document", new Object[0]);
        }
        catch (IOException e) {
            monitor.setResult("Failed to read XML document", new Object[0]);
        }
        return null;
    }

    protected Site[] parseAddonsList(Document doc, String nsUri, ITaskMonitor monitor) {
        Node root = this.getFirstChild(doc, nsUri, "sdk-addons-list");
        if (root != null) {
            ArrayList<Site> sites = new ArrayList<Site>();
            for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !child.getLocalName().equals("addon-site")) continue;
                Node url = this.getFirstChild(child, nsUri, "url");
                Node name = this.getFirstChild(child, nsUri, "name");
                if (name == null || url == null) continue;
                String strUrl = url.getTextContent().trim();
                String strName = name.getTextContent().trim();
                if (strUrl.length() <= 0 || strName.length() <= 0) continue;
                sites.add(new Site(strUrl, strName));
            }
            return sites.toArray(new Site[sites.size()]);
        }
        return null;
    }

    private Node getFirstChild(Node node, String nsUri, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    public static class Site {
        private final String mUrl;
        private final String mUiName;

        private Site(String url, String uiName) {
            this.mUrl = url.trim();
            this.mUiName = uiName;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String getUiName() {
            return this.mUiName;
        }
    }
}

