/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.MinToolsPackage;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraPackage
extends MinToolsPackage
implements IMinApiLevelDependency {
    private static final String PROP_PATH = "Extra.Path";
    private static final String PROP_VENDOR = "Extra.Vendor";
    private static final String PROP_MIN_API_LEVEL = "Extra.MinApiLevel";
    private final String mVendor;
    private final String mPath;
    private final int mMinApiLevel;

    ExtraPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mPath = XmlParserUtils.getXmlString(packageNode, "path");
        this.mVendor = XmlParserUtils.getXmlString(packageNode, "vendor");
        this.mMinApiLevel = XmlParserUtils.getXmlInt(packageNode, "min-api-level", 0);
    }

    ExtraPackage(SdkSource source, Properties props, String vendor, String path, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        this.mVendor = vendor != null ? vendor : this.getProperty(props, PROP_VENDOR, "");
        this.mPath = path != null ? path : this.getProperty(props, PROP_PATH, path);
        this.mMinApiLevel = Integer.parseInt(this.getProperty(props, PROP_MIN_API_LEVEL, Integer.toString(0)));
    }

    @Override
    void saveProperties(Properties props) {
        super.saveProperties(props);
        props.setProperty(PROP_PATH, this.mPath);
        if (this.mVendor != null) {
            props.setProperty(PROP_PATH, this.mVendor);
        }
        if (this.getMinApiLevel() != 0) {
            props.setProperty(PROP_MIN_API_LEVEL, Integer.toString(this.getMinApiLevel()));
        }
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    public boolean isPathValid() {
        if ("add-ons".equals(this.mPath) || "platforms".equals(this.mPath) || "platform-tools".equals(this.mPath) || "tools".equals(this.mPath) || "docs".equals(this.mPath) || "temp".equals(this.mPath)) {
            return false;
        }
        return this.mPath != null && this.mPath.indexOf(47) == -1 && this.mPath.indexOf(92) == -1;
    }

    public String getPath() {
        String path = this.mPath;
        if (this.mVendor != null && this.mVendor.length() > 0) {
            path = this.mVendor + "-" + this.mPath;
        }
        int h = path.hashCode();
        if ((path = path.replaceAll("[^a-zA-Z0-9-]+", "_")).length() == 0) {
            path = String.format("unknown_extra%08x", h);
        }
        return path;
    }

    @Override
    public String getShortDescription() {
        String name = this.getPath();
        if (name != null) {
            name = name.replaceAll("[ _\t\f-]+", " ");
            boolean changed = false;
            char[] chars = name.toCharArray();
            int n = chars.length - 1;
            for (int i = 0; i < n; ++i) {
                if (!Character.isLowerCase(chars[i]) || i != 0 && chars[i - 1] != ' ') continue;
                chars[i] = Character.toUpperCase(chars[i]);
                changed = true;
            }
            if (changed) {
                name = new String(chars);
            }
        }
        String s = String.format("%1$s package, revision %2$d%3$s", name, this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = String.format("Extra %1$s package", this.getPath());
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        if (this.getMinToolsRevision() != 0) {
            s = s + String.format("\nRequires tools revision %1$d", this.getMinToolsRevision());
        }
        if (this.getMinApiLevel() != 0) {
            s = s + String.format("\nRequires SDK Platform Android API %1$s", this.getMinApiLevel());
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, String suggestedDir, SdkManager sdkManager) {
        return new File(osSdkRoot, this.getPath());
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        return pkg instanceof ExtraPackage && ((ExtraPackage)pkg).mPath.equals(this.mPath);
    }
}

