/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.PlatformToolPackage;
import com.android.sdklib.internal.repository.SamplePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSdkParser {
    private Package[] mPackages;

    public Package[] getPackages() {
        return this.mPackages;
    }

    public void clearPackages() {
        this.mPackages = null;
    }

    public Package[] parseSdk(String osSdkRoot, SdkManager sdkManager, ISdkLog log) {
        ArrayList<Package> packages = new ArrayList<Package>();
        HashSet<File> visited = new HashSet<File>();
        File dir = new File(osSdkRoot, "docs");
        Package pkg = this.scanDoc(dir, log);
        if (pkg != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        if ((pkg = this.scanTools(dir = new File(osSdkRoot, "tools"), log)) != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        if ((pkg = this.scanPlatformTools(dir = new File(osSdkRoot, "platform-tools"), log)) != null) {
            packages.add(pkg);
            visited.add(dir);
        }
        File samplesRoot = new File(osSdkRoot, "samples");
        for (IAndroidTarget target : sdkManager.getTargets()) {
            Properties props = this.parseProperties(new File(target.getLocation(), "source.properties"));
            try {
                if (target.isPlatform()) {
                    File samplesDir;
                    pkg = new PlatformPackage(target, props);
                    if (samplesRoot.isDirectory() && (samplesDir = new File(target.getPath(4))).exists() && samplesDir.getParentFile().equals(samplesRoot)) {
                        Properties samplesProps = this.parseProperties(new File(samplesDir, "source.properties"));
                        if (samplesProps != null) {
                            SamplePackage pkg2 = new SamplePackage(target, samplesProps);
                            packages.add(pkg2);
                        }
                        visited.add(samplesDir);
                    }
                } else {
                    pkg = new AddonPackage(target, props);
                }
            }
            catch (Exception e) {
                log.error(e, null, new Object[0]);
            }
            if (pkg == null) continue;
            packages.add(pkg);
            visited.add(new File(target.getLocation()));
        }
        this.scanMissingSamples(osSdkRoot, visited, packages, log);
        this.scanExtras(osSdkRoot, visited, packages, log);
        Collections.sort(packages);
        this.mPackages = packages.toArray(new Package[packages.size()]);
        return this.mPackages;
    }

    private void scanExtras(String osSdkRoot, HashSet<File> visited, ArrayList<Package> packages, ISdkLog log) {
        File root = new File(osSdkRoot);
        if (!root.isDirectory()) {
            return;
        }
        for (File dir : root.listFiles()) {
            Properties props;
            if (!dir.isDirectory() || visited.contains(dir) || (props = this.parseProperties(new File(dir, "source.properties"))) == null) continue;
            try {
                ExtraPackage pkg = new ExtraPackage(null, props, null, dir.getName(), 0, null, "Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), dir.getPath());
                if (!pkg.isPathValid()) continue;
                packages.add(pkg);
                visited.add(dir);
            }
            catch (Exception e) {
                log.error(e, null, new Object[0]);
            }
        }
    }

    private void scanMissingSamples(String osSdkRoot, HashSet<File> visited, ArrayList<Package> packages, ISdkLog log) {
        File root = new File(osSdkRoot);
        if (!(root = new File(root, "samples")).isDirectory()) {
            return;
        }
        for (File dir : root.listFiles()) {
            Properties props;
            if (!dir.isDirectory() || visited.contains(dir) || (props = this.parseProperties(new File(dir, "source.properties"))) == null) continue;
            try {
                SamplePackage pkg = new SamplePackage(dir.getAbsolutePath(), props);
                packages.add(pkg);
                visited.add(dir);
            }
            catch (Exception e) {
                log.error(e, null, new Object[0]);
            }
        }
    }

    private Package scanTools(File toolFolder, ISdkLog log) {
        Properties props = this.parseProperties(new File(toolFolder, "source.properties"));
        HashSet<String> names = new HashSet<String>();
        File[] files = toolFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                names.add(file.getName());
            }
        }
        if (!names.contains(SdkConstants.androidCmdName()) || !names.contains(SdkConstants.FN_EMULATOR)) {
            return null;
        }
        try {
            ToolPackage pkg = new ToolPackage(null, props, 0, null, "Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), toolFolder.getPath());
            return pkg;
        }
        catch (Exception e) {
            log.error(e, null, new Object[0]);
            return null;
        }
    }

    private Package scanPlatformTools(File platformToolsFolder, ISdkLog log) {
        Properties props = this.parseProperties(new File(platformToolsFolder, "source.properties"));
        if (platformToolsFolder.listFiles() == null) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        for (File file : platformToolsFolder.listFiles()) {
            names.add(file.getName());
        }
        if (!(names.contains(SdkConstants.FN_ADB) && names.contains(SdkConstants.FN_AAPT) && names.contains(SdkConstants.FN_AIDL) && names.contains(SdkConstants.FN_DX))) {
            return null;
        }
        try {
            PlatformToolPackage pkg = new PlatformToolPackage(null, props, 0, null, "Platform Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), platformToolsFolder.getPath());
            return pkg;
        }
        catch (Exception e) {
            log.error(e, null, new Object[0]);
            return null;
        }
    }

    private Package scanDoc(File docFolder, ISdkLog log) {
        Properties props = this.parseProperties(new File(docFolder, "source.properties"));
        if (new File(docFolder, "index.html").isFile()) {
            try {
                DocPackage pkg = new DocPackage(null, props, 0, null, 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), docFolder.getPath());
                return pkg;
            }
            catch (Exception e) {
                log.error(e, null, new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties(File propsFile) {
        FileInputStream fis = null;
        try {
            if (propsFile.exists()) {
                fis = new FileInputStream(propsFile);
                Properties props = new Properties();
                props.load(fis);
                if (props.size() > 0) {
                    Properties properties = props;
                    return properties;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

