/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import com.android.sdklib.repository.SdkRepoConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SdkRepoSource
extends SdkSource {
    public SdkRepoSource(String url, String uiName) {
        super(url, uiName);
    }

    public boolean isAddonSource() {
        return false;
    }

    protected String getUrlDefaultXmlFile() {
        return "repository.xml";
    }

    protected int getNsLatestVersion() {
        return 3;
    }

    protected String getNsUri() {
        return SdkRepoConstants.NS_URI;
    }

    protected String getNsPattern() {
        return "http://schemas.android.com/sdk/android/repository/([1-9][0-9]*)";
    }

    protected String getSchemaUri(int version) {
        return SdkRepoConstants.getSchemaUri(version);
    }

    protected String getRootElementName() {
        return "sdk-repository";
    }

    protected InputStream getXsdStream(int version) {
        return SdkRepoConstants.getXsdStream(version);
    }

    protected Document findAlternateToolsXml(InputStream xml) throws IOException {
        if (xml == null) {
            return null;
        }
        xml.reset();
        Node oldDoc = null;
        Document newDoc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            oldDoc = builder.parse(xml);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            newDoc = builder.newDocument();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (oldDoc == null || newDoc == null) {
            return null;
        }
        Pattern nsPattern = Pattern.compile(this.getNsPattern());
        Node oldRoot = null;
        String prefix = null;
        for (Node child = oldDoc.getFirstChild(); child != null; child = child.getNextSibling()) {
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!"sdk-repository".equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !nsPattern.matcher(uri).matches()) continue;
            oldRoot = child;
            break;
        }
        if (oldRoot == null || prefix == null || prefix.length() == 0) {
            return null;
        }
        String ns = this.getNsUri();
        Element newRoot = newDoc.createElementNS(ns, this.getRootElementName());
        newRoot.setPrefix(prefix);
        newDoc.appendChild(newRoot);
        int numTool = 0;
        String[] elementNames = new String[]{"tool", "platform-tool", "license"};
        Element element = null;
        while ((element = this.findChild(oldRoot, element, prefix, elementNames)) != null) {
            boolean isElementValid;
            block26: {
                int pos;
                isElementValid = false;
                String name = element.getLocalName();
                if (name == null && (pos = (name = element.getNodeName()).indexOf(58)) > 0 && pos < name.length() - 1) {
                    name = name.substring(pos + 1);
                }
                if ("license".equals(name)) {
                    isElementValid = true;
                } else {
                    try {
                        Node revision = this.findChild((Node)element, null, prefix, "revision");
                        Node archives = this.findChild((Node)element, null, prefix, "archives");
                        if (revision == null || archives == null) continue;
                        try {
                            String content = revision.getTextContent();
                            content = content.trim();
                            int rev = Integer.parseInt(content);
                            if (rev < 1) {
                            }
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                        if ("tool".equals(name)) {
                            Node minPTRev = this.findChild((Node)element, null, prefix, "min-platform-tools-rev");
                            if (minPTRev == null) continue;
                            try {
                                String content = minPTRev.getTextContent();
                                content = content.trim();
                                int rev = Integer.parseInt(content);
                                if (rev < 1) {
                                }
                            }
                            catch (NumberFormatException ignore) {}
                            continue;
                        }
                        Node archive = null;
                        while ((archive = this.findChild(archives, archive, prefix, "archive")) != null) {
                            try {
                                String sha1;
                                NamedNodeMap attrs;
                                Node typeNode;
                                Node node;
                                String url;
                                Archive.Os os = (Archive.Os)((Object)XmlParserUtils.getEnumAttribute(archive, "os", (Object[])Archive.Os.values(), null));
                                Archive.Arch arch = (Archive.Arch)((Object)XmlParserUtils.getEnumAttribute(archive, "arch", (Object[])Archive.Arch.values(), (Object)Archive.Arch.ANY));
                                if (os == null || !os.isCompatible() || arch == null || !arch.isCompatible() || (url = (node = this.findChild(archive, null, prefix, "url")) == null ? null : node.getTextContent().trim()) == null || url.length() == 0) continue;
                                node = this.findChild(archive, null, prefix, "size");
                                long size = 0L;
                                try {
                                    size = Long.parseLong(node.getTextContent());
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (size < 1L || (node = this.findChild(archive, null, prefix, "checksum")) == null || (typeNode = (attrs = node.getAttributes()).getNamedItem("type")) == null || !"type".equals(typeNode.getNodeName()) || !"sha1".equals(typeNode.getNodeValue()) || (sha1 = node == null ? null : node.getTextContent().trim()) == null || sha1.length() != 40) continue;
                                isElementValid = true;
                            }
                            catch (Exception ignore1) {}
                        }
                    }
                    catch (Exception ignore2) {
                        if (System.getenv("TESTING") == null) break block26;
                        throw new RuntimeException(ignore2);
                    }
                }
            }
            if (!isElementValid) continue;
            this.duplicateNode(newRoot, element, SdkRepoConstants.NS_URI, prefix);
            ++numTool;
        }
        return numTool > 0 ? newDoc : null;
    }

    private Element findChild(Node rootNode, Node after, String prefix, String[] nodeNames) {
        Node child;
        for (int i = 0; i < nodeNames.length; ++i) {
            if (nodeNames[i].indexOf(58) >= 0) continue;
            nodeNames[i] = prefix + ":" + nodeNames[i];
        }
        Node node = child = after == null ? rootNode.getFirstChild() : after.getNextSibling();
        while (child != null) {
            if (child.getNodeType() == 1) {
                for (String nodeName : nodeNames) {
                    if (!nodeName.equals(child.getNodeName())) continue;
                    return (Element)child;
                }
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private Node findChild(Node rootNode, Node after, String prefix, String nodeName) {
        return this.findChild(rootNode, after, prefix, new String[]{nodeName});
    }

    private Element duplicateNode(Element newRootNode, Element oldNode, String namespaceUri, String prefix) {
        Document newDoc = newRootNode.getOwnerDocument();
        Element newNode = null;
        String nodeName = oldNode.getNodeName();
        int pos = nodeName.indexOf(58);
        if (pos > 0 && pos < nodeName.length() - 1) {
            nodeName = nodeName.substring(pos + 1);
            newNode = newDoc.createElementNS(namespaceUri, nodeName);
            newNode.setPrefix(prefix);
        } else {
            newNode = newDoc.createElement(nodeName);
        }
        newRootNode.appendChild(newNode);
        NamedNodeMap attrs = oldNode.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            Attr newAttr = null;
            String attrName = oldNode.getNodeName();
            pos = attrName.indexOf(58);
            if (pos > 0 && pos < attrName.length() - 1) {
                attrName = attrName.substring(pos + 1);
                newAttr = newDoc.createAttributeNS(namespaceUri, attrName);
                newAttr.setPrefix(prefix);
            } else {
                newAttr = newDoc.createAttribute(attrName);
            }
            newAttr.setNodeValue(attr.getNodeValue());
            if (pos > 0) {
                newNode.getAttributes().setNamedItemNS(newAttr);
                continue;
            }
            newNode.getAttributes().setNamedItem(newAttr);
        }
        for (Node child = oldNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                this.duplicateNode(newNode, (Element)child, namespaceUri, prefix);
                continue;
            }
            if (child.getNodeType() != 3) continue;
            Text newText = newDoc.createTextNode(child.getNodeValue());
            newNode.appendChild(newText);
        }
        return newNode;
    }
}

