/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.internal.repository.SdkAddonSource;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SdkSourceCategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SdkSources {
    private static final String KEY_COUNT = "count";
    private static final String KEY_SRC = "src";
    private static final String SRC_FILENAME = "repositories.cfg";
    private final EnumMap<SdkSourceCategory, ArrayList<SdkSource>> mSources = new EnumMap(SdkSourceCategory.class);

    public void add(SdkSourceCategory category, SdkSource source) {
        ArrayList<SdkSource> list = this.mSources.get(category);
        if (list == null) {
            list = new ArrayList();
            this.mSources.put(category, list);
        }
        list.add(source);
    }

    public void remove(SdkSource source) {
        Iterator<Map.Entry<SdkSourceCategory, ArrayList<SdkSource>>> it = this.mSources.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SdkSourceCategory, ArrayList<SdkSource>> entry = it.next();
            ArrayList<SdkSource> list = entry.getValue();
            if (!list.remove(source) || !list.isEmpty()) continue;
            it.remove();
        }
    }

    public void removeAll(SdkSourceCategory category) {
        this.mSources.remove(category);
    }

    public SdkSourceCategory[] getCategories() {
        ArrayList<SdkSourceCategory> cats = new ArrayList<SdkSourceCategory>();
        for (SdkSourceCategory cat : SdkSourceCategory.values()) {
            if (cat.getAlwaysDisplay()) {
                cats.add(cat);
                continue;
            }
            ArrayList<SdkSource> list = this.mSources.get(cat);
            if (list == null || list.isEmpty()) continue;
            cats.add(cat);
        }
        return cats.toArray(new SdkSourceCategory[cats.size()]);
    }

    public SdkSource[] getSources(SdkSourceCategory category) {
        ArrayList<SdkSource> list = this.mSources.get(category);
        if (list == null) {
            return new SdkSource[0];
        }
        return list.toArray(new SdkSource[list.size()]);
    }

    public SdkSource[] getAllSources() {
        int n = 0;
        for (ArrayList<SdkSource> list : this.mSources.values()) {
            n += list.size();
        }
        SdkSource[] sources = new SdkSource[n];
        int i = 0;
        for (ArrayList<SdkSource> list : this.mSources.values()) {
            for (SdkSource source : list) {
                sources[i++] = source;
            }
        }
        return sources;
    }

    public SdkSourceCategory getCategory(SdkSource source) {
        if (source != null) {
            for (Map.Entry<SdkSourceCategory, ArrayList<SdkSource>> entry : this.mSources.entrySet()) {
                if (!entry.getValue().contains(source)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public boolean hasSourceUrl(SdkSource source) {
        for (ArrayList<SdkSource> list : this.mSources.values()) {
            for (SdkSource s : list) {
                if (!s.equals(source)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSourceUrl(SdkSourceCategory category, SdkSource source) {
        ArrayList<SdkSource> list = this.mSources.get(category);
        if (list != null) {
            for (SdkSource s : list) {
                if (!s.equals(source)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserAddons(ISdkLog log) {
        this.removeAll(SdkSourceCategory.USER_ADDONS);
        FileInputStream fis = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SRC_FILENAME);
            if (f.exists()) {
                fis = new FileInputStream(f);
                Properties props = new Properties();
                props.load(fis);
                int count = Integer.parseInt(props.getProperty(KEY_COUNT, "0"));
                for (int i = 0; i < count; ++i) {
                    SdkAddonSource s;
                    String url = props.getProperty(String.format("%s%02d", KEY_SRC, i));
                    if (url == null || this.hasSourceUrl(s = new SdkAddonSource(url, null))) continue;
                    this.add(SdkSourceCategory.USER_ADDONS, s);
                }
            }
        }
        catch (NumberFormatException e) {
            log.error(e, null, new Object[0]);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error(e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error(e, null, new Object[0]);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserAddons(ISdkLog log) {
        FileOutputStream fos = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SRC_FILENAME);
            fos = new FileOutputStream(f);
            Properties props = new Properties();
            int count = 0;
            for (SdkSource s : this.getSources(SdkSourceCategory.USER_ADDONS)) {
                props.setProperty(String.format("%s%02d", KEY_SRC, ++count), s.getUrl());
            }
            props.setProperty(KEY_COUNT, Integer.toString(count));
            props.store(fos, "## User Sources for Android tool");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error(e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error(e, null, new Object[0]);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

