/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.io;

import com.android.sdklib.io.FolderWrapper;
import com.android.sdklib.io.IAbstractFile;
import com.android.sdklib.io.IAbstractFolder;
import com.android.sdklib.io.StreamException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public class FileWrapper
extends File
implements IAbstractFile {
    private static final long serialVersionUID = 1L;

    public FileWrapper(File file) {
        super(file.getAbsolutePath());
    }

    public FileWrapper(File parent, String child) {
        super(parent, child);
    }

    public FileWrapper(String osPathname) {
        super(osPathname);
    }

    public FileWrapper(String parent, String child) {
        super(parent, child);
    }

    public FileWrapper(URI uri) {
        super(uri);
    }

    public InputStream getContents() throws StreamException {
        try {
            return new FileInputStream(this);
        }
        catch (FileNotFoundException e) {
            throw new StreamException(e);
        }
    }

    public void setContents(InputStream source) throws StreamException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = source.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new StreamException(e);
                }
            }
        }
    }

    public OutputStream getOutputStream() throws StreamException {
        try {
            return new FileOutputStream(this);
        }
        catch (FileNotFoundException e) {
            throw new StreamException(e);
        }
    }

    public IAbstractFile.PreferredWriteMode getPreferredWriteMode() {
        return IAbstractFile.PreferredWriteMode.OUTPUTSTREAM;
    }

    public String getOsLocation() {
        return this.getAbsolutePath();
    }

    public boolean exists() {
        return this.isFile();
    }

    public IAbstractFolder getParentFolder() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return new FolderWrapper(p);
    }
}

