/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.OS;

public class Path
extends Resource {
    public int handle;
    PointF currentPoint = new PointF();
    PointF startPoint = new PointF();

    public Path(Device device) {
        super(device);
        this.device.checkGDIP();
        this.handle = Gdip.GraphicsPath_new(0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, Path path, float f) {
        super(device);
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        f = Math.max(0.0f, f);
        this.handle = Gdip.GraphicsPath_Clone(path.handle);
        if (f != 0.0f) {
            Gdip.GraphicsPath_Flatten(this.handle, 0, f);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, PathData pathData) {
        this(device);
        if (pathData == null) {
            SWT.error(4);
        }
        this.init(pathData);
    }

    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (f3 < 0.0f) {
            f += f3;
            f3 = -f3;
        }
        if (f4 < 0.0f) {
            f2 += f4;
            f4 = -f4;
        }
        if (f3 == 0.0f || f4 == 0.0f || f6 == 0.0f) {
            return;
        }
        if (f3 == f4) {
            Gdip.GraphicsPath_AddArc(this.handle, f, f2, f3, f4, -f5, -f6);
        } else {
            int n;
            int n2 = Gdip.GraphicsPath_new(0);
            if (n2 == 0) {
                SWT.error(2);
            }
            if ((n = Gdip.Matrix_new(f3, 0.0f, 0.0f, f4, f, f2)) == 0) {
                SWT.error(2);
            }
            Gdip.GraphicsPath_AddArc(n2, 0.0f, 0.0f, 1.0f, 1.0f, -f5, -f6);
            Gdip.GraphicsPath_Transform(n2, n);
            Gdip.GraphicsPath_AddPath(this.handle, n2, true);
            Gdip.Matrix_delete(n);
            Gdip.GraphicsPath_delete(n2);
        }
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        Gdip.GraphicsPath_AddPath(this.handle, path.handle, false);
        this.currentPoint.X = path.currentPoint.X;
        this.currentPoint.Y = path.currentPoint.Y;
    }

    public void addRectangle(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RectF rectF = new RectF();
        rectF.X = f;
        rectF.Y = f2;
        rectF.Width = f3;
        rectF.Height = f4;
        Gdip.GraphicsPath_AddRectangle(this.handle, rectF);
        this.currentPoint.X = f;
        this.currentPoint.Y = f2;
    }

    public void addString(String string, float f, float f2, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = this.device.internal_new_GC(null);
        int[] nArray = new int[1];
        int n3 = GC.createGdipFont(n2, font.handle, 0, this.device.fontCollection, nArray, null);
        PointF pointF = new PointF();
        pointF.X = f - Gdip.Font_GetSize(n3) / 6.0f;
        pointF.Y = f2;
        int n4 = Gdip.Font_GetStyle(n3);
        float f3 = Gdip.Font_GetSize(n3);
        Gdip.GraphicsPath_AddString(this.handle, cArray, n, nArray[0], n4, f3, pointF, 0);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
        Gdip.FontFamily_delete(nArray[0]);
        Gdip.Font_delete(n3);
        this.device.internal_dispose_GC(n2, null);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_CloseFigure(this.handle);
        this.currentPoint.X = this.startPoint.X;
        this.currentPoint.Y = this.startPoint.Y;
    }

    public boolean contains(float f, float f2, GC gC, boolean bl) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.initGdip();
        gC.checkGC(120);
        int n = OS.GetPolyFillMode(gC.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(this.handle, n);
        if (bl) {
            return Gdip.GraphicsPath_IsOutlineVisible(this.handle, f, f2, gC.data.gdipPen, gC.data.gdipGraphics);
        }
        return Gdip.GraphicsPath_IsVisible(this.handle, f, f2, gC.data.gdipGraphics);
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, f, f2, f3, f4, f5, f6);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    void destroy() {
        Gdip.GraphicsPath_delete(this.handle);
        this.handle = 0;
    }

    public void getBounds(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        RectF rectF = new RectF();
        Gdip.GraphicsPath_GetBounds(this.handle, rectF, 0, 0);
        fArray[0] = rectF.X;
        fArray[1] = rectF.Y;
        fArray[2] = rectF.Width;
        fArray[3] = rectF.Height;
    }

    public void getCurrentPoint(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        fArray[0] = this.currentPoint.X;
        fArray[1] = this.currentPoint.Y;
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int n = Gdip.GraphicsPath_GetPointCount(this.handle);
        byte[] byArray = new byte[n];
        float[] fArray = new float[n * 2];
        Gdip.GraphicsPath_GetPathTypes(this.handle, byArray, n);
        Gdip.GraphicsPath_GetPathPoints(this.handle, fArray, n);
        byte[] byArray2 = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            boolean bl = false;
            switch (by & 7) {
                case 0: {
                    byArray2[n3++] = 1;
                    bl = (by & 0x80) != 0;
                    ++n2;
                    break;
                }
                case 1: {
                    byArray2[n3++] = 2;
                    bl = (by & 0x80) != 0;
                    ++n2;
                    break;
                }
                case 3: {
                    byArray2[n3++] = 4;
                    bl = (byArray[n2 + 2] & 0x80) != 0;
                    n2 += 3;
                    break;
                }
                default: {
                    ++n2;
                }
            }
            if (!bl) continue;
            byArray2[n3++] = 5;
        }
        if (n3 != byArray2.length) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = byArray3;
        }
        PathData pathData = new PathData();
        pathData.types = byArray2;
        pathData.points = fArray;
        return pathData;
    }

    public void lineTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddLine(this.handle, this.currentPoint.X, this.currentPoint.Y, f, f2);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    void init(PathData pathData) {
        byte[] byArray = pathData.types;
        float[] fArray = pathData.points;
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                case 1: {
                    this.moveTo(fArray[n2++], fArray[n2++]);
                    break;
                }
                case 2: {
                    this.lineTo(fArray[n2++], fArray[n2++]);
                    break;
                }
                case 4: {
                    this.cubicTo(fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++]);
                    break;
                }
                case 3: {
                    this.quadTo(fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++n;
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void moveTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_StartFigure(this.handle);
        this.currentPoint.X = this.startPoint.X = f;
        this.currentPoint.Y = this.startPoint.Y = f2;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float f5 = this.currentPoint.X + 2.0f * (f - this.currentPoint.X) / 3.0f;
        float f6 = this.currentPoint.Y + 2.0f * (f2 - this.currentPoint.Y) / 3.0f;
        float f7 = f5 + (f3 - this.currentPoint.X) / 3.0f;
        float f8 = f6 + (f4 - this.currentPoint.Y) / 3.0f;
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, f5, f6, f7, f8, f3, f4);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

