/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.handler;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.SyncProgressHelper;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.handler.BaseFileHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.widgets.Shell;

public class MethodProfilingHandler
extends BaseFileHandler
implements ClientData.IMethodProfilingHandler {
    public MethodProfilingHandler(Shell parentShell) {
        super(parentShell);
    }

    protected String getDialogTitle() {
        return "Method Profiling Error";
    }

    public void onStartFailure(Client client, String message) {
        this.displayErrorInUiThread("Unable to create Method Profiling file for application '%1$s'\n\n%2$sCheck logcat for more information.", client.getClientData().getClientDescription(), message != null ? message + "\n\n" : "");
    }

    public void onEndFailure(Client client, String message) {
        this.displayErrorInUiThread("Unable to finish Method Profiling for application '%1$s'\n\n%2$sCheck logcat for more information.", client.getClientData().getClientDescription(), message != null ? message + "\n\n" : "");
    }

    public void onSuccess(final String remoteFilePath, final Client client) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (remoteFilePath == null) {
                    MethodProfilingHandler.this.displayErrorFromUiThread("Unable to download trace file: unknown file name.\nThis can happen if you disconnected the device while recording the trace.", new Object[0]);
                    return;
                }
                IDevice device = client.getDevice();
                try {
                    SyncService sync = client.getDevice().getSyncService();
                    if (sync != null) {
                        MethodProfilingHandler.this.pullAndOpen(sync, remoteFilePath);
                    } else {
                        MethodProfilingHandler.this.displayErrorFromUiThread("Unable to download trace file from device '%1$s'.", device.getSerialNumber());
                    }
                }
                catch (Exception e) {
                    MethodProfilingHandler.this.displayErrorFromUiThread("Unable to download trace file from device '%1$s'.", device.getSerialNumber());
                }
            }
        });
    }

    public void onSuccess(byte[] data, Client client) {
        try {
            File tempFile = this.saveTempFile(data);
            this.openInTraceview(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            String errorMsg = e.getMessage();
            this.displayErrorInUiThread("Failed to save trace data into temp file%1$s", errorMsg != null ? ":\n" + errorMsg : ".");
        }
    }

    private void pullAndOpen(final SyncService sync, final String remoteFilePath) throws InvocationTargetException, InterruptedException, IOException {
        File temp = File.createTempFile("android", ".trace");
        final String tempPath = temp.getAbsolutePath();
        try {
            SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                public void run(SyncService.ISyncProgressMonitor monitor) throws SyncException, IOException, TimeoutException {
                    sync.pullFile(tempPath, remoteFilePath, monitor);
                }

                public void close() {
                    sync.close();
                }
            }, String.format("Pulling %1$s from the device", remoteFilePath), this.mParentShell);
            this.openInTraceview(tempPath);
        }
        catch (SyncException e) {
            if (!e.wasCanceled()) {
                this.displayErrorFromUiThread("Unable to download trace file:\n\n%1$s", e.getMessage());
            }
        }
        catch (TimeoutException e) {
            this.displayErrorFromUiThread("Unable to download trace file:\n\ntimeout", new Object[0]);
        }
    }

    private void openInTraceview(String tempPath) {
        String[] command = new String[]{DdmUiPreferences.getTraceview(), tempPath};
        try {
            final Process p = Runtime.getRuntime().exec(command);
            new Thread("Traceview output"){

                public void run() {
                    InputStreamReader is = new InputStreamReader(p.getErrorStream());
                    BufferedReader resultReader = new BufferedReader(is);
                    try {
                        String line;
                        while ((line = resultReader.readLine()) != null) {
                            DdmConsole.printErrorToConsole("Traceview: " + line);
                        }
                        p.waitFor();
                    }
                    catch (Exception e) {
                        Log.e((String)"traceview", (Throwable)e);
                    }
                }
            }.start();
        }
        catch (IOException e) {
            Log.e((String)"traceview", (Throwable)e);
        }
    }
}

