/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.models;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewerlib.device.Window;
import java.util.ArrayList;
import java.util.HashMap;

public class DeviceSelectionModel {
    private final HashMap<IDevice, Window[]> mDeviceMap = new HashMap();
    private final HashMap<IDevice, Integer> mFocusedWindowHashes = new HashMap();
    private final ArrayList<IDevice> mDeviceList = new ArrayList();
    private final ArrayList<IWindowChangeListener> mWindowChangeListeners = new ArrayList();
    private IDevice mSelectedDevice;
    private Window mSelectedWindow;
    private static DeviceSelectionModel sModel;

    public static DeviceSelectionModel getModel() {
        if (sModel == null) {
            sModel = new DeviceSelectionModel();
        }
        return sModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDevice(IDevice device) {
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            return this.mDeviceMap.containsKey(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(IDevice device, Window[] windows) {
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            this.mDeviceMap.put(device, windows);
            this.mDeviceList.add(device);
        }
        this.notifyDeviceConnected(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDevice(IDevice device) {
        boolean selectionChanged = false;
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            this.mDeviceList.remove(device);
            if (!this.mDeviceList.contains(device)) {
                this.mDeviceMap.remove(device);
                this.mFocusedWindowHashes.remove(device);
                if (this.mSelectedDevice == device) {
                    this.mSelectedDevice = null;
                    this.mSelectedWindow = null;
                    selectionChanged = true;
                }
            }
        }
        this.notifyDeviceDisconnected(device);
        if (selectionChanged) {
            this.notifySelectionChanged(this.mSelectedDevice, this.mSelectedWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDevice(IDevice device, Window[] windows) {
        boolean selectionChanged = false;
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            this.mDeviceMap.put(device, windows);
            if (this.mSelectedDevice == device && this.mSelectedWindow != null) {
                boolean windowStillExists = false;
                for (int i = 0; i < windows.length && !windowStillExists; ++i) {
                    if (!windows[i].equals(this.mSelectedWindow)) continue;
                    windowStillExists = true;
                }
                if (!windowStillExists) {
                    this.mSelectedDevice = null;
                    this.mSelectedWindow = null;
                    selectionChanged = true;
                }
            }
        }
        this.notifyDeviceChanged(device);
        if (selectionChanged) {
            this.notifySelectionChanged(this.mSelectedDevice, this.mSelectedWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFocusedWindow(IDevice device, int focusedWindow) {
        Integer oldValue = null;
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            oldValue = this.mFocusedWindowHashes.put(device, new Integer(focusedWindow));
        }
        if (oldValue == null || oldValue != null && oldValue != focusedWindow) {
            this.notifyFocusChanged(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWindowChangeListener[] getWindowChangeListenerList() {
        IWindowChangeListener[] listeners = null;
        ArrayList<IWindowChangeListener> arrayList = this.mWindowChangeListeners;
        synchronized (arrayList) {
            if (this.mWindowChangeListeners.size() == 0) {
                return null;
            }
            listeners = this.mWindowChangeListeners.toArray(new IWindowChangeListener[this.mWindowChangeListeners.size()]);
        }
        return listeners;
    }

    private void notifyDeviceConnected(IDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].deviceConnected(device);
            }
        }
    }

    private void notifyDeviceChanged(IDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].deviceChanged(device);
            }
        }
    }

    private void notifyDeviceDisconnected(IDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].deviceDisconnected(device);
            }
        }
    }

    private void notifyFocusChanged(IDevice device) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].focusChanged(device);
            }
        }
    }

    private void notifySelectionChanged(IDevice device, Window window) {
        IWindowChangeListener[] listeners = this.getWindowChangeListenerList();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].selectionChanged(device, window);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(IWindowChangeListener listener) {
        ArrayList<IWindowChangeListener> arrayList = this.mWindowChangeListeners;
        synchronized (arrayList) {
            this.mWindowChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(IWindowChangeListener listener) {
        ArrayList<IWindowChangeListener> arrayList = this.mWindowChangeListeners;
        synchronized (arrayList) {
            this.mWindowChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice[] getDevices() {
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            return this.mDeviceList.toArray(new IDevice[this.mDeviceList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window[] getWindows(IDevice device) {
        Window[] windows;
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            windows = this.mDeviceMap.get(device);
        }
        return windows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFocusedWindow(IDevice device) {
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            Integer focusedWindow = this.mFocusedWindowHashes.get(device);
            if (focusedWindow == null) {
                return -1;
            }
            return focusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(IDevice device, Window window) {
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            this.mSelectedDevice = device;
            this.mSelectedWindow = window;
        }
        this.notifySelectionChanged(device, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice getSelectedDevice() {
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            return this.mSelectedDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getSelectedWindow() {
        HashMap<IDevice, Window[]> hashMap = this.mDeviceMap;
        synchronized (hashMap) {
            return this.mSelectedWindow;
        }
    }

    public static interface IWindowChangeListener {
        public void deviceConnected(IDevice var1);

        public void deviceChanged(IDevice var1);

        public void deviceDisconnected(IDevice var1);

        public void focusChanged(IDevice var1);

        public void selectionChanged(IDevice var1, Window var2);
    }
}

