/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.internal.repository.IDescription;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

class LocalSdkAdapter {
    private final UpdaterData mUpdaterData;

    public LocalSdkAdapter(UpdaterData updaterData) {
        this.mUpdaterData = updaterData;
    }

    public ILabelProvider getLabelProvider() {
        return new ViewerLabelProvider();
    }

    public IContentProvider getContentProvider() {
        return new TableContentProvider();
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            assert (newInput == LocalSdkAdapter.this);
        }

        public Object[] getElements(Object inputElement) {
            Object[] packages;
            if (inputElement == LocalSdkAdapter.this && (packages = LocalSdkAdapter.this.mUpdaterData.getInstalledPackage()) != null) {
                return packages;
            }
            return new Object[0];
        }
    }

    public class ViewerLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            ImageFactory imgFactory = LocalSdkAdapter.this.mUpdaterData.getImageFactory();
            if (imgFactory != null) {
                return imgFactory.getImageForObject(element);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IDescription) {
                return ((IDescription)element).getShortDescription();
            }
            return super.getText(element);
        }
    }
}

