/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SdkSourceCategory;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class RepoSourcesAdapter {
    private final UpdaterData mUpdaterData;

    public RepoSourcesAdapter(UpdaterData updaterData) {
        this.mUpdaterData = updaterData;
    }

    public ILabelProvider getLabelProvider() {
        return new ViewerLabelProvider();
    }

    public IContentProvider getContentProvider() {
        return new TreeContentProvider();
    }

    private Package[] filterUpdateOnlyPackages(Package[] remotePackages) {
        Package[] installedPackages = this.mUpdaterData.getInstalledPackage();
        ArrayList<Package> filteredList = new ArrayList<Package>();
        for (Package remotePkg : remotePackages) {
            boolean newPkg = true;
            if (remotePkg.isObsolete() || !remotePkg.hasCompatibleArchive()) continue;
            for (Package installedPkg : installedPackages) {
                Package.UpdateInfo info = installedPkg.canBeUpdatedBy(remotePkg);
                if (info == Package.UpdateInfo.UPDATE) {
                    filteredList.add(remotePkg);
                    newPkg = false;
                    break;
                }
                if (info == Package.UpdateInfo.INCOMPATIBLE) continue;
                newPkg = false;
                break;
            }
            if (!newPkg) continue;
            filteredList.add(remotePkg);
        }
        return filteredList.toArray(new Package[filteredList.size()]);
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            assert (newInput == RepoSourcesAdapter.this);
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == RepoSourcesAdapter.this) {
                return RepoSourcesAdapter.this.mUpdaterData.getSources().getCategories();
            }
            if (parentElement instanceof SdkSourceCategory) {
                Object[] sources;
                SdkSourceCategory cat = (SdkSourceCategory)parentElement;
                if (cat == SdkSourceCategory.ADDONS_3RD_PARTY) {
                    RepoSourcesAdapter.this.mUpdaterData.loadRemoteAddonsList();
                }
                if ((sources = RepoSourcesAdapter.this.mUpdaterData.getSources().getSources(cat)).length == 1 && sources[0] != null && cat.getUiName().equals(sources[0].getUiName())) {
                    return this.getRepoSourceChildren((SdkSource)sources[0]);
                }
                return sources;
            }
            if (parentElement instanceof SdkSource) {
                return this.getRepoSourceChildren((SdkSource)parentElement);
            }
            if (parentElement instanceof Package) {
                return this.getPackageChildren((Package)parentElement);
            }
            return new Object[0];
        }

        private Object[] getRepoSourceChildren(final SdkSource source) {
            boolean wasEmptyBeforeFilter;
            Package[] packages = source.getPackages();
            if (packages == null && source.getFetchError() == null) {
                final boolean forceHttp = RepoSourcesAdapter.this.mUpdaterData.getSettingsController().getForceHttp();
                RepoSourcesAdapter.this.mUpdaterData.getTaskFactory().start("Loading Source", new ITask(){

                    public void run(ITaskMonitor monitor) {
                        source.load(monitor, forceHttp);
                    }
                });
                packages = source.getPackages();
            }
            boolean bl = wasEmptyBeforeFilter = packages == null || packages.length == 0;
            if (packages != null && RepoSourcesAdapter.this.mUpdaterData.getSettingsController().getShowUpdateOnly()) {
                packages = RepoSourcesAdapter.this.filterUpdateOnlyPackages(packages);
            }
            if (packages != null && packages.length == 0) {
                packages = null;
            }
            ArrayList<Object> results = new ArrayList<Object>();
            if (source.getFetchError() != null) {
                results.add(new RepoSourceError(source));
            }
            if (packages != null) {
                for (Package p : packages) {
                    results.add(p);
                }
            } else {
                results.add(new RepoSourceEmpty(source, !wasEmptyBeforeFilter));
            }
            return results.toArray();
        }

        private Object[] getPackageChildren(Package pkg) {
            Object[] archives = pkg.getArchives();
            if (RepoSourcesAdapter.this.mUpdaterData.getSettingsController().getShowUpdateOnly()) {
                for (Object archive : archives) {
                    if (!archive.isCompatible()) continue;
                    return new Object[]{archive};
                }
            }
            return archives;
        }

        public Object getParent(Object element) {
            if (element instanceof SdkSourceCategory) {
                return RepoSourcesAdapter.this;
            }
            if (element instanceof SdkSource) {
                return RepoSourcesAdapter.this.mUpdaterData.getSources().getCategory((SdkSource)element);
            }
            if (element instanceof Package) {
                return ((Package)element).getParentSource();
            }
            if (element instanceof Archive) {
                return ((Archive)element).getParentPackage();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof SdkSourceCategory || element instanceof SdkSource || element instanceof Package;
        }
    }

    private class ViewerLabelProvider
    extends LabelProvider {
        private ViewerLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageFactory imgFactory = RepoSourcesAdapter.this.mUpdaterData.getImageFactory();
            if (imgFactory != null) {
                return imgFactory.getImageForObject(element);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IDescription) {
                return ((IDescription)element).getShortDescription();
            }
            return super.getText(element);
        }
    }

    public static class RepoSourceEmpty
    implements IDescription {
        private final SdkSource mSource;
        private final boolean mEmptyBecauseOfUpdateOnly;

        public RepoSourceEmpty(SdkSource source, boolean emptyBecauseOfUpdateOnly) {
            this.mSource = source;
            this.mEmptyBecauseOfUpdateOnly = emptyBecauseOfUpdateOnly;
        }

        public String getLongDescription() {
            return this.mSource.getLongDescription();
        }

        public String getShortDescription() {
            if (this.mEmptyBecauseOfUpdateOnly) {
                return "Some packages were found but are not compatible updates.";
            }
            return "No packages found";
        }
    }

    public static class RepoSourceError
    implements IDescription {
        private final SdkSource mSource;

        public RepoSourceError(SdkSource source) {
            this.mSource = source;
        }

        public String getLongDescription() {
            return this.mSource.getLongDescription();
        }

        public String getShortDescription() {
            return this.mSource.getFetchError();
        }
    }
}

