/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdkuilib.ui.GridDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ResolutionChooserDialog
extends GridDialog {
    public static final float[] MONITOR_SIZES = new float[]{13.3f, 14.0f, 15.4f, 15.6f, 17.0f, 19.0f, 20.0f, 21.0f, 24.0f, 30.0f};
    private Button mButton;
    private Combo mScreenSizeCombo;
    private Combo mMonitorCombo;
    private Monitor[] mMonitors;
    private int mScreenSizeIndex = -1;
    private int mMonitorIndex = 0;

    public ResolutionChooserDialog(Shell parentShell) {
        super(parentShell, 2, false);
    }

    public int getDensity() {
        float size = MONITOR_SIZES[this.mScreenSizeIndex];
        Rectangle rect = this.mMonitors[this.mMonitorIndex].getBounds();
        double d = Math.sqrt(rect.width * rect.width + rect.height * rect.height) / (double)size;
        return (int)Math.round(d);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Monitor Density");
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.mButton = this.getButton(0);
        this.mButton.setEnabled(false);
        return control;
    }

    public void createDialogContent(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Screen Size:");
        this.mScreenSizeCombo = new Combo(parent, 12);
        for (float size : MONITOR_SIZES) {
            if ((float)Math.round(size) == size) {
                this.mScreenSizeCombo.add(String.format("%.0f\"", Float.valueOf(size)));
                continue;
            }
            this.mScreenSizeCombo.add(String.format("%.1f\"", Float.valueOf(size)));
        }
        this.mScreenSizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ResolutionChooserDialog.this.mScreenSizeIndex = ResolutionChooserDialog.this.mScreenSizeCombo.getSelectionIndex();
                ResolutionChooserDialog.this.mButton.setEnabled(ResolutionChooserDialog.this.mScreenSizeIndex != -1);
            }
        });
        l = new Label(parent, 0);
        l.setText("Resolution:");
        this.mMonitorCombo = new Combo(parent, 12);
        for (Monitor m : this.mMonitors = parent.getDisplay().getMonitors()) {
            Rectangle r = m.getBounds();
            this.mMonitorCombo.add(String.format("%d x %d", r.width, r.height));
        }
        this.mMonitorCombo.select(this.mMonitorIndex);
        this.mMonitorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ResolutionChooserDialog.this.mMonitorIndex = ResolutionChooserDialog.this.mMonitorCombo.getSelectionIndex();
            }
        });
    }
}

