/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Client;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.HandleAppName;
import com.android.ddmlib.HandleHeap;
import com.android.ddmlib.HandleHello;
import com.android.ddmlib.HandleProfiling;
import com.android.ddmlib.HandleTest;
import com.android.ddmlib.HandleThread;
import com.android.ddmlib.HandleWait;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidDebugBridge {
    private static final int ADB_VERSION_MICRO_MIN = 20;
    private static final int ADB_VERSION_MICRO_MAX = -1;
    private static final Pattern sAdbVersion = Pattern.compile("^.*(\\d+)\\.(\\d+)\\.(\\d+)$");
    private static final String ADB = "adb";
    private static final String DDMS = "ddms";
    private static final String SERVER_PORT_ENV_VAR = "ANDROID_ADB_SERVER_PORT";
    static final String ADB_HOST = "127.0.0.1";
    static final int ADB_PORT = 5037;
    private static InetAddress sHostAddr;
    private static InetSocketAddress sSocketAddr;
    private static AndroidDebugBridge sThis;
    private static boolean sInitialized;
    private static boolean sClientSupport;
    private String mAdbOsLocation = null;
    private boolean mVersionCheck;
    private boolean mStarted = false;
    private DeviceMonitor mDeviceMonitor;
    private static final ArrayList<IDebugBridgeChangeListener> sBridgeListeners;
    private static final ArrayList<IDeviceChangeListener> sDeviceListeners;
    private static final ArrayList<IClientChangeListener> sClientListeners;
    private static final Object sLock;

    public static synchronized void init(boolean clientSupport) {
        if (sInitialized) {
            throw new IllegalStateException("AndroidDebugBridge.init() has already been called.");
        }
        sInitialized = true;
        sClientSupport = clientSupport;
        AndroidDebugBridge.initAdbSocketAddr();
        MonitorThread monitorThread = MonitorThread.createInstance();
        monitorThread.start();
        HandleHello.register(monitorThread);
        HandleAppName.register(monitorThread);
        HandleTest.register(monitorThread);
        HandleThread.register(monitorThread);
        HandleHeap.register(monitorThread);
        HandleWait.register(monitorThread);
        HandleProfiling.register(monitorThread);
    }

    public static void terminate() {
        MonitorThread monitorThread;
        if (sThis != null && AndroidDebugBridge.sThis.mDeviceMonitor != null) {
            AndroidDebugBridge.sThis.mDeviceMonitor.stop();
            AndroidDebugBridge.sThis.mDeviceMonitor = null;
        }
        if ((monitorThread = MonitorThread.getInstance()) != null) {
            monitorThread.quit();
        }
    }

    static boolean getClientSupport() {
        return sClientSupport;
    }

    public static InetSocketAddress getSocketAddress() {
        return sSocketAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge() {
        Object object = sLock;
        synchronized (object) {
            IDebugBridgeChangeListener[] listenersCopy;
            if (sThis != null) {
                return sThis;
            }
            try {
                sThis = new AndroidDebugBridge();
                sThis.start();
            }
            catch (InvalidParameterException e) {
                sThis = null;
            }
            for (IDebugBridgeChangeListener listener : listenersCopy = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()])) {
                try {
                    listener.bridgeChanged(sThis);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return sThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge) {
        Object object = sLock;
        synchronized (object) {
            IDebugBridgeChangeListener[] listenersCopy;
            if (sThis != null) {
                if (AndroidDebugBridge.sThis.mAdbOsLocation != null && AndroidDebugBridge.sThis.mAdbOsLocation.equals(osLocation) && !forceNewBridge) {
                    return sThis;
                }
                sThis.stop();
            }
            try {
                sThis = new AndroidDebugBridge(osLocation);
                sThis.start();
            }
            catch (InvalidParameterException e) {
                sThis = null;
            }
            for (IDebugBridgeChangeListener listener : listenersCopy = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()])) {
                try {
                    listener.bridgeChanged(sThis);
                }
                catch (Exception e) {
                    Log.e(DDMS, e);
                }
            }
            return sThis;
        }
    }

    public static AndroidDebugBridge getBridge() {
        return sThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectBridge() {
        Object object = sLock;
        synchronized (object) {
            if (sThis != null) {
                IDebugBridgeChangeListener[] listenersCopy;
                sThis.stop();
                sThis = null;
                for (IDebugBridgeChangeListener listener : listenersCopy = sBridgeListeners.toArray(new IDebugBridgeChangeListener[sBridgeListeners.size()])) {
                    try {
                        listener.bridgeChanged(sThis);
                    }
                    catch (Exception e) {
                        Log.e(DDMS, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            if (!sBridgeListeners.contains(listener)) {
                sBridgeListeners.add(listener);
                if (sThis != null) {
                    try {
                        listener.bridgeChanged(sThis);
                    }
                    catch (Exception e) {
                        Log.e(DDMS, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sBridgeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDeviceChangeListener(IDeviceChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            if (!sDeviceListeners.contains(listener)) {
                sDeviceListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeviceChangeListener(IDeviceChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sDeviceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClientChangeListener(IClientChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            if (!sClientListeners.contains(listener)) {
                sClientListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientChangeListener(IClientChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sClientListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice[] getDevices() {
        Object object = sLock;
        synchronized (object) {
            if (this.mDeviceMonitor != null) {
                return this.mDeviceMonitor.getDevices();
            }
        }
        return new IDevice[0];
    }

    public boolean hasInitialDeviceList() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.hasInitialDeviceList();
        }
        return false;
    }

    public void setSelectedClient(Client selectedClient) {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (monitorThread != null) {
            monitorThread.setSelectedClient(selectedClient);
        }
    }

    public boolean isConnected() {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (this.mDeviceMonitor != null && monitorThread != null) {
            return this.mDeviceMonitor.isMonitoring() && monitorThread.getState() != Thread.State.TERMINATED;
        }
        return false;
    }

    public int getConnectionAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getConnectionAttemptCount();
        }
        return -1;
    }

    public int getRestartAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getRestartAttemptCount();
        }
        return -1;
    }

    private AndroidDebugBridge(String osLocation) throws InvalidParameterException {
        if (osLocation == null || osLocation.length() == 0) {
            throw new InvalidParameterException();
        }
        this.mAdbOsLocation = osLocation;
        this.checkAdbVersion();
    }

    private AndroidDebugBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAdbVersion() {
        this.mVersionCheck = false;
        if (this.mAdbOsLocation == null) {
            return;
        }
        try {
            String line;
            String[] command = new String[]{this.mAdbOsLocation, "version"};
            Log.d(DDMS, String.format("Checking '%1$s version'", this.mAdbOsLocation));
            Process process = Runtime.getRuntime().exec(command);
            ArrayList<String> errorOutput = new ArrayList<String>();
            ArrayList<String> stdOutput = new ArrayList<String>();
            int status = this.grabProcessOutput(process, errorOutput, stdOutput, true);
            if (status != 0) {
                StringBuilder builder = new StringBuilder("'adb version' failed!");
                for (String error : errorOutput) {
                    builder.append('\n');
                    builder.append(error);
                }
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, builder.toString());
            }
            boolean versionFound = false;
            Iterator<String> i$ = stdOutput.iterator();
            while (i$.hasNext() && !(versionFound = this.scanVersionLine(line = i$.next()))) {
            }
            if (!versionFound) {
                i$ = errorOutput.iterator();
                while (i$.hasNext() && !(versionFound = this.scanVersionLine(line = i$.next()))) {
                }
            }
            if (!versionFound) {
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Failed to parse the output of 'adb version'");
            }
        }
        catch (IOException e) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Failed to get the adb version: " + e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean scanVersionLine(String line) {
        Matcher matcher;
        if (line != null && (matcher = sAdbVersion.matcher(line)).matches()) {
            int majorVersion = Integer.parseInt(matcher.group(1));
            int minorVersion = Integer.parseInt(matcher.group(2));
            int microVersion = Integer.parseInt(matcher.group(3));
            if (microVersion < 20) {
                String message = String.format("Required minimum version of adb: %1$d.%2$d.%3$d.Current version is %1$d.%2$d.%4$d", majorVersion, minorVersion, 20, microVersion);
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, message);
            } else {
                this.mVersionCheck = true;
            }
            return true;
        }
        return false;
    }

    boolean start() {
        if (!(this.mAdbOsLocation == null || this.mVersionCheck && this.startAdb())) {
            return false;
        }
        this.mStarted = true;
        this.mDeviceMonitor = new DeviceMonitor(this);
        this.mDeviceMonitor.start();
        return true;
    }

    boolean stop() {
        if (!this.mStarted) {
            return false;
        }
        this.mDeviceMonitor.stop();
        this.mDeviceMonitor = null;
        if (!this.stopAdb()) {
            return false;
        }
        this.mStarted = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot restart adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (!this.mVersionCheck) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Attempting to restart adb, but version check failed!");
            return false;
        }
        AndroidDebugBridge androidDebugBridge = this;
        synchronized (androidDebugBridge) {
            this.stopAdb();
            boolean restart = this.startAdb();
            if (restart && this.mDeviceMonitor == null) {
                this.mDeviceMonitor = new DeviceMonitor(this);
                this.mDeviceMonitor.start();
            }
            return restart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceConnected(IDevice device) {
        IDeviceChangeListener[] listenersCopy = null;
        Object object = sLock;
        synchronized (object) {
            listenersCopy = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
        }
        for (IDeviceChangeListener listener : listenersCopy) {
            try {
                listener.deviceConnected(device);
            }
            catch (Exception e) {
                Log.e(DDMS, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceDisconnected(IDevice device) {
        IDeviceChangeListener[] listenersCopy = null;
        Object object = sLock;
        synchronized (object) {
            listenersCopy = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
        }
        for (IDeviceChangeListener listener : listenersCopy) {
            try {
                listener.deviceDisconnected(device);
            }
            catch (Exception e) {
                Log.e(DDMS, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deviceChanged(IDevice device, int changeMask) {
        IDeviceChangeListener[] listenersCopy = null;
        Object object = sLock;
        synchronized (object) {
            listenersCopy = sDeviceListeners.toArray(new IDeviceChangeListener[sDeviceListeners.size()]);
        }
        for (IDeviceChangeListener listener : listenersCopy) {
            try {
                listener.deviceChanged(device, changeMask);
            }
            catch (Exception e) {
                Log.e(DDMS, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientChanged(Client client, int changeMask) {
        IClientChangeListener[] listenersCopy = null;
        Object object = sLock;
        synchronized (object) {
            listenersCopy = sClientListeners.toArray(new IClientChangeListener[sClientListeners.size()]);
        }
        for (IClientChangeListener listener : listenersCopy) {
            try {
                listener.clientChanged(client, changeMask);
            }
            catch (Exception e) {
                Log.e(DDMS, e);
            }
        }
    }

    DeviceMonitor getDeviceMonitor() {
        return this.mDeviceMonitor;
    }

    synchronized boolean startAdb() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot start adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        int status = -1;
        try {
            String[] command = new String[]{this.mAdbOsLocation, "start-server"};
            Log.d(DDMS, String.format("Launching '%1$s %2$s' to ensure ADB is running.", this.mAdbOsLocation, command[1]));
            Process proc = Runtime.getRuntime().exec(command);
            ArrayList<String> errorOutput = new ArrayList<String>();
            ArrayList<String> stdOutput = new ArrayList<String>();
            status = this.grabProcessOutput(proc, errorOutput, stdOutput, false);
        }
        catch (IOException ioe) {
            Log.d(DDMS, "Unable to run 'adb': " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            Log.d(DDMS, "Unable to run 'adb': " + ie.getMessage());
        }
        if (status != 0) {
            Log.w(DDMS, "'adb start-server' failed -- run manually if necessary");
            return false;
        }
        Log.d(DDMS, "'adb start-server' succeeded");
        return true;
    }

    private synchronized boolean stopAdb() {
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot stop adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        int status = -1;
        try {
            String[] command = new String[]{this.mAdbOsLocation, "kill-server"};
            Process proc = Runtime.getRuntime().exec(command);
            status = proc.waitFor();
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (status != 0) {
            Log.w(DDMS, "'adb kill-server' failed -- run manually if necessary");
            return false;
        }
        Log.d(DDMS, "'adb kill-server' succeeded");
        return true;
    }

    private int grabProcessOutput(final Process process, final ArrayList<String> errorOutput, final ArrayList<String> stdOutput, boolean waitforReaders) throws InterruptedException {
        assert (errorOutput != null);
        assert (stdOutput != null);
        Thread t1 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        Log.e(AndroidDebugBridge.ADB, line);
                        errorOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        Log.d(AndroidDebugBridge.ADB, line);
                        stdOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        t2.start();
        if (waitforReaders) {
            try {
                t1.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return process.waitFor();
    }

    static Object getLock() {
        return sLock;
    }

    private static void initAdbSocketAddr() {
        try {
            int adb_port = AndroidDebugBridge.determineAndValidateAdbPort();
            sHostAddr = InetAddress.getByName(ADB_HOST);
            sSocketAddr = new InetSocketAddress(sHostAddr, adb_port);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private static int determineAndValidateAdbPort() {
        int result = 5037;
        try {
            String adb_env_var = System.getenv(SERVER_PORT_ENV_VAR);
            if (adb_env_var != null) {
                adb_env_var = adb_env_var.trim();
            }
            if (adb_env_var != null && adb_env_var.length() > 0 && (result = Integer.decode(adb_env_var).intValue()) <= 0) {
                String errMsg = "env var ANDROID_ADB_SERVER_PORT: must be >=0, got " + System.getenv(SERVER_PORT_ENV_VAR);
                throw new IllegalArgumentException(errMsg);
            }
        }
        catch (NumberFormatException nfEx) {
            String errMsg = "env var ANDROID_ADB_SERVER_PORT: illegal value '" + System.getenv(SERVER_PORT_ENV_VAR) + "'";
            throw new IllegalArgumentException(errMsg);
        }
        catch (SecurityException secEx) {
            Log.w(DDMS, "No access to env variables allowed by current security manager. If you've set ANDROID_ADB_SERVER_PORT: it's being ignored.");
        }
        return result;
    }

    static {
        sInitialized = false;
        sBridgeListeners = new ArrayList();
        sDeviceListeners = new ArrayList();
        sClientListeners = new ArrayList();
        sLock = sBridgeListeners;
    }

    public static interface IClientChangeListener {
        public void clientChanged(Client var1, int var2);
    }

    public static interface IDeviceChangeListener {
        public void deviceConnected(IDevice var1);

        public void deviceDisconnected(IDevice var1);

        public void deviceChanged(IDevice var1, int var2);
    }

    public static interface IDebugBridgeChangeListener {
        public void bridgeChanged(AndroidDebugBridge var1);
    }
}

