/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import com.android.sdklib.internal.export.ApkData;
import com.android.sdklib.internal.export.MultiApkExportHelper;
import com.android.sdklib.internal.export.ProjectConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Input;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.SubAnt;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiApkExportTask
extends Task {
    private MultiApkExportHelper.Target mTarget;
    private XPathFactory mXPathFactory;

    public void setTarget(String target) {
        this.mTarget = MultiApkExportHelper.Target.getTarget((String)target);
    }

    public void execute() throws BuildException {
        block12: {
            int versionCode;
            Project antProject = this.getProject();
            if (this.mTarget == null) {
                throw new BuildException("'target' attribute not set.");
            }
            File sdk = TaskHelper.getSdkLocation(antProject);
            int toolsRevison = TaskHelper.getToolsRevision(sdk);
            if (toolsRevison != -1) {
                System.out.println("Android SDK Tools Revision " + toolsRevison);
            }
            String appPackage = this.getValidatedProperty(antProject, "package");
            System.out.println("Multi APK export for: " + appPackage);
            String version = this.getValidatedProperty(antProject, "versionCode");
            try {
                versionCode = Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                throw new BuildException("version value is not a valid integer.", (Throwable)e);
            }
            System.out.println("versionCode: " + version);
            String projectList = this.getValidatedProperty(antProject, "projects");
            File rootFolder = antProject.getBaseDir();
            MultiApkExportHelper helper = new MultiApkExportHelper(rootFolder.getAbsolutePath(), appPackage, versionCode, this.mTarget, System.out);
            try {
                if (this.mTarget == MultiApkExportHelper.Target.CLEAN) {
                    List projects = helper.getProjects(projectList);
                    for (ProjectConfig projectConfig : projects) {
                        this.executeCleanSubAnt(antProject, projectConfig);
                    }
                    break block12;
                }
                String value = antProject.getProperty("key.store");
                String keyStore = value != null && value.length() > 0 ? value : null;
                value = antProject.getProperty("key.alias");
                String keyAlias = value != null && value.length() > 0 ? value : null;
                boolean canSign = keyStore != null && keyAlias != null;
                List apks = helper.getApkData(projectList);
                HashSet<String> compiledProject = new HashSet<String>();
                this.mXPathFactory = XPathFactory.newInstance();
                File exportProjectOutput = new File(this.getValidatedProperty(antProject, "out.absolute.dir"));
                String keyStorePassword = null;
                String keyAliasPassword = null;
                if (canSign) {
                    System.out.println("Found signing keystore and key alias. Need passwords.");
                    Input input = new Input();
                    input.setProject(antProject);
                    input.setAddproperty("key.store.password");
                    input.setMessage(String.format("Please enter keystore password (store: %1$s):", keyStore));
                    input.execute();
                    input = new Input();
                    input.setProject(antProject);
                    input.setAddproperty("key.alias.password");
                    input.setMessage(String.format("Please enter password for alias '%1$s':", keyAlias));
                    input.execute();
                    keyStorePassword = this.getValidatedProperty(antProject, "key.store.password");
                    keyAliasPassword = this.getValidatedProperty(antProject, "key.alias.password");
                }
                for (ApkData apk : apks) {
                    Map variantMap = apk.getSoftVariantMap();
                    if (variantMap.size() > 0) {
                        for (Map.Entry<String, String> entry : variantMap.entrySet()) {
                            this.executeReleaseSubAnt(antProject, appPackage, versionCode, apk, entry, exportProjectOutput, canSign, keyStore, keyAlias, keyStorePassword, keyAliasPassword, compiledProject);
                        }
                        continue;
                    }
                    this.executeReleaseSubAnt(antProject, appPackage, versionCode, apk, null, exportProjectOutput, canSign, keyStore, keyAlias, keyStorePassword, keyAliasPassword, compiledProject);
                }
                helper.writeLogs();
            }
            catch (MultiApkExportHelper.ExportException e) {
                throw new BuildException(e.getMessage());
            }
        }
    }

    private void executeCleanSubAnt(Project antProject, ProjectConfig projectConfig) {
        String relativePath = projectConfig.getRelativePath();
        System.out.println("\n*************************************************************");
        System.out.println("Cleaning project: " + relativePath);
        SubAnt subAnt = new SubAnt();
        subAnt.setTarget(this.mTarget.getTarget());
        subAnt.setProject(antProject);
        File subProjectFolder = projectConfig.getProjectFolder();
        FileSet fileSet = new FileSet();
        fileSet.setProject(antProject);
        fileSet.setDir(subProjectFolder);
        fileSet.setIncludes("build.xml");
        subAnt.addFileset(fileSet);
        System.out.println("Calling to project's Ant file...");
        System.out.println("----------\n");
        subAnt.execute();
    }

    private void executeReleaseSubAnt(Project antProject, String appPackage, int versionCode, ApkData apk, Map.Entry<String, String> softVariant, File exportProjectOutput, boolean canSign, String keyStore, String keyAlias, String keyStorePassword, String keyAliasPassword, Set<String> compiledProject) {
        String outputName;
        String relativePath = apk.getProjectConfig().getRelativePath();
        System.out.println("\n*************************************************************");
        System.out.println("Exporting project: " + relativePath);
        SubAnt subAnt = new SubAnt();
        subAnt.setTarget(this.mTarget.getTarget());
        subAnt.setProject(antProject);
        File subProjectFolder = apk.getProjectConfig().getProjectFolder();
        FileSet fileSet = new FileSet();
        fileSet.setProject(antProject);
        fileSet.setDir(subProjectFolder);
        fileSet.setIncludes("build.xml");
        subAnt.addFileset(fileSet);
        if (!compiledProject.contains(relativePath)) {
            compiledProject.add(relativePath);
        } else {
            this.addProp(subAnt, "do.not.compile", "true");
        }
        int compositeVersionCode = apk.getCompositeVersionCode(versionCode);
        this.addProp(subAnt, "version.code", Integer.toString(compositeVersionCode));
        System.out.println("Composite versionCode: " + compositeVersionCode);
        String abi = apk.getAbi();
        if (abi != null) {
            this.addProp(subAnt, "filter.abi", abi);
            System.out.println("ABI Filter: " + abi);
        }
        String name = null;
        try {
            File buildFile = new File(subProjectFolder, "build.xml");
            XPath xPath = this.mXPathFactory.newXPath();
            name = xPath.evaluate("/project/@name", new InputSource(new FileInputStream(buildFile)));
        }
        catch (XPathExpressionException e) {
            throw new BuildException("Failed to read build.xml", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("build.xml is missing.", (Throwable)e);
        }
        String pkgName = name + "-" + apk.getBuildInfo();
        String finalNameRoot = appPackage + "-" + compositeVersionCode;
        if (softVariant != null) {
            String tmp = "-" + softVariant.getKey();
            pkgName = pkgName + tmp;
            finalNameRoot = finalNameRoot + tmp;
            this.addProp(subAnt, "aapt.resource.filter", softVariant.getValue());
            System.out.println("res Filter: " + softVariant.getValue());
        }
        this.addProp(subAnt, "resource.package.file.name", pkgName + ".ap_");
        if (canSign) {
            this.addProp(subAnt, "key.store", keyStore);
            this.addProp(subAnt, "key.alias", keyAlias);
            this.addProp(subAnt, "key.store.password", keyStorePassword);
            this.addProp(subAnt, "key.alias.password", keyAliasPassword);
            this.addProp(subAnt, "out.unsigned.file.name", name + "-" + apk.getBuildInfo() + "-unsigned.apk");
            this.addProp(subAnt, "out.unaligned.file", name + "-" + apk.getBuildInfo() + "-unaligned.apk");
            outputName = finalNameRoot + "-release.apk";
            apk.setOutputName(softVariant != null ? softVariant.getKey() : null, outputName);
            this.addProp(subAnt, "out.release.file", new File(exportProjectOutput, outputName).getAbsolutePath());
        } else {
            this.addProp(subAnt, "key.store", "");
            this.addProp(subAnt, "key.alias", "");
            outputName = finalNameRoot + "-unsigned.apk";
            apk.setOutputName(softVariant != null ? softVariant.getKey() : null, outputName);
            this.addProp(subAnt, "out.unsigned.file", new File(exportProjectOutput, outputName).getAbsolutePath());
        }
        System.out.println("Calling to project's Ant file...");
        System.out.println("----------\n");
        subAnt.execute();
    }

    private String getValidatedProperty(Project antProject, String name) {
        String value = antProject.getProperty(name);
        if (value == null || value.length() == 0) {
            throw new BuildException(String.format("Property '%1$s' is not set or empty.", name));
        }
        return value;
    }

    private void addProp(SubAnt task, String name, String value) {
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(value);
        task.addProperty(prop);
    }
}

