/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeyRunnerOptions {
    private static final Logger LOG = Logger.getLogger(MonkeyRunnerOptions.class.getName());
    private static String DEFAULT_MONKEY_SERVER_ADDRESS = "127.0.0.1";
    private static int DEFAULT_MONKEY_PORT = 12345;
    private final int port;
    private final String hostname;
    private final File scriptFile;
    private final String backend;
    private final Collection<File> plugins;
    private final Collection<String> arguments;

    private MonkeyRunnerOptions(String hostname, int port, File scriptFile, String backend, Collection<File> plugins, Collection<String> arguments) {
        this.hostname = hostname;
        this.port = port;
        this.scriptFile = scriptFile;
        this.backend = backend;
        this.plugins = plugins;
        this.arguments = arguments;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public String getBackendName() {
        return this.backend;
    }

    public Collection<File> getPlugins() {
        return this.plugins;
    }

    public Collection<String> getArguments() {
        return this.arguments;
    }

    private static void printUsage(String message) {
        System.out.println(message);
        System.out.println("Usage: monkeyrunner [options] SCRIPT_FILE");
        System.out.println("");
        System.out.println("    -s      MonkeyServer IP Address.");
        System.out.println("    -p      MonkeyServer TCP Port.");
        System.out.println("    -v      MonkeyServer Logging level (ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF)");
        System.out.println("");
        System.out.println("");
    }

    public static MonkeyRunnerOptions processOptions(String[] args) {
        int index = 0;
        String hostname = DEFAULT_MONKEY_SERVER_ADDRESS;
        File scriptFile = null;
        int port = DEFAULT_MONKEY_PORT;
        String backend = "adb";
        ImmutableList.Builder pluginListBuilder = ImmutableList.builder();
        ImmutableList.Builder argumentBuilder = ImmutableList.builder();
        while (index < args.length) {
            String argument;
            if ("-s".equals(argument = args[index++])) {
                if (index == args.length) {
                    MonkeyRunnerOptions.printUsage("Missing Server after -s");
                    return null;
                }
                hostname = args[index++];
                continue;
            }
            if ("-p".equals(argument)) {
                if (index == args.length) {
                    MonkeyRunnerOptions.printUsage("Missing Server port after -p");
                    return null;
                }
                port = Integer.parseInt(args[index++]);
                continue;
            }
            if ("-v".equals(argument)) {
                if (index == args.length) {
                    MonkeyRunnerOptions.printUsage("Missing Log Level after -v");
                    return null;
                }
                Level level = Level.parse(args[index++]);
                LOG.setLevel(level);
                level = LOG.getLevel();
                System.out.println("Log level set to: " + level + "(" + level.intValue() + ").");
                System.out.println("Warning: Log levels below INFO(800) not working currently... parent issues");
                continue;
            }
            if ("-be".equals(argument)) {
                if (index == args.length) {
                    MonkeyRunnerOptions.printUsage("Missing backend name after -be");
                    return null;
                }
                backend = args[index++];
                continue;
            }
            if ("-plugin".equals(argument)) {
                File plugin;
                if (index == args.length) {
                    MonkeyRunnerOptions.printUsage("Missing plugin path after -plugin");
                    return null;
                }
                if (!(plugin = new File(args[index++])).exists()) {
                    MonkeyRunnerOptions.printUsage("Plugin file doesn't exist");
                    return null;
                }
                if (!plugin.canRead()) {
                    MonkeyRunnerOptions.printUsage("Can't read plugin file");
                    return null;
                }
                pluginListBuilder.add((Object)plugin);
                continue;
            }
            if (argument.startsWith("-") && scriptFile == null) {
                MonkeyRunnerOptions.printUsage("Unrecognized argument: " + argument + ".");
                return null;
            }
            if (scriptFile == null) {
                scriptFile = new File(argument);
                if (!scriptFile.exists()) {
                    MonkeyRunnerOptions.printUsage("Can't open specified script file");
                    return null;
                }
                if (scriptFile.canRead()) continue;
                MonkeyRunnerOptions.printUsage("Can't open specified script file");
                return null;
            }
            argumentBuilder.add((Object)argument);
        }
        return new MonkeyRunnerOptions(hostname, port, scriptFile, backend, (Collection<File>)pluginListBuilder.build(), (Collection<String>)argumentBuilder.build());
    }
}

