/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddms.PrefsDialog;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DeviceCommandDialog
extends Dialog {
    public static final int DEVICE_STATE = 0;
    public static final int APP_STATE = 1;
    public static final int RADIO_STATE = 2;
    public static final int LOGCAT = 3;
    private String mCommand;
    private String mFileName;
    private Label mStatusLabel;
    private Button mCancelDone;
    private Button mSave;
    private Text mText;
    private Font mFont = null;
    private boolean mCancel;
    private boolean mFinished;

    public DeviceCommandDialog(String command, String fileName, Shell parent) {
        this(command, fileName, parent, 67696);
    }

    public DeviceCommandDialog(String command, String fileName, Shell parent, int style) {
        super(parent, style);
        this.mCommand = command;
        this.mFileName = fileName;
    }

    public void open(IDevice currentDevice) {
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, this.getStyle());
        shell.setText("Remote Command");
        this.mFinished = false;
        this.mFont = this.findFont(shell.getDisplay());
        this.createContents(shell);
        shell.setMinimumSize(500, 200);
        shell.setSize(800, 600);
        shell.open();
        this.executeCommand(shell, currentDevice);
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.mFont != null) {
            this.mFont.dispose();
        }
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, true));
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (!DeviceCommandDialog.this.mFinished) {
                    Log.d("ddms", "NOT closing - cancelling command");
                    event.doit = false;
                    DeviceCommandDialog.this.mCancel = true;
                }
            }
        });
        this.mStatusLabel = new Label((Composite)shell, 0);
        this.mStatusLabel.setText("Executing '" + this.shortCommandString() + "'");
        GridData data = new GridData(32);
        data.horizontalSpan = 2;
        this.mStatusLabel.setLayoutData((Object)data);
        this.mText = new Text((Composite)shell, 770);
        this.mText.setEditable(false);
        this.mText.setFont(this.mFont);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.mText.setLayoutData((Object)data);
        this.mSave = new Button((Composite)shell, 8);
        this.mSave.setText("Save");
        data = new GridData(64);
        data.widthHint = 80;
        this.mSave.setLayoutData((Object)data);
        this.mSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceCommandDialog.this.saveText(shell);
            }
        });
        this.mSave.setEnabled(false);
        this.mCancelDone = new Button((Composite)shell, 8);
        this.mCancelDone.setText("Cancel");
        data = new GridData(64);
        data.widthHint = 80;
        this.mCancelDone.setLayoutData((Object)data);
        this.mCancelDone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DeviceCommandDialog.this.mFinished) {
                    DeviceCommandDialog.this.mCancel = true;
                } else {
                    shell.close();
                }
            }
        });
    }

    private Font findFont(Display display) {
        FontData fdat;
        String fontStr = PrefsDialog.getStore().getString("textOutputFont");
        if (fontStr != null && (fdat = new FontData(fontStr)) != null) {
            return new Font((Device)display, fdat);
        }
        return null;
    }

    private void executeCommand(Shell shell, IDevice device) {
        Gatherer gath = new Gatherer(shell, device, this.commandString(), this.mText);
        gath.start();
    }

    private void updateForResult(int result) {
        if (result == 1) {
            this.mStatusLabel.setText("Successfully executed '" + this.shortCommandString() + "'");
            this.mSave.setEnabled(true);
        } else if (result == 3) {
            this.mStatusLabel.setText("Execution cancelled; partial results below");
            this.mSave.setEnabled(true);
        } else if (result == 2) {
            this.mStatusLabel.setText("Failed");
        }
        this.mStatusLabel.pack();
        this.mCancelDone.setText("Done");
        this.mFinished = true;
    }

    private void saveText(Shell shell) {
        FileDialog dlg = new FileDialog(shell, 8192);
        dlg.setText("Save output...");
        dlg.setFileName(this.defaultFileName());
        dlg.setFilterPath(PrefsDialog.getStore().getString("lastTextSaveDir"));
        dlg.setFilterNames(new String[]{"Text Files (*.txt)"});
        dlg.setFilterExtensions(new String[]{"*.txt"});
        String fileName = dlg.open();
        if (fileName != null) {
            byte[] ascii;
            PrefsDialog.getStore().setValue("lastTextSaveDir", dlg.getFilterPath());
            Log.d("ddms", "Saving output to " + fileName);
            String text = this.mText.getText();
            try {
                ascii = text.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
                ascii = new byte[]{};
            }
            try {
                int length = ascii.length;
                FileOutputStream outFile = new FileOutputStream(fileName);
                BufferedOutputStream out = new BufferedOutputStream(outFile);
                for (int i = 0; i < length; ++i) {
                    if (i < length - 1 && ascii[i] == 13 && ascii[i + 1] == 10) continue;
                    out.write(ascii[i]);
                }
                out.close();
            }
            catch (IOException ioe) {
                Log.w("ddms", "Unable to save " + fileName + ": " + ioe);
            }
        }
    }

    private String commandString() {
        return this.mCommand;
    }

    private String defaultFileName() {
        return this.mFileName;
    }

    private String shortCommandString() {
        String str = this.commandString();
        if (str.length() > 50) {
            return str.substring(0, 50) + "...";
        }
        return str;
    }

    class Gatherer
    extends Thread
    implements IShellOutputReceiver {
        public static final int RESULT_UNKNOWN = 0;
        public static final int RESULT_SUCCESS = 1;
        public static final int RESULT_FAILURE = 2;
        public static final int RESULT_CANCELLED = 3;
        private Shell mShell;
        private String mCommand;
        private Text mText;
        private int mResult;
        private IDevice mDevice;

        public Gatherer(Shell shell, IDevice device, String command, Text text) {
            this.mShell = shell;
            this.mDevice = device;
            this.mCommand = command;
            this.mText = text;
            this.mResult = 0;
            DeviceCommandDialog.this.mCancel = false;
        }

        public void run() {
            if (this.mDevice == null) {
                Log.w("ddms", "Cannot execute command: no device selected.");
                this.mResult = 2;
            } else {
                try {
                    this.mDevice.executeShellCommand(this.mCommand, this);
                    this.mResult = DeviceCommandDialog.this.mCancel ? 3 : 1;
                }
                catch (IOException ioe) {
                    Log.w("ddms", "Remote exec failed: " + ioe.getMessage());
                    this.mResult = 2;
                }
                catch (TimeoutException e) {
                    Log.w("ddms", "Remote exec failed: " + e.getMessage());
                    this.mResult = 2;
                }
                catch (AdbCommandRejectedException e) {
                    Log.w("ddms", "Remote exec failed: " + e.getMessage());
                    this.mResult = 2;
                }
                catch (ShellCommandUnresponsiveException e) {
                    Log.w("ddms", "Remote exec failed: " + e.getMessage());
                    this.mResult = 2;
                }
            }
            this.mShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    DeviceCommandDialog.this.updateForResult(Gatherer.this.mResult);
                }
            });
        }

        public void addOutput(byte[] data, int offset, int length) {
            Log.v("ddms", "received " + length + " bytes");
            try {
                final String text = new String(data, offset, length, "ISO-8859-1");
                this.mText.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Gatherer.this.mText.append(text);
                    }
                });
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return DeviceCommandDialog.this.mCancel;
        }
    }
}

