/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.externalization.DelegatingTaskExternalizer;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListExternalizer {
    private static final String ERROR_TASKLIST_READ = "Failed to load Task List";
    private static final String TRANSFORM_PROPERTY_VERSION = "version";
    private static final String XML_VERSION = "1.0";
    public static final String ATTRIBUTE_VERSION = "Version";
    public static final String ELEMENT_TASK_LIST = "TaskList";
    private static final String VALUE_VERSION = "2.0";
    private static final String VALUE_VERSION_1_0_0 = "1.0.0";
    private final DelegatingTaskExternalizer delegatingExternalizer;
    private final List<Node> orphanedNodes = new ArrayList<Node>();
    private Document orphanedDocument;
    private String readVersion = "";

    public TaskListExternalizer(RepositoryModel repositoryModel, IRepositoryManager repositoryManager) {
        this.delegatingExternalizer = new DelegatingTaskExternalizer(repositoryModel, repositoryManager);
        try {
            this.orphanedDocument = this.createDocument();
        }
        catch (CoreException e) {
            this.orphanedDocument = null;
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to create document for orphaned nodes", (Throwable)e));
        }
    }

    public void initialize(List<AbstractTaskListMigrator> migrators) {
        this.delegatingExternalizer.initialize(migrators);
    }

    public void writeTaskList(ITransferList taskList, File outFile) throws CoreException {
        try {
            FileOutputStream outStream = new FileOutputStream(outFile);
            try {
                Document doc = this.createTaskListDocument(taskList);
                ZipOutputStream zipOutStream = new ZipOutputStream(outStream);
                ZipEntry zipEntry = new ZipEntry("tasklist.xml");
                zipOutStream.putNextEntry(zipEntry);
                zipOutStream.setMethod(8);
                this.writeDocument(doc, zipOutStream);
                zipOutStream.flush();
                zipOutStream.closeEntry();
                zipOutStream.finish();
            }
            finally {
                outStream.close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Saving Task List failed", (Throwable)e));
        }
    }

    private Document createTaskListDocument(ITransferList taskList) throws CoreException {
        Document doc = this.createDocument();
        this.delegatingExternalizer.clearErrorStatus();
        Element root = doc.createElement(ELEMENT_TASK_LIST);
        root.setAttribute(ATTRIBUTE_VERSION, VALUE_VERSION);
        doc.appendChild(root);
        for (AbstractTask task : taskList.getAllTasks()) {
            this.delegatingExternalizer.createTaskElement(task, doc, root);
        }
        for (AbstractTaskCategory category : taskList.getCategories()) {
            this.delegatingExternalizer.createCategoryElement(category, doc, root);
        }
        for (RepositoryQuery query : taskList.getQueries()) {
            this.delegatingExternalizer.createQueryElement(query, doc, root);
        }
        for (Node node : this.orphanedNodes) {
            Node tempNode = doc.importNode(node, true);
            if (tempNode == null) continue;
            root.appendChild(tempNode);
        }
        if (this.delegatingExternalizer.getErrorStatus() != null) {
            StatusHandler.log((IStatus)this.delegatingExternalizer.getErrorStatus());
        }
        return doc;
    }

    private void writeDocument(Document doc, OutputStream outputStream) throws CoreException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputStream);
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty(TRANSFORM_PROPERTY_VERSION, XML_VERSION);
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed write task list", (Throwable)e));
        }
    }

    private Document createDocument() throws CoreException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to create document", (Throwable)e));
        }
    }

    public void readTaskList(ITransferList taskList, File inFile) throws CoreException {
        Object child;
        if (!inFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task list file not found \"" + inFile.getAbsolutePath() + "\""));
        }
        if (inFile.length() == 0L) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task list file contains no data \"" + inFile.getAbsolutePath() + "\""));
        }
        this.delegatingExternalizer.reset();
        this.orphanedNodes.clear();
        try {
            this.orphanedDocument = this.createDocument();
        }
        catch (CoreException e) {
            this.orphanedDocument = null;
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to create document for orphaned nodes", (Throwable)e));
        }
        Document doc = this.openTaskList(inFile);
        Element root = doc.getDocumentElement();
        this.readVersion = root.getAttribute(ATTRIBUTE_VERSION);
        if (this.readVersion.equals(VALUE_VERSION_1_0_0)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task list version \"" + this.readVersion + "\" not supported"));
        }
        NodeList list = root.getChildNodes();
        HashMap<AbstractTask, NodeList> tasksWithSubtasks = new HashMap<AbstractTask, NodeList>();
        int i = 0;
        while (i < list.getLength()) {
            child = list.item(i);
            if (!child.getNodeName().endsWith("Category") && !child.getNodeName().endsWith("Query")) {
                AbstractTask task = this.delegatingExternalizer.readTask((Node)child, null, null);
                if (task != null) {
                    taskList.addTask(task);
                    if (child.getChildNodes() != null && child.getChildNodes().getLength() > 0) {
                        tasksWithSubtasks.put(task, child.getChildNodes());
                    }
                } else {
                    this.addOrphan((Node)child);
                }
            }
            ++i;
        }
        for (AbstractTask task : tasksWithSubtasks.keySet()) {
            NodeList nodes = (NodeList)tasksWithSubtasks.get(task);
            this.delegatingExternalizer.readTaskReferences(task, nodes, taskList);
        }
        i = 0;
        while (i < list.getLength()) {
            child = list.item(i);
            if (child.getNodeName().endsWith("Query")) {
                RepositoryQuery query = this.delegatingExternalizer.readQuery((Node)child);
                if (query != null) {
                    taskList.addQuery(query);
                    if (child.getChildNodes() != null && child.getChildNodes().getLength() > 0) {
                        this.delegatingExternalizer.readTaskReferences(query, child.getChildNodes(), taskList);
                    }
                } else {
                    this.addOrphan((Node)child);
                }
            }
            ++i;
        }
        i = 0;
        while (i < list.getLength()) {
            child = list.item(i);
            if (child.getNodeName().endsWith("Category")) {
                this.delegatingExternalizer.readCategory((Node)child, taskList);
            }
            ++i;
        }
        Map<AbstractTask, String> legacyParentCategoryMap = this.delegatingExternalizer.getLegacyParentCategoryMap();
        if (legacyParentCategoryMap.size() > 0) {
            for (AbstractTask task : legacyParentCategoryMap.keySet()) {
                AbstractTaskCategory category = taskList.getContainerForHandle(legacyParentCategoryMap.get(task));
                if (category == null) continue;
                taskList.addTask(task, category);
            }
        }
    }

    private void addOrphan(Node child) {
        if (this.orphanedDocument != null) {
            this.orphanedNodes.add(this.orphanedDocument.importNode(child, true));
        } else {
            this.orphanedNodes.add(child);
        }
    }

    private Document openTaskList(File inputFile) throws CoreException {
        InputStream in = null;
        try {
            if (inputFile.getName().endsWith(".xml.zip")) {
                in = new ZipInputStream(new FileInputStream(inputFile));
                ZipEntry entry = ((ZipInputStream)in).getNextEntry();
                while (entry != null) {
                    if ("tasklist.xml".equals(entry.getName())) break;
                    entry = ((ZipInputStream)in).getNextEntry();
                }
                if (entry == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task list file contains no entry for the task list"));
                }
            } else {
                in = new FileInputStream(inputFile);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            return document;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", ERROR_TASKLIST_READ, (Throwable)e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to close task list", (Throwable)e));
                }
            }
        }
    }
}

