/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public class ModuleProperties {
    private static final String MODULE_DATA_FILE = "modules.xml";
    protected static ModuleProperties instance;
    protected Map<String, String> modules;

    protected ModuleProperties() {
        this.load();
        instance = this;
    }

    public static ModuleProperties getInstance() {
        if (instance == null) {
            new ModuleProperties();
        }
        return instance;
    }

    private void load() {
        Trace.trace(5, "Loading module info");
        String filename = ServerPlugin.getInstance().getStateLocation().append(MODULE_DATA_FILE).toOSString();
        this.modules = new HashMap<String, String>();
        if (!new File(filename).exists()) {
            return;
        }
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("module");
            int size = children.length;
            int i = 0;
            while (i < size) {
                String moduleId = children[i].getString("moduleId");
                String serverId = children[i].getString("serverId");
                this.modules.put(moduleId, serverId);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(2, "Could not load servers", e);
        }
    }

    private void save(IProgressMonitor monitor) throws CoreException {
        String filename = ServerPlugin.getInstance().getStateLocation().append(MODULE_DATA_FILE).toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("modules");
            for (String moduleId : this.modules.keySet()) {
                String serverId = this.modules.get(moduleId);
                IMemento child = memento.createChild("module");
                child.putString("moduleId", moduleId);
                child.putString("serverId", serverId);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(3, "Could not save servers", e);
        }
    }

    public IServer getDefaultServer(IModule module) {
        if (module == null) {
            throw new IllegalArgumentException();
        }
        String serverId = this.modules.get(module.getId());
        if (serverId == null || serverId.length() == 0) {
            return null;
        }
        IServer server = ServerCore.findServer(serverId);
        if (server == null) {
            this.modules.remove(module.getId());
        }
        return server;
    }

    public void setDefaultServer(IModule module, IServer server, IProgressMonitor monitor) throws CoreException {
        String serverId;
        if (module == null) {
            throw new IllegalArgumentException();
        }
        String newServerId = null;
        if (server != null) {
            newServerId = server.getId();
        }
        if ((serverId = this.modules.get(module.getId())) == null && newServerId == null) {
            return;
        }
        if (serverId != null && serverId.equals(newServerId)) {
            return;
        }
        this.modules.put(module.getId(), newServerId);
        this.save(monitor);
    }

    public String toString() {
        return "ModuleProperties[]";
    }
}

