/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.ui.IEngineDescriptor;
import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.search.HelpCriteriaContentProvider;
import org.eclipse.help.ui.internal.search.HelpCriteriaLabelProvider;
import org.eclipse.help.ui.internal.search.HelpWorkingSetElementLabelProvider;
import org.eclipse.help.ui.internal.search.HelpWorkingSetTreeContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class LocalHelpPage
extends RootScopePage {
    private Button searchAll;
    private Button searchSelected;
    private CheckboxTreeViewer contentTree;
    private ITreeContentProvider contentTreeContentProvider;
    private ILabelProvider contentTreeLabelProvider;
    private CheckboxTreeViewer criteriaTree;
    private ITreeContentProvider criteriaTreeContentProvider;
    private ILabelProvider criteriaTreeLabelProvider;
    private WorkingSet workingSet;

    public void init(IEngineDescriptor ed, String scopeSetName) {
        super.init(ed, scopeSetName);
        if (scopeSetName != null) {
            this.workingSet = BaseHelpSystem.getWorkingSetManager().getWorkingSet(scopeSetName);
        }
    }

    protected int createScopeContents(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        this.searchAll = new Button(parent, 16);
        this.searchAll.setText(Messages.selectAll);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchAll.setLayoutData((Object)gd);
        this.searchAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalHelpPage.this.contentTree.getTree().setEnabled(false);
                if (LocalHelpPage.this.criteriaTree != null) {
                    LocalHelpPage.this.criteriaTree.getTree().setEnabled(false);
                }
            }
        });
        this.searchSelected = new Button(parent, 16);
        this.searchSelected.setText(Messages.selectWorkingSet);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.searchSelected.setLayoutData((Object)gd);
        this.searchSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalHelpPage.this.contentTree.getTree().setEnabled(true);
                if (LocalHelpPage.this.criteriaTree != null) {
                    LocalHelpPage.this.criteriaTree.getTree().setEnabled(true);
                }
            }
        });
        if (this.workingSet == null) {
            this.searchAll.setSelection(true);
        } else {
            this.searchSelected.setSelection(true);
        }
        Label contentLabel = new Label(parent, 64);
        contentLabel.setFont(font);
        contentLabel.setText(Messages.WorkingSetContent);
        gd = new GridData(772);
        gd.horizontalSpan = 2;
        contentLabel.setLayoutData((Object)gd);
        this.createContentTree(parent, font);
        if (HelpPlugin.getCriteriaManager().isCriteriaEnabled()) {
            Label criteriaLabel = new Label(parent, 64);
            criteriaLabel.setFont(font);
            criteriaLabel.setText(Messages.WorkingSetCriteria);
            gd = new GridData(772);
            gd.horizontalSpan = 2;
            criteriaLabel.setLayoutData((Object)gd);
            this.createCriteriaTree(parent, font);
        }
        this.initializeCheckedState();
        this.applyDialogFont(parent);
        return 1;
    }

    protected void createContentTree(Composite parent, Font font) {
        this.contentTree = new CheckboxTreeViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = this.getTreeHeightHint();
        gd.horizontalSpan = 2;
        this.contentTree.getControl().setLayoutData((Object)gd);
        this.contentTree.getControl().setFont(font);
        this.contentTreeContentProvider = new HelpWorkingSetTreeContentProvider();
        this.contentTree.setContentProvider((IContentProvider)this.contentTreeContentProvider);
        this.contentTreeLabelProvider = new HelpWorkingSetElementLabelProvider();
        this.contentTree.setLabelProvider((IBaseLabelProvider)this.contentTreeLabelProvider);
        this.contentTree.setUseHashlookup(true);
        this.contentTree.setInput((Object)BaseHelpSystem.getWorkingSetManager().getRoot());
        this.contentTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LocalHelpPage.this.handleCheckStateChange(event, LocalHelpPage.this.contentTree, LocalHelpPage.this.contentTreeContentProvider);
            }
        });
        this.contentTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!LocalHelpPage.this.contentTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)LocalHelpPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            4.access$0(this.this$1).setSubtreeChecked(this.val$element, LocalHelpPage.access$0(4.access$0(this.this$1)).getChecked(this.val$element), false, LocalHelpPage.access$0(4.access$0(this.this$1)), LocalHelpPage.access$2(4.access$0(this.this$1)));
                        }
                    });
                }
            }

            static /* synthetic */ LocalHelpPage access$0(4 var0) {
                return var0.LocalHelpPage.this;
            }
        });
        this.contentTree.getTree().setEnabled(this.workingSet != null);
    }

    protected int getTreeHeightHint() {
        if (HelpPlugin.getCriteriaManager().isCriteriaEnabled()) {
            return this.convertHeightInCharsToPixels(8);
        }
        return this.convertHeightInCharsToPixels(15);
    }

    protected void createCriteriaTree(Composite parent, Font font) {
        this.criteriaTree = new CheckboxTreeViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = this.getTreeHeightHint();
        gd.horizontalSpan = 2;
        this.criteriaTree.getControl().setLayoutData((Object)gd);
        this.criteriaTree.getControl().setFont(font);
        this.criteriaTreeContentProvider = new HelpCriteriaContentProvider();
        this.criteriaTree.setContentProvider((IContentProvider)this.criteriaTreeContentProvider);
        this.criteriaTreeLabelProvider = new HelpCriteriaLabelProvider();
        this.criteriaTree.setLabelProvider((IBaseLabelProvider)this.criteriaTreeLabelProvider);
        this.criteriaTree.setUseHashlookup(true);
        this.criteriaTree.setInput((Object)BaseHelpSystem.getWorkingSetManager().getCriterionIds());
        this.criteriaTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LocalHelpPage.this.handleCheckStateChange(event, LocalHelpPage.this.criteriaTree, LocalHelpPage.this.criteriaTreeContentProvider);
            }
        });
        this.criteriaTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!LocalHelpPage.this.criteriaTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)LocalHelpPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            7.access$0(this.this$1).setSubtreeChecked(this.val$element, LocalHelpPage.access$1(7.access$0(this.this$1)).getChecked(this.val$element), false, LocalHelpPage.access$1(7.access$0(this.this$1)), LocalHelpPage.access$3(7.access$0(this.this$1)));
                        }
                    });
                }
            }

            static /* synthetic */ LocalHelpPage access$0(7 var0) {
                return var0.LocalHelpPage.this;
            }
        });
        this.criteriaTree.getTree().setEnabled(this.workingSet != null);
    }

    private void initializeCheckedState() {
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LocalHelpPage.this.initializeContentTree();
                if (HelpPlugin.getCriteriaManager().isCriteriaEnabled()) {
                    LocalHelpPage.this.initializeCriteriaTree();
                }
            }
        });
    }

    boolean isExpandable(Object element, ITreeContentProvider contentProvider) {
        return contentProvider.hasChildren(element);
    }

    void updateParentState(Object child, boolean baseChildState, CheckboxTreeViewer tree, ITreeContentProvider contentProvider) {
        if (child == null) {
            return;
        }
        Object parent = contentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = contentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (tree.getChecked(children[i]) != baseChildState || tree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        tree.setGrayed(parent, !allSameState);
        tree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState, tree, contentProvider);
    }

    void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState, CheckboxTreeViewer tree, ITreeContentProvider contentProvider) {
        Object[] children = contentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                tree.setChecked(element, true);
                tree.setGrayed(element, false);
            } else {
                tree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element, contentProvider)) {
                this.setSubtreeChecked(element, state, checkExpandedState, tree, contentProvider);
            }
            --i;
        }
    }

    private void findCheckedElements(List checkedResources, Object parent, CheckboxTreeViewer tree, ITreeContentProvider contentProvider) {
        Object[] children = contentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (tree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i], tree, contentProvider);
            } else if (tree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    private CriterionResource[] findCheckedCriteria(Object parent, CheckboxTreeViewer tree, ITreeContentProvider contentProvider) {
        Object[] children = contentProvider.getChildren(parent);
        ArrayList<CriterionResource> resources = new ArrayList<CriterionResource>();
        int i = 0;
        while (i < children.length) {
            HelpCriteriaContentProvider.CriterionName name = (HelpCriteriaContentProvider.CriterionName)children[i];
            CriterionResource resource = new CriterionResource(name.getId());
            Object[] grandChildren = contentProvider.getChildren((Object)name);
            int j = 0;
            while (j < grandChildren.length) {
                if (tree.getChecked(grandChildren[j])) {
                    HelpCriteriaContentProvider.CriterionValue value = (HelpCriteriaContentProvider.CriterionValue)grandChildren[j];
                    resource.addCriterionValue(value.getId());
                }
                ++j;
            }
            if (resource.getCriterionValues().size() > 0) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new CriterionResource[resources.size()]);
    }

    void handleCheckStateChange(final CheckStateChangedEvent event, final CheckboxTreeViewer tree, final ITreeContentProvider contentProvider) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object element = event.getElement();
                boolean state = event.getChecked();
                tree.setGrayed(element, false);
                if (LocalHelpPage.this.isExpandable(element, contentProvider)) {
                    LocalHelpPage.this.setSubtreeChecked(element, state, state, tree, contentProvider);
                }
                LocalHelpPage.this.updateParentState(element, state, tree, contentProvider);
            }
        });
    }

    public WorkingSet getWorkingSet() {
        ArrayList elements = new ArrayList(10);
        CriterionResource[] criteria = !HelpPlugin.getCriteriaManager().isCriteriaEnabled() ? new CriterionResource[]{} : this.findCheckedCriteria(this.criteriaTree.getInput(), this.criteriaTree, this.criteriaTreeContentProvider);
        this.findCheckedElements(elements, this.contentTree.getInput(), this.contentTree, this.contentTreeContentProvider);
        if (this.workingSet == null) {
            this.workingSet = new WorkingSet(this.getScopeSetName(), elements.toArray(new AdaptableHelpResource[elements.size()]), criteria);
        } else {
            this.workingSet.setName(this.getScopeSetName());
            this.workingSet.setElements(elements.toArray(new AdaptableHelpResource[elements.size()]));
            this.workingSet.setCriteria(criteria);
        }
        return this.workingSet;
    }

    public boolean performOk() {
        if (this.searchSelected.getSelection()) {
            BaseHelpSystem.getWorkingSetManager().addWorkingSet(this.getWorkingSet());
        } else {
            BaseHelpSystem.getWorkingSetManager().removeWorkingSet(this.getWorkingSet());
        }
        this.getPreferenceStore().setValue(this.getKey("workingSet"), this.getScopeSetName());
        this.getPreferenceStore().setValue(this.getKey("capabilityFiltering"), false);
        return super.performOk();
    }

    private String getKey(String key) {
        return String.valueOf(this.getEngineDescriptor().getId()) + "." + key;
    }

    protected void initializeContentTree() {
        Object[] elements = this.workingSet.getElements();
        this.contentTree.setCheckedElements(elements);
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (this.isExpandable(element, this.contentTreeContentProvider)) {
                this.setSubtreeChecked(element, true, true, this.contentTree, this.contentTreeContentProvider);
            }
            this.updateParentState(element, true, this.contentTree, this.contentTreeContentProvider);
            ++i;
        }
    }

    protected void initializeCriteriaTree() {
        Object[] criteria = this.workingSet.getCriteria();
        this.criteriaTree.setCheckedElements(criteria);
        int i = 0;
        while (i < criteria.length) {
            Object element = criteria[i];
            HelpCriteriaContentProvider.CriterionName name = new HelpCriteriaContentProvider.CriterionName(element.getCriterionName(), null);
            List values = element.getCriterionValues();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String valueString = (String)iter.next();
                HelpCriteriaContentProvider.CriterionValue value = new HelpCriteriaContentProvider.CriterionValue(valueString, name);
                this.criteriaTree.setChecked((Object)value, true);
                this.updateParentState(value, true, this.criteriaTree, this.criteriaTreeContentProvider);
            }
            ++i;
        }
    }
}

