/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.core.service.Marketplace;
import org.eclipse.epp.internal.mpc.core.service.MarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.core.service.NodeListing;
import org.eclipse.epp.internal.mpc.core.service.Search;
import org.eclipse.epp.internal.mpc.core.service.SearchResult;
import org.eclipse.epp.internal.mpc.core.service.ServiceUnavailableException;
import org.eclipse.epp.internal.mpc.core.service.xml.Unmarshaller;
import org.eclipse.equinox.internal.p2.repository.RepositoryTransport;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarketplaceService
implements MarketplaceService {
    private static final String API_URI_SUFFIX = "api/p";
    private static final String UTF_8 = "UTF-8";
    public static final String DEFAULT_SERVICE_LOCATION = System.getProperty(String.valueOf(MarketplaceService.class.getName()) + ".url", "http://marketplace.eclipse.org");
    public static final String META_PARAM_CLIENT = "client";
    public static final String META_PARAM_WS = "ws";
    public static final String META_PARAM_OS = "os";
    public static final String META_PARAM_JAVA_VERSION = "java.version";
    public static final String META_PARAM_RUNTIME_VERSION = "runtime.version";
    public static final String META_PARAM_PRODUCT_VERSION = "product.version";
    public static final String META_PARAM_PRODUCT = "product";
    private URL baseUrl;
    private Map<String, String> requestMetaParameters;

    public DefaultMarketplaceService(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public DefaultMarketplaceService() {
        try {
            this.baseUrl = new URL(DEFAULT_SERVICE_LOCATION);
        }
        catch (MalformedURLException e) {
            MarketplaceClientCore.error(e);
            this.baseUrl = null;
        }
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public List<Market> listMarkets(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = this.processRequest(API_URI_SUFFIX, monitor);
        return marketplace.getMarket();
    }

    @Override
    public Market getMarket(Market market, IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = this.processRequest(market.getUrl(), API_URI_SUFFIX, monitor);
        if (marketplace.getMarket().isEmpty()) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_marketNotFound, null));
        }
        if (marketplace.getMarket().size() > 1) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        return marketplace.getMarket().get(0);
    }

    @Override
    public Category getCategory(Category category, IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = this.processRequest(category.getUrl(), API_URI_SUFFIX, monitor);
        if (marketplace.getCategory().isEmpty()) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_categoryNotFound, null));
        }
        if (marketplace.getCategory().size() > 1) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        return marketplace.getCategory().get(0);
    }

    @Override
    public Node getNode(Node node, IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace;
        if (node.getId() != null) {
            String encodedId;
            try {
                encodedId = URLEncoder.encode(node.getId(), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            marketplace = this.processRequest("node/" + encodedId + '/' + API_URI_SUFFIX, monitor);
        } else {
            marketplace = this.processRequest(node.getUrl(), API_URI_SUFFIX, monitor);
        }
        if (marketplace.getNode().isEmpty()) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_nodeNotFound, null));
        }
        if (marketplace.getNode().size() > 1) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        return marketplace.getNode().get(0);
    }

    @Override
    public SearchResult search(Market market, Category category, String queryText, IProgressMonitor monitor) throws CoreException {
        SearchResult result = new SearchResult();
        if (queryText == null || queryText.trim().length() == 0) {
            result.setMatchCount(0);
            result.setNodes(new ArrayList<Node>());
        } else {
            String relativeUrl;
            try {
                relativeUrl = "api/p/search/apachesolr_search/" + URLEncoder.encode(queryText.trim(), UTF_8);
                String queryString = "";
                if (market != null || category != null) {
                    queryString = String.valueOf(queryString) + "filters=";
                    if (market != null) {
                        queryString = String.valueOf(queryString) + "tid:" + URLEncoder.encode(market.getId(), UTF_8);
                        if (category != null) {
                            queryString = String.valueOf(queryString) + "%20";
                        }
                    }
                    if (category != null) {
                        queryString = String.valueOf(queryString) + "tid:" + URLEncoder.encode(category.getId(), UTF_8);
                    }
                }
                if (queryString.length() > 0) {
                    relativeUrl = String.valueOf(relativeUrl) + '?' + queryString;
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException();
            }
            Marketplace marketplace = this.processRequest(relativeUrl, monitor);
            Search search = marketplace.getSearch();
            if (search == null) {
                throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
            }
            result.setMatchCount(search.getCount());
            result.setNodes(search.getNode());
        }
        return result;
    }

    @Override
    public SearchResult featured(IProgressMonitor monitor) throws CoreException {
        return this.featured(monitor, null, null);
    }

    @Override
    public SearchResult featured(IProgressMonitor monitor, Market market, Category category) throws CoreException {
        String nodePart = "";
        try {
            if (market != null) {
                nodePart = String.valueOf(nodePart) + URLEncoder.encode(market.getId(), UTF_8);
            }
            if (category != null) {
                if (nodePart.length() > 0) {
                    nodePart = String.valueOf(nodePart) + ",";
                }
                nodePart = String.valueOf(nodePart) + URLEncoder.encode(category.getId(), UTF_8);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException();
        }
        String uri = "featured/";
        if (nodePart.length() > 0) {
            uri = String.valueOf(uri) + nodePart + '/';
        }
        Marketplace marketplace = this.processRequest(String.valueOf(uri) + API_URI_SUFFIX, monitor);
        return this.createSearchResult(marketplace.getFeatured());
    }

    @Override
    public SearchResult recent(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = this.processRequest("recent/api/p", monitor);
        return this.createSearchResult(marketplace.getRecent());
    }

    @Override
    public SearchResult favorites(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = this.processRequest("favorites/top/api/p", monitor);
        return this.createSearchResult(marketplace.getFavorites());
    }

    @Override
    public SearchResult popular(IProgressMonitor monitor) throws CoreException {
        Marketplace marketplace = this.processRequest("popular/top/api/p", monitor);
        return this.createSearchResult(marketplace.getPopular());
    }

    protected SearchResult createSearchResult(NodeListing nodeList) throws CoreException {
        if (nodeList == null) {
            throw new CoreException(this.createErrorStatus(Messages.DefaultMarketplaceService_unexpectedResponse, null));
        }
        SearchResult result = new SearchResult();
        result.setMatchCount(nodeList.getCount());
        result.setNodes(nodeList.getNode());
        return result;
    }

    @Override
    public void reportInstallError(IProgressMonitor monitor, IStatus result, Set<Node> nodes, Set<String> iuIdsAndVersions, String resolutionDetails) throws CoreException {
        PostMethod method;
        URL location;
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"org.eclipse.epp.mpc.core");
        try {
            location = new URL(this.baseUrl, "install/error/report");
            method = new PostMethod(location.toURI().toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        try {
            try {
                ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
                parameters.add(new NameValuePair("status", Integer.toString(result.getSeverity())));
                parameters.add(new NameValuePair("statusMessage", result.getMessage()));
                for (Node node : nodes) {
                    parameters.add(new NameValuePair("node", node.getId()));
                }
                if (iuIdsAndVersions != null && !iuIdsAndVersions.isEmpty()) {
                    for (String iuAndVersion : iuIdsAndVersions) {
                        parameters.add(new NameValuePair("iu", iuAndVersion));
                    }
                }
                parameters.add(new NameValuePair("detailedMessage", resolutionDetails));
                if (!parameters.isEmpty()) {
                    method.setRequestBody(parameters.toArray(new NameValuePair[parameters.size()]));
                    client.executeMethod((HttpMethod)method);
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.DefaultMarketplaceService_cannotCompleteRequest_reason, (Object)location.toString(), (Object)e.getMessage());
                throw new CoreException(this.createErrorStatus(message, e));
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private void checkConfiguration() {
        if (this.baseUrl == null) {
            throw new IllegalStateException(Messages.DefaultMarketplaceService_mustConfigureBaseUrl);
        }
    }

    private Marketplace processRequest(String relativeUrl, IProgressMonitor monitor) throws CoreException {
        URI baseUri;
        try {
            baseUri = this.baseUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return this.processRequest(baseUri.toString(), relativeUrl, monitor);
    }

    private Marketplace processRequest(String baseUri, String relativePath, IProgressMonitor monitor) throws CoreException {
        URI location;
        this.checkConfiguration();
        if (baseUri == null || relativePath == null) {
            throw new IllegalArgumentException();
        }
        String uri = baseUri;
        if (!uri.endsWith("/") && !relativePath.startsWith("/")) {
            uri = String.valueOf(uri) + '/';
        }
        uri = String.valueOf(uri) + relativePath;
        if (this.requestMetaParameters != null) {
            try {
                boolean hasQueryString = uri.indexOf(63) != -1;
                for (Map.Entry<String, String> param : this.requestMetaParameters.entrySet()) {
                    if (param.getKey() == null) continue;
                    if (hasQueryString) {
                        uri = String.valueOf(uri) + '&';
                    } else {
                        hasQueryString = true;
                        uri = String.valueOf(uri) + '?';
                    }
                    uri = String.valueOf(uri) + URLEncoder.encode(param.getKey(), UTF_8);
                    uri = String.valueOf(uri) + '=';
                    if (param.getValue() == null) continue;
                    uri = String.valueOf(uri) + URLEncoder.encode(param.getValue(), UTF_8);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            location = new URI(uri);
        }
        catch (URISyntaxException e) {
            String message = NLS.bind((String)Messages.DefaultMarketplaceService_invalidLocation, (Object)uri);
            throw new CoreException(this.createErrorStatus(message, e));
        }
        Unmarshaller unmarshaller = new Unmarshaller();
        monitor.beginTask(NLS.bind((String)Messages.DefaultMarketplaceService_retrievingDataFrom, (Object)baseUri), 100);
        try {
            try {
                InputStream in;
                XMLReader xmlReader;
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setNamespaceAware(true);
                try {
                    xmlReader = parserFactory.newSAXParser().getXMLReader();
                }
                catch (Exception e1) {
                    throw new IllegalStateException(e1);
                }
                xmlReader.setContentHandler(unmarshaller);
                try {
                    in = RepositoryTransport.getInstance().stream(location, monitor);
                }
                catch (CoreException e) {
                    Throwable cause;
                    if (e.getStatus().getCode() == 1002 && (cause = e.getCause()) != null && cause.getMessage() != null && cause.getMessage().indexOf("503") != -1) {
                        throw new ServiceUnavailableException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", 503, Messages.DefaultMarketplaceService_serviceUnavailable503, (Throwable)e));
                    }
                    throw e;
                }
                catch (NullPointerException e) {
                    in = location.toURL().openStream();
                }
                try {
                    monitor.worked(30);
                    InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), UTF_8);
                    try {
                        xmlReader.parse(new InputSource(reader));
                    }
                    catch (SAXException e) {
                        MarketplaceClientCore.error(NLS.bind((String)Messages.DefaultMarketplaceService_parseError, (Object)location.toString()), e);
                        throw new IOException(e.getMessage()){

                            public Throwable getCause() {
                                return e;
                            }
                        };
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof OperationCanceledException) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                String message = NLS.bind((String)Messages.DefaultMarketplaceService_cannotCompleteRequest_reason, (Object)location.toString(), (Object)e.getMessage());
                throw new CoreException(this.createErrorStatus(message, e));
            }
        }
        finally {
            monitor.done();
        }
        Object model = unmarshaller.getModel();
        if (model == null) {
            throw new IllegalStateException();
        }
        if (model instanceof Marketplace) {
            return (Marketplace)model;
        }
        String message = NLS.bind((String)Messages.DefaultMarketplaceService_unexpectedResponseContent, (Object)model.getClass().getSimpleName());
        throw new CoreException(this.createErrorStatus(message, null));
    }

    private IStatus createErrorStatus(String message, Throwable t) {
        return new Status(4, "org.eclipse.epp.mpc.core", 0, message, t);
    }

    public Map<String, String> getRequestMetaParameters() {
        return this.requestMetaParameters;
    }

    public void setRequestMetaParameters(Map<String, String> requestMetaParameters) {
        this.requestMetaParameters = requestMetaParameters;
    }
}

