/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerWizard;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.WizardPropertyPage;

public class ClasspathContainerPreferencePage
extends WizardPropertyPage {
    private IJavaProject fJavaProject;
    private IClasspathEntry fEntry;
    static /* synthetic */ Class class$0;

    public ClasspathContainerPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void setElement(IAdaptable element) {
        ClassPathContainer container;
        super.setElement(element);
        if (element instanceof ClassPathContainer) {
            container = (ClassPathContainer)element;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.internal.ui.packageview.ClassPathContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            container = (ClassPathContainer)element.getAdapter((Class)clazz);
        }
        this.fJavaProject = container.getJavaProject();
        this.fEntry = container.getClasspathEntry();
    }

    protected IWizard createWizard() {
        try {
            IJavaProject project = this.fJavaProject;
            IClasspathEntry[] entries = project.getRawClasspath();
            return new ClasspathContainerWizard(this.fEntry, project, entries);
        }
        catch (JavaModelException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
            return null;
        }
    }

    protected void applyChanges() {
        IClasspathEntry[] created = ((ClasspathContainerWizard)this.getWizard()).getNewEntries();
        if (created == null || created.length != 1) {
            return;
        }
        final IClasspathEntry result = created[0];
        if (result == null || result.equals(this.fEntry)) {
            return;
        }
        try {
            IClasspathEntry[] entries = this.fJavaProject.getRawClasspath();
            int idx = ClasspathContainerPreferencePage.indexInClasspath(entries, this.fEntry);
            if (idx == -1) {
                return;
            }
            final IClasspathEntry[] newEntries = new IClasspathEntry[entries.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[idx] = result;
            ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
            context = PlatformUI.getWorkbench().getProgressService();
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IPath path;
                        String eeID;
                        if (result.getEntryKind() == 5 && (eeID = JavaRuntime.getExecutionEnvironmentId((IPath)(path = result.getPath()))) != null) {
                            BuildPathSupport.setEEComplianceOptions(ClasspathContainerPreferencePage.this.fJavaProject, eeID, null);
                        }
                        ClasspathContainerPreferencePage.this.fJavaProject.setRawClasspath(newEntries, ClasspathContainerPreferencePage.this.fJavaProject.getOutputLocation(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.fEntry = result;
        }
        catch (JavaModelException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
        }
        catch (InvocationTargetException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_applyingfailed_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static int indexInClasspath(IClasspathEntry[] entries, IClasspathEntry entry) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].equals(entry)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

