/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.rules;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.ui.internal.Logger;

class PresentationCollector
extends AbstractCollection {
    private final TextPresentation fPresentation;
    private int lastOffset;

    PresentationCollector(TextPresentation presentation) {
        Assert.isNotNull((Object)presentation);
        this.fPresentation = presentation;
        this.lastOffset = 0;
    }

    public boolean add(Object o) {
        StyleRange range = (StyleRange)o;
        if (this.lastOffset > range.start) {
            IllegalArgumentException e = new IllegalArgumentException("Overlapping start in StyleRange " + range.start + ":" + range.length);
            Logger.logException(e);
            throw e;
        }
        this.lastOffset = range.start + range.length;
        this.fPresentation.addStyleRange(range);
        return true;
    }

    public Iterator iterator() {
        return this.fPresentation.getNonDefaultStyleRangeIterator();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }
}

