/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class Get
extends Task {
    private static final int NUMBER_RETRIES = 3;
    private static final int DOTS_PER_LINE = 50;
    private static final int BIG_BUFFER_SIZE = 102400;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private URL source;
    private File dest;
    private boolean verbose = false;
    private boolean useTimestamp = false;
    private boolean ignoreErrors = false;
    private String uname = null;
    private String pword = null;

    public void execute() throws BuildException {
        block3: {
            int logLevel = 2;
            VerboseProgress progress = null;
            if (this.verbose) {
                progress = new VerboseProgress(System.out);
            }
            try {
                this.doGet(logLevel, progress);
            }
            catch (IOException ioe) {
                this.log("Error getting " + this.source + " to " + this.dest);
                if (this.ignoreErrors) break block3;
                throw new BuildException(ioe, this.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doGet(int logLevel, DownloadProgress progress) throws IOException {
        this.checkAttributes();
        if (progress == null) {
            progress = new NullProgress();
        }
        this.log("Getting: " + this.source, logLevel);
        this.log("To: " + this.dest.getAbsolutePath(), logLevel);
        long timestamp = 0L;
        boolean hasTimestamp = false;
        if (this.useTimestamp && this.dest.exists()) {
            timestamp = this.dest.lastModified();
            if (this.verbose) {
                Date t = new Date(timestamp);
                this.log("local file date : " + t.toString(), logLevel);
            }
            hasTimestamp = true;
        }
        URLConnection connection = this.source.openConnection();
        if (hasTimestamp) {
            connection.setIfModifiedSince(timestamp);
        }
        if (this.uname != null || this.pword != null) {
            String up = this.uname + ":" + this.pword;
            Base64Converter encoder = new Base64Converter();
            String encoding = encoder.encode(up.getBytes());
            connection.setRequestProperty("Authorization", "Basic " + encoding);
        }
        connection.connect();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            long lastModified = httpConnection.getLastModified();
            if (httpConnection.getResponseCode() == 304 || lastModified != 0L && hasTimestamp && timestamp >= lastModified) {
                this.log("Not modified - so not downloaded", logLevel);
                return false;
            }
            if (httpConnection.getResponseCode() == 401) {
                String message = "HTTP Authorization failure";
                if (this.ignoreErrors) {
                    this.log(message, logLevel);
                    return false;
                }
                throw new BuildException(message);
            }
        }
        InputStream is = null;
        for (int i = 0; i < 3; ++i) {
            try {
                is = connection.getInputStream();
                break;
            }
            catch (IOException ex) {
                this.log("Error opening connection " + ex, logLevel);
                continue;
            }
        }
        if (is == null) {
            this.log("Can't get " + this.source + " to " + this.dest, logLevel);
            if (this.ignoreErrors) {
                return false;
            }
            throw new BuildException("Can't get " + this.source + " to " + this.dest, this.getLocation());
        }
        FileOutputStream fos = new FileOutputStream(this.dest);
        progress.beginDownload();
        boolean finished = false;
        try {
            int length;
            byte[] buffer = new byte[102400];
            while ((length = is.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
                progress.onTick();
            }
            finished = true;
            Object var13_18 = null;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            FileUtils.close(fos);
            FileUtils.close(is);
            if (!finished) {
                this.dest.delete();
            }
            throw throwable;
        }
        FileUtils.close(fos);
        FileUtils.close(is);
        if (!finished) {
            this.dest.delete();
        }
        progress.endDownload();
        if (this.useTimestamp) {
            long remoteTimestamp = connection.getLastModified();
            if (this.verbose) {
                Date t = new Date(remoteTimestamp);
                this.log("last modified = " + t.toString() + (remoteTimestamp == 0L ? " - using current time instead" : ""), logLevel);
            }
            if (remoteTimestamp != 0L) {
                FILE_UTILS.setFileLastModified(this.dest, remoteTimestamp);
            }
        }
        return true;
    }

    private void checkAttributes() {
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.getLocation());
        }
        if (this.dest == null) {
            throw new BuildException("dest attribute is required", this.getLocation());
        }
        if (this.dest.exists() && this.dest.isDirectory()) {
            throw new BuildException("The specified destination is a directory", this.getLocation());
        }
        if (this.dest.exists() && !this.dest.canWrite()) {
            throw new BuildException("Can't write to " + this.dest.getAbsolutePath(), this.getLocation());
        }
    }

    public void setSrc(URL u) {
        this.source = u;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setIgnoreErrors(boolean v) {
        this.ignoreErrors = v;
    }

    public void setUseTimestamp(boolean v) {
        this.useTimestamp = v;
    }

    public void setUsername(String u) {
        this.uname = u;
    }

    public void setPassword(String p) {
        this.pword = p;
    }

    protected static class Base64Converter
    extends org.apache.tools.ant.util.Base64Converter {
        protected Base64Converter() {
        }
    }

    public static interface DownloadProgress {
        public void beginDownload();

        public void onTick();

        public void endDownload();
    }

    public static class NullProgress
    implements DownloadProgress {
        public void beginDownload() {
        }

        public void onTick() {
        }

        public void endDownload() {
        }
    }

    public static class VerboseProgress
    implements DownloadProgress {
        private int dots = 0;
        PrintStream out;

        public VerboseProgress(PrintStream out) {
            this.out = out;
        }

        public void beginDownload() {
            this.dots = 0;
        }

        public void onTick() {
            this.out.print(".");
            if (this.dots++ > 50) {
                this.out.flush();
                this.dots = 0;
            }
        }

        public void endDownload() {
            this.out.println();
            this.out.flush();
        }
    }
}

